<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

    <style>
        .whyus-section {
            position: relative;
            padding: 20px 20px;
            color: #fff;
            overflow: hidden;
        }

        .whyus-overlay {
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.25);
        }

        .whyus-container {
            position: relative;
            max-width: 1200px;
            margin: auto;
            text-align: center;
        }

        .whyus-title {
            font-size: 32px;
            font-weight: 600;
            margin-bottom: 10px;
        }

        .dt-heading-line {
            display: block;
            width: 50px;
            height: 3px;
            background-color: #f36b21;
            margin: 0 auto 20px auto;
        }

        .whyus-subtitle {
            max-width: 900px;
            margin: 0 auto 50px;
            font-size: 15px;
            line-height: 1.7;
            opacity: 0.9;
        }

        .whyus-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
        }

        .whyus-card {
            background: rgba(0, 0, 0, 0.65);
            padding: 35px 20px;
            border-radius: 8px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            cursor: pointer;
        }

        .whyus-card:hover {
            box-shadow: 0 0 25px #f36b21;
        }

        .whyus-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: #f36b21;
            border: 3px solid white;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }

        .whyus-icon i {
            font-size: 30px;
            color: white;
        }

        .whyus-card h3 {
            color: #ff7a00;
            font-size: 16px;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .whyus-card p {
            font-size: 14px;
            line-height: 1.6;
            color: #fff;
            opacity: 0.9;
        }

        /* Tablet */
        @media (max-width: 991px) {
            .whyus-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        /* Mobile */
        @media (max-width: 575px) {
            .whyus-title {
                font-size: 26px;
            }

            .whyus-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>

    <section class="whyus-section">
        <div class="whyus-overlay"></div>

        <div class="whyus-container">
            <h2 class="whyus-title">WHY CHOOSE US</h2>
            <span class="dt-heading-line"></span>

            <p class="whyus-subtitle">
                We blend creativity, functionality, and premium materials to deliver
                timeless interior designs that reflect your lifestyle and vision.
            </p>

            <div class="whyus-grid">

                <!-- Card 1 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Personal Interior Designer</h3>
                    <p>
                        Dedicated designers understand your taste and create spaces
                        tailored exactly to your needs.
                    </p>
                </div>

                <!-- Card 2 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-vr-cardboard"></i>
                    </div>
                    <h3>3D & VR Visualization</h3>
                    <p>
                        Experience your home in 3D & VR before execution for
                        complete clarity and confidence.
                    </p>
                </div>

                <!-- Card 3 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-ruler-combined"></i>
                    </div>
                    <h3>Space Optimization</h3>
                    <p>
                        Smart layouts that maximize storage, comfort, and aesthetics
                        without compromising flow.
                    </p>
                </div>

                <!-- Card 4 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h3>End-to-End Execution</h3>
                    <p>
                        From design to final installation, we manage everything
                        with precision and care.
                    </p>
                </div>

                <!-- Card 5 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-couch"></i>
                    </div>
                    <h3>Premium Materials</h3>
                    <p>
                        We use high-quality, durable materials ensuring long-lasting
                        beauty and performance.
                    </p>
                </div>

                <!-- Card 6 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-palette"></i>
                    </div>
                    <h3>Customized Designs</h3>
                    <p>
                        Every project is unique — no templates, only bespoke
                        interiors crafted for you.
                    </p>
                </div>

                <!-- Card 7 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>On-Time Delivery</h3>
                    <p>
                        Well-planned timelines ensure your dream home is delivered
                        exactly when promised.
                    </p>
                </div>

                <!-- Card 8 -->
                <div class="whyus-card">
                    <div class="whyus-icon">
                        <i class="fas fa-thumbs-up"></i>
                    </div>
                    <h3>After-Sales Support</h3>
                    <p>
                        Our relationship doesn’t end at handover — we’re always
                        here for assistance.
                    </p>
                </div>

            </div>
        </div>
    </section>

</body>

</html>