<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');

        * {
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        a {
            text-decoration: none;
        }

        /* ================= Banner ================= */
        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/gallery-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.6rem;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-box h1 {
                font-size: 1.3rem;
                left: 30px;
            }
        }

        /* ================= Gallery Section ================= */
        .partner-showcase-section {
            width: 100%;
            padding: 20px 20px;
            background: rgba(255, 255, 255, 0.95);
        }

        .partner-showcase-container {
            max-width: 1200px;
            margin: auto;
            text-align: center;
        }

        .partner-showcase-title {
            font-size: 26px;
            letter-spacing: 2px;
            color: #f26b21;
            margin-bottom: 10px;
        }

        .partner-showcase-line {
            width: 40px;
            height: 2px;
            background: #f26b21;
            margin: 10px auto;
        }

        .partner-showcase-subtitle {
            font-size: 14px;
            color: #777;
            margin-bottom: 30px;
        }

        /* ================= Video Grid ================= */
        .video-gallery {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 30px;
            flex-wrap: wrap;
        }

        .video-gallery video {
            width: 270px;
            height: 270px;
            object-fit: cover;
            border-radius: 8px;
            cursor: pointer;
            transition: transform 0.3s ease;
        }

        @media (max-width: 768px) {
            .video-gallery video {
                width: 140px;
                height: 100px;
            }
        }

        /* ================= Modal ================= */
        .partner-video-modal {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.85);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .partner-video-modal video {
            max-width: 90%;
            max-height: 90%;
            background: #000;
            border-radius: 8px;
        }

        .partner-modal-close {
            position: absolute;
            top: 25px;
            right: 35px;
            font-size: 40px;
            color: #fff;
            cursor: pointer;
        }
    </style>
</head>

<body>

<?php include 'header.php'; ?>

<!-- ================= Banner ================= -->
<section class="custom-banner-section">
    <div class="custom-banner-box">
        <h1>Video Gallery</h1>
    </div>
</section>

<!-- ================= Video Gallery ================= -->
<section class="partner-showcase-section">
    <div class="partner-showcase-container">

        <h2 class="partner-showcase-title">VIDEO COLLECTION</h2>
        <p class="partner-showcase-subtitle">
            Discover our events, moments, and stories through videos.
        </p>

        <div class="video-gallery">
            <video muted autoplay onclick="openPartnerVideo(this)">
                <source src="./assets/images/v1.mp4" type="video/mp4">
            </video>

            <video muted autoplay onclick="openPartnerVideo(this)">
                <source src="./assets/images/v2.mp4" type="video/mp4">
            </video>

            <video muted autoplay onclick="openPartnerVideo(this)">
                <source src="./assets/images/v3.mp4" type="video/mp4">
            </video>

            <video muted autoplay onclick="openPartnerVideo(this)">
                <source src="./assets/images/v4.mp4" type="video/mp4">
            </video>
        </div>

    </div>
</section>

<!-- ================= Video Modal ================= -->
<div class="partner-video-modal" id="partnerVideoModal">
    <span class="partner-modal-close" onclick="closePartnerVideo()">×</span>
    <video id="partnerModalVideo" controls autoplay></video>
</div>

<?php include 'footer.php'; ?>

<!-- ================= Script ================= -->
<script>
    function openPartnerVideo(video) {
        const modal = document.getElementById('partnerVideoModal');
        const modalVideo = document.getElementById('partnerModalVideo');
        modalVideo.src = video.querySelector('source').src;
        modal.style.display = 'flex';
        modalVideo.play();
    }

    function closePartnerVideo() {
        const modal = document.getElementById('partnerVideoModal');
        const modalVideo = document.getElementById('partnerModalVideo');
        modalVideo.pause();
        modalVideo.src = '';
        modal.style.display = 'none';
    }
</script>

</body>
</html>
