<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
</head>

<body>
    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/usp-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 100px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <style>
        .usp-section {
            width: 100%;
            padding: 20px 20px;
            background: #ffffff;
        }

        .usp-container {
            max-width: 1200px;
            margin: auto;
            text-align: center;
        }

        .usp-title {
            font-size: 28px;
            font-weight: 600;
            color: #f26b21;
            letter-spacing: 2px;
            margin-bottom: 15px;
        }

        .usp-divider {
            display: inline-block;
            width: 50px;
            height: 3px;
            background: #f26b21;
            margin-bottom: 15px;
        }

        .usp-subtitle {
            font-size: 14px;
            color: #666;
            max-width: 600px;
            margin: 0 auto 40px;
        }

        .usp-card-wrapper {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
        }

        .usp-card {
            background: #fff;
            padding: 20px 20px;
            border-radius: 10px;
            transition: transform 0.3s ease;
            border: 1.5px solid #eee;
            cursor: pointer;
        }

        .usp-card-icon {
            width: 70px;
            height: 70px;
            margin: 0 auto 15px;
        }

        .usp-card-icon img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .usp-card-title {
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 10px;
            color: #000;
        }

        .usp-card-text {
            font-size: 14px;
            color: #555;
            line-height: 1.6;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .usp-card-wrapper {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 576px) {
            .usp-card-wrapper {
                grid-template-columns: 1fr;
            }
        }
    </style>


    <section class="custom-banner-section">
        <div class="custom-banner-box">
             
        </div>
    </section>

    <section class="usp-section">
        <div class="usp-container">

            <h2 class="usp-title">OUR USP</h2>
            <div class="usp-card-wrapper">

                <!-- Card 1 -->
                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c1.png" alt="Quality Service">
                    </div>
                    <h3 class="usp-card-title">Customer Relationship Management</h3>
                </div>

                <!-- Card 2 -->
                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c2.png" alt="Trusted Team">
                    </div>
                    <h3 class="usp-card-title">Experienced and Trained Staff</h3>
                </div>

                <!-- Card 3 -->
                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c3.png" alt="Customer Focus">
                    </div>
                    <h3 class="usp-card-title">Quality Controlled by Highly Specialized Team</h3>
                </div>

                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c4.png" alt="Customer Focus">
                    </div>
                    <h3 class="usp-card-title">3 Tier- Supervision System</h3>
                </div>

                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c5.png" alt="Customer Focus">
                    </div>
                    <h3 class="usp-card-title">Quality Services</h3>
                </div>

                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c6.png" alt="Customer Focus">
                    </div>
                    <h3 class="usp-card-title">Round the Clock Support</h3>
                </div>

                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c7.png" alt="Customer Focus">
                    </div>
                    <h3 class="usp-card-title">Control Room with Rapid Action Team</h3>
                </div>

                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c8.png" alt="Customer Focus">
                    </div>
                    <h3 class="usp-card-title">Transparent Operations</h3>
                </div>
                
                <div class="usp-card">
                    <div class="usp-card-icon">
                        <img src="./assets/images/c9.png" alt="Customer Focus">
                    </div>
                    <h3 class="usp-card-title">ISO 9001-2015 Certified</h3>
                </div>

            </div>

        </div>
    </section>

    <?php include 'footer.php' ?>
</body>

</html>