<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/project-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 100px;
            }
        }

        a {
            text-decoration: none;
        }

        /* Section */
        .dt-section {
            background: #fff;
            padding: 40px 20px;
        }

        .dt-container {
            max-width: 1200px;
            margin: auto;
            text-align: left;
        }

        .dt-heading {
            font-size: 26px;
            color: #f36b21;
            margin-bottom: 5px;
            font-weight: 600;
        }

        .dt-heading-line {
            width: 50px;
            height: 3px;
            background: #f36b21;
            margin-bottom: 15px;
        }

        .dt-description {
            max-width: 1200px;
            font-size: 14px;
            line-height: 1.7;
            color: #555;
            margin-bottom: 40px;
        }

        /* Grid */
        .dt-grid {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            justify-content: center;
        }

        /* Card */
        .dt-card {
            flex: 0 0 calc(50% - 10px);
            max-width: calc(50% - 10px);
            border: 2px solid #f36b21;
            position: relative;
            overflow: hidden;
        }


        /* Slider */
        .slider {
            position: relative;
            width: 100%;
            height: 300px;
        }

        .slider img {
            width: 100%;
            height: 300px;
            object-fit: cover;
            display: none;
        }

        .slider img.active {
            display: block;
        }

        /* Controls */
        .slider-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background: rgba(0, 0, 0, 0.6);
            color: #fff;
            border: none;
            font-size: 18px;
            padding: 6px 12px;
            cursor: pointer;
        }

        .prev {
            left: 10px;
        }

        .next {
            right: 10px;
        }

        /* Label */
        .dt-card-label {
            position: absolute;
            bottom: 12px;
            left: 12px;
            background: rgba(0, 0, 0, 0.75);
            color: #fff;
            padding: 6px 16px;
            font-size: 18px;
        }

        @media (max-width: 768px) {
            .slider {
                height: 220px;
            }

            .slider img {
                height: 220px;
            }

            .dt-card {
                flex: 0 0 100%;
                max-width: 100%;
            }
        }
    </style>
</head>

<body>

    <?php include 'header.php' ?>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>What We Offer</h1>
        </div>
    </section>

    <section class="dt-section">
        <div class="dt-container">

<h2 class="dt-heading">COMPLETE INTERIOR & EXTERIOR SOLUTIONS</h2>
<div class="dt-heading-line"></div>

<p class="dt-description">
    At <span style="font-weight:600">Pan India Creation</span>, we provide complete Interior & Exterior Design solutions that transform ordinary spaces into extraordinary environments. Our goal is to create functional, aesthetic, and sustainable spaces that reflect your personality, lifestyle, and vision.
</p>

<p class="dt-description">
    Our Interior Design services focus on space planning, modern layouts, customized furniture, lighting design, color selection, and décor styling. Whether it’s a residential home, office, showroom, or commercial space, we blend creativity with practicality to deliver elegant and comfortable interiors.
</p>

<p class="dt-description">
    In addition to interiors, we specialize in Exterior Design that enhances the visual appeal and structure of your property. From façade design to outdoor styling, we ensure your building creates a powerful first impression while maintaining durability and style.
</p>

<p class="dt-description">
    Our Landscaping and Terrace Gardening services bring nature closer to your living and working spaces. We design beautiful gardens, green terraces, vertical gardens, and relaxing outdoor environments that improve air quality and create peaceful surroundings.
</p>

<p class="dt-description">
    We also operate a well-maintained Plant Nursery offering a wide variety of indoor plants, outdoor plants, decorative pots, and garden essentials. Our experts guide you in selecting the right plants to suit your space and maintenance needs.
</p>

<p class="dt-description">
    With a commitment to quality, innovation, and customer satisfaction, Pan India Creation delivers end-to-end design and greenery solutions across India, turning every space into a masterpiece.
</p>

<h2 class="dt-heading">PREVIEWS OF OUR DESIGNING SOLUTIONS</h2>
<div class="dt-heading-line"></div>

            <div class="dt-grid">

                <!-- CARD 1 -->
                <div class="dt-card">
                    <div class="slider">
                        <img src="./assets/images/t1.webp" class="active">
                        <img src="./assets/images/t2.jpg">
                        <img src="./assets/images/t3.jpg">
                        <img src="./assets/images/t4.webp">
                        <img src="./assets/images/t5.jpg">
                        <button class="slider-btn prev">&#10094;</button>
                        <button class="slider-btn next">&#10095;</button>
                    </div>
                    <div class="dt-card-label">Interior Design</div>
                </div>

                <!-- CARD 2 -->
                <div class="dt-card">
                    <div class="slider">
                        <img src="./assets/images/t9.jpg" class="active">
                        <img src="./assets/images/t10.jpg">
                        <img src="./assets/images/t11.jpg">
                        <img src="./assets/images/t12.avif">
                        <img src="./assets/images/t13.jpg">
                        <button class="slider-btn prev">&#10094;</button>
                        <button class="slider-btn next">&#10095;</button>
                    </div>
                    <div class="dt-card-label">Exterior Design</div>
                </div>

                <!-- CARD 3 -->
                <div class="dt-card">
                    <div class="slider">
                        <img src="./assets/images/t14.webp" class="active">
                        <img src="./assets/images/t15.jpg">
                        <img src="./assets/images/t16.jpg">
                        <button class="slider-btn prev">&#10094;</button>
                        <button class="slider-btn next">&#10095;</button>
                    </div>
                    <div class="dt-card-label">Interior Decor</div>
                </div>

                <!-- CARD 4 -->
                <div class="dt-card">
                    <div class="slider">
                        <img src="./assets/images/t6.jpg" class="active">
                        <img src="./assets/images/t7.jpg">
                        <img src="./assets/images/t8.jpg">
                        <button class="slider-btn prev">&#10094;</button>
                        <button class="slider-btn next">&#10095;</button>
                    </div>
                    <div class="dt-card-label">Landscaping</div>
                </div>
                
                <div class="dt-card">
                    <div class="slider">
                        <img src="./assets/images/t17.webp" class="active">
                        <img src="./assets/images/t18.jpg">
                        <img src="./assets/images/t19.jpg">
                        <button class="slider-btn prev">&#10094;</button>
                        <button class="slider-btn next">&#10095;</button>
                    </div>
                    <div class="dt-card-label">Terrace Gardening</div>
                </div>
                
                <div class="dt-card">
                    <div class="slider">
                        <img src="./assets/images/t20.jfif" class="active">
                        <img src="./assets/images/t21.jpg">
                        <img src="./assets/images/t22.jpeg">
                        <img src="./assets/images/t23.jpg">
                        <button class="slider-btn prev">&#10094;</button>
                        <button class="slider-btn next">&#10095;</button>
                    </div>
                    <div class="dt-card-label">Plant Nursery</div>
                </div>

            </div>
        </div>
    </section>

    <?php include 'footer.php' ?>

    <script>
        document.querySelectorAll('.slider').forEach(slider => {
            let images = slider.querySelectorAll('img');
            let index = 0;

            slider.querySelector('.next').onclick = () => {
                images[index].classList.remove('active');
                index = (index + 1) % images.length;
                images[index].classList.add('active');
            };

            slider.querySelector('.prev').onclick = () => {
                images[index].classList.remove('active');
                index = (index - 1 + images.length) % images.length;
                images[index].classList.add('active');
            };
        });
    </script>

</body>

</html>