<!DOCTYPE html>
<html lang="en">

<head>
       <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
</head>

<body>

    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/project-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-size: 1.5rem;
            position: relative;
            top: 130px;
            left: 80px;
            margin: 0;
        }

        @media (max-width: 768px) {
            .custom-banner-box h1 {
                top: 0;
                left: 0;
                text-align: center;
                width: 100%;
            }
        }

        .vv-testimonial-section {
            max-width: 1100px;
            margin: auto;
            padding: 20px;
        }

        .vv-testimonial-heading {
            font-size: 26px;
            margin-bottom: 40px;
            font-weight: 600;
        }

        .vv-testimonial-card {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 50px;
            box-shadow: 0 0 15px black;
            padding: 20px;
        }

        .vv-testimonial-card.vv-right {
            flex-direction: row-reverse;
        }

        /* IMAGE SMALL */
        .vv-testimonial-media {
            flex: 0 0 35%;
        }

        .vv-testimonial-media img {
            width: 100%;
            object-fit: cover;
        }

        /* CONTENT */
        .vv-testimonial-content {
            flex: 1;
        }

        .vv-client-name {
            font-size: 18px;
            margin-bottom: 6px;
            font-weight: 600;
        }

        .vv-project-name {
            color: #f26522;
            font-weight: 600;
            margin-bottom: 10px;
            display: block;
        }

        .vv-client-review {
            font-size: 14px;
            line-height: 1.7;
            color: #444;
        }

        /* RESPONSIVE */
        @media (max-width: 768px) {

            .vv-testimonial-card,
            .vv-testimonial-card.vv-right {
                flex-direction: column;
            }

            .vv-testimonial-media {
                flex: 100%;
            }
        }
    </style>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Testimonial</h1>
        </div>
    </section>

    <section class="vv-testimonial-section">
        <h2 class="vv-testimonial-heading">WHAT OUR CUSTOMERS SAY</h2>

        <!-- LEFT -->
        <div class="vv-testimonial-card">
            <div class="vv-testimonial-media">
                <img src="assets/images/r1.jpg">
            </div>
            <div class="vv-testimonial-content">
                <h4 class="vv-client-name">Mr. Sundar Sampath</h4>
                <span class="vv-project-name">Prestige Summer Fields</span>
                <p class="vv-client-review">
                    “From the very first discussion, the team clearly understood our vision for a
                    warm and traditional home. They provided thoughtful design options, guided us
                    on materials, and executed everything with precision. The final outcome exceeded
                    our expectations, combining elegance with functionality. We truly appreciate
                    their professionalism and commitment to quality.”
                </p>
            </div>
        </div>

        <!-- RIGHT -->
        <div class="vv-testimonial-card vv-right">
            <div class="vv-testimonial-media">
                <img src="assets/images/r2.jpg">
            </div>
            <div class="vv-testimonial-content">
                <h4 class="vv-client-name">Mrs. Anjali Verma</h4>
                <span class="vv-project-name">Sobha Dream Acres</span>
                <p class="vv-client-review">
                    “The entire interior journey was smooth and well-organized. From design
                    finalization to execution, every detail was handled with care. The team maintained
                    transparency, met timelines, and delivered excellent craftsmanship. Our home now
                    feels stylish, comfortable, and perfectly planned for everyday living.”
                </p>
            </div>
        </div>

        <!-- LEFT -->
        <div class="vv-testimonial-card">
            <div class="vv-testimonial-media">
                <img src="assets/images/p2.jpg">
            </div>
            <div class="vv-testimonial-content">
                <h4 class="vv-client-name">Mr. Rohit Mehta</h4>
                <span class="vv-project-name">Brigade Panorama</span>
                <p class="vv-client-review">
                    “What impressed us most was their practical approach to design. The team suggested
                    smart layouts, storage solutions, and finishes that suited our budget without
                    compromising on style. The execution quality was excellent, and the project was
                    completed on time. Highly recommended for anyone looking for reliable interior
                    solutions across India.”
                </p>
            </div>
        </div>

    </section>


    <?php include 'footer.php' ?>

</body>

</html>