<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
</head>

<body>
    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/project-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 100px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Mission | Vision | Core Values</h1>
        </div>
    </section>
    <style>
        /* ================= ABOUT FOUNDER SECTION ================= */

        .vv-founder-section {
            padding: 10px 20px;
            background: #ffffff;
        }

        .vv-founder-section * {
            box-sizing: border-box;
        }

        .vv-founder-wrapper {
            max-width: 1100px;
            margin: 0 auto;
            position: relative;
            overflow: hidden;
        }

        .vv-founder-bg-text {
            position: absolute;
            top: -20px;
            left: 0;
            font-size: 120px;
            font-weight: 800;
            color: #000;
            opacity: 0.06;
            letter-spacing: 6px;
            pointer-events: none;
        }

        .vv-founder-row {
            display: flex;
            gap: 40px;
            align-items: center;
            flex-wrap: wrap;
        }

        .vv-founder-left {
            flex: 1;
        }

        .vv-founder-heading {
            font-size: 38px;
            font-weight: 700;
            color: #2f2f2f;
            margin-bottom: 10px;
        }

        .vv-founder-heading span {
            color: #f36b21;
        }

        .vv-founder-subtitle {
            font-size: 15px;
            color: #555;
            margin-bottom: 20px;
            font-weight: 500;
        }

        .vv-founder-message {
            font-size: 13px;
            line-height: 1.8;
            color: #444;
            text-align: justify;
            font-weight: 500;
        }

        .vv-founder-right {
            flex: 1;
            text-align: center;
        }

        /* DIRECTOR IMAGE – DESKTOP */
        .vv-founder-image {
            width: 100%;
            max-width: 380px;
            height: auto;
            border-radius: 8px;
        }

        /* ================= TABS ================= */

        .vv-tabs-section {
            margin-top: 50px;
            text-align: center;
        }

        .vv-tabs-buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }

        .vv-tab-btn {
            padding: 10px 24px;
            border: 2px solid #f36b21;
            background: transparent;
            color: #f36b21;
            cursor: pointer;
            font-size: 15px;
            transition: 0.3s;
            font-weight: 500;
        }

        .vv-tab-btn.active {
            background: #f36b21;
            color: #fff;
        }

        .vv-tab-content {
            display: none;
            max-width: 700px;
            margin: 0 auto;
        }

        .vv-tab-content.active {
            display: block;
        }

        /* TAB IMAGE */
        .vv-tab-image {
            width: 100%;
            max-width: 100%;
            height: auto;
            margin-bottom: 15px;
            border: 1.5px solid #eee;
        }

        .vv-tab-text {
            font-size: 14px;
            line-height: 1.7;
            color: #444;
        }

        /* ================= MOBILE FIXES ================= */

        @media (max-width: 768px) {

            .vv-founder-bg-text {
                font-size: 45px;
            }

            .vv-founder-heading {
                font-size: 22px;
            }

            .vv-founder-row {
                flex-direction: column;
                gap: 25px;
            }

            /* SMALL & NATIVE DIRECTOR IMAGE ON MOBILE */
            .vv-founder-image {
                max-width: 180px;
                margin: 0 auto;
                display: block;
            }

            .vv-tab-image {
                max-width: 100%;
            }
        }
    </style>

    <section class="vv-founder-section">
        <div class="vv-founder-wrapper">
            <!-- ================= TABS ================= -->

            <div class="vv-tabs-section" id="mission">

                <div class="vv-tabs-buttons">
                    <button class="vv-tab-btn active" onclick="vvOpenTab(event,'mission')">Mission</button>
                    <button class="vv-tab-btn" onclick="vvOpenTab(event,'vision')">Vision</button>
                    <button class="vv-tab-btn" onclick="vvOpenTab(event,'values')">Core Values</button>
                </div>

                <div id="mission" class="vv-tab-content active">
                    <img src="./assets/images/mission.webp" class="vv-tab-image" alt="">
                    <p class="vv-tab-text">
                        To deliver <span style="font-weight:600">innovative interior and landscape design solutions</span> that enhance lifestyles and spaces, while ensuring quality, functionality, and complete client satisfaction.
                    </p>
                </div>

                <div id="vision" class="vv-tab-content">
                    <img src="./assets/images/mission.webp" class="vv-tab-image" alt="">
                    <p class="vv-tab-text">
                        To be a <span style="font-weight:600">trusted pan-India design brand,</span> known for creating timeless interiors and harmonious landscapes that connect people with their spaces and nature.
                    </p>
                </div>

                <div id="values" class="vv-tab-content">
                    <img src="./assets/images/core.png" class="vv-tab-image" alt="">
                    <p class="vv-tab-text">
                        At Pan India Creation, we value <span style="font-weight:600">creativity with purpose.</span> We believe in designing spaces that are aesthetically pleasing, thoughtfully planned, environmentally responsible, and tailored to our clients’ needs, built on trust, quality, and attention to detail.
                    </p>
                </div>

            </div>


        </div>
    </section>

    <script>
        function vvOpenTab(evt, tabName) {
            var i, content, buttons;
            content = document.getElementsByClassName("vv-tab-content");
            for (i = 0; i < content.length; i++) {
                content[i].classList.remove("active");
            }

            buttons = document.getElementsByClassName("vv-tab-btn");
            for (i = 0; i < buttons.length; i++) {
                buttons[i].classList.remove("active");
            }

            document.getElementById(tabName).classList.add("active");
            evt.currentTarget.classList.add("active");
        }
    </script>
    <?php include 'footer.php' ?>
</body>

</html>