<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/kitchen-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 100px;
            }
        }

        a {
            text-decoration: none;
        }


        .rp-section {
            background: rgba(255, 255, 255, 0.95);
            padding: 40px 20px;
        }

        .rp-container {
            max-width: 1200px;
            margin: auto;
        }

        .rp-heading {
            text-align: center;
            margin-bottom: 40px;
        }

        .rp-heading h2 {
            font-size: 26px;
            color: #f36b21;
        }

        .rp-underline {
            width: 40px;
            height: 3px;
            background: #ff6600;
            display: inline-block;
        }

        .rp-cards-wrapper {
            display: flex;
            flex-direction: column;
            gap: 60px;
        }

        .rp-card {
            position: relative;
            display: flex;
            flex-direction: column;
        }

        .rp-gallery-author {
            display: flex;
            gap: 20px;
            position: relative;
        }

        .rp-gallery {
            flex: 3;
            display: flex;
            gap: 12px;
        }

        .rp-main-img {
            flex: 2;
        }

        .rp-main-img img,
        .rp-side-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            cursor: pointer;
        }

        .rp-side-imgs {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .rp-side-img {
            position: relative;
        }

        .rp-overlay-text {
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.6);
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            cursor: pointer;
        }

        .rp-author {
            position: absolute;
            right: 0;
            bottom: -140px;
            text-align: center;
            z-index: 10;
        }

        .rp-author img {
            width: 150px;
        }

        .rp-author span {
            display: block;
            font-size: 12px;
            margin-top: 6px;
        }

        .rp-content {
            margin-top: 25px;
            width: 100%;
        }

        .rp-content h3 {
            font-size: 18px;
            margin-bottom: 10px;
        }

        .rp-highlight {
            color: #ff6600;
        }

        .rp-content p {
            font-size: 14px;
            line-height: 1.6;
            color: #555;
            max-height: 45px;
            overflow: hidden;
            transition: max-height 0.3s ease;
        }

        .rp-content p.expanded {
            max-height: 500px;
        }

        .rp-read-btn {
            margin-top: 15px;
            padding: 8px 18px;
            background: #ff6600;
            color: #fff;
            border: none;
            cursor: pointer;
            border-radius: 10px;
        }

        .rp-view-all {
            text-align: center;
            margin-top: 50px;
        }

        .rp-view-btn {
            padding: 12px 36px;
            border: 1px solid #ff6600;
            background: transparent;
            color: #ff6600;
            cursor: pointer;
            border-radius: 10px;
        }

        .rp-view-btn:hover {
            background-color: #ff6600;
            color: white;
            transition: 0.3s;
        }

        /* MODAL */
        .rp-modal {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.9);
            align-items: center;
            justify-content: center;
            z-index: 999;
        }

        .rp-modal img {
            max-width: 90%;
            max-height: 80%;
        }

        .rp-close {
            position: absolute;
            top: 20px;
            right: 30px;
            color: #fff;
            font-size: 30px;
            cursor: pointer;
        }

        .dt-description{
            font-size: 13px;
            color:#555;
            font-weight:500;
        }

        .rp-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            color: #fff;
            font-size: 40px;
            cursor: pointer;
            user-select: none;
        }

        .rp-prev {
            left: 30px;
        }

        .rp-next {
            right: 30px;
        }

        .rp-count {
            position: absolute;
            bottom: 20px;
            color: #fff;
            font-size: 14px;
        }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            .rp-gallery-author {
                flex-direction: column;
            }

            .rp-gallery {
                flex-direction: column;
            }

            .rp-author {
                position: static;
                margin-top: 20px;
            }
        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Kitchen Design</h1>
        </div>
    </section>

    <section class="rp-section">
        <div class="rp-container">

            <div class="rp-heading">
                <h2>KITCHEN INTERIOR DESIGN</h2><br>
                <p class="dt-description">
                    A well-designed kitchen is the heart of every home, where functionality meets style. Our kitchen interior designs focus on smart space planning, modern aesthetics, and practical layouts that make everyday cooking effortless and enjoyable. From contemporary modular kitchens to timeless classic designs, we carefully select colors, materials, and finishes that reflect your lifestyle while ensuring durability, comfort, and efficiency. Every detail is thoughtfully crafted to transform your kitchen into a beautiful and highly functional space.
                </p>
            </div>


            <div class="rp-cards-wrapper">
                <!-- FIRST PROJECT CARD -->
                <div class="rp-card" data-card="0">
                    <div class="rp-gallery-author">
                        <div class="rp-gallery">
                            <div class="rp-main-img">
                                <img src="assets/images/kitchen-bn.jpg" class="rp-img" data-index="0" data-card="0" alt="Project 1 Main">
                            </div>
                            <div class="rp-side-imgs">
                                <div class="rp-side-img">
                                    <img src="assets/images/kitchen-bn.jpg" class="rp-img" data-index="1" data-card="0" alt="Project 1 Side 1">
                                </div>
                                <div class="rp-side-img">
                                    <img src="assets/images/kitchen-bn.jpg" class="rp-img" data-index="2" data-card="0" alt="Project 1 Side 2">
                                    <div class="rp-overlay-text" data-card="0">+2 Images</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="rp-content">
                        <p id="desc0">
                            Carefully curated pieces, stellar accents and gorgeous furnishings come together,
                            to create an opulent home, that'll whisk you away to the lap of luxury.
                            This project reflects premium craftsmanship and timeless elegance.
                        </p>
                        <button class="rp-read-btn" onclick="toggleRead(0)">Read More</button>
                    </div>
                </div>

                <!-- SECOND PROJECT CARD -->
                <div class="rp-card" data-card="1">
                    <div class="rp-gallery-author">
                        <div class="rp-gallery">
                            <div class="rp-main-img">
                                <img src="./assets/images/k2.jpg" class="rp-img" data-index="0" data-card="1" alt="Project 2 Main">
                            </div>
                            <div class="rp-side-imgs">
                                <div class="rp-side-img">
                                    <img src="./assets/images/k2.jpg" class="rp-img" data-index="1" data-card="1" alt="Project 2 Side 1">
                                </div>
                                <div class="rp-side-img">
                                    <img src="./assets/images/k2.jpg" class="rp-img" data-index="2" data-card="1" alt="Project 2 Side 2">
                                    <div class="rp-overlay-text" data-card="1">+3 Images</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="rp-content">
                        <p id="desc1">
                            Clean lines, natural materials and thoughtful spatial planning create a serene urban oasis.
                            This contemporary design emphasizes functionality while maintaining warmth and elegance.
                            Perfect balance of form and function in a compact city apartment.
                        </p>
                        <button class="rp-read-btn" onclick="toggleRead(1)">Read More</button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- MODAL SLIDER -->
    <div class="rp-modal" id="rpModal">
        <span class="rp-close" onclick="closeModal()">&times;</span>
        <span class="rp-nav rp-prev" onclick="prevImage()">&#10094;</span>
        <img id="modalImage" src="">
        <span class="rp-nav rp-next" onclick="nextImage()">&#10095;</span>
        <div class="rp-count" id="modalCount"></div>
    </div>

    <script>
        const projects = {
            0: {
                images: [
                    "assets/images/kitchen-bn.jpg",
                    "assets/images/kitchen-bn.jpg",
                    "assets/images/kitchen-bn.jpg",
                    "assets/images/kitchen-bn.jpg",
                    "assets/images/kitchen-bn.jpg"
                ]
            },
            1: {
                images: [
                    "./assets/images/k2.jpg",
                    "./assets/images/k2.jpg",
                    "./assets/images/k2.jpg",
                    "./assets/images/k2.jpg",
                    "./assets/images/k2.jpg",
                    "./assets/images/k2.jpg"
                ]
            }
        };

        let currentProject = 0;
        let currentIndex = 0;

        // Update image counts dynamically
        function updateImageCounts() {
            document.querySelectorAll('.rp-overlay-text').forEach(overlay => {
                const cardId = parseInt(overlay.dataset.card);
                const totalImages = projects[cardId].images.length;
                overlay.innerText = `+${totalImages - 3} Images`;
            });
        }

        // Image click handlers
        document.addEventListener('DOMContentLoaded', function() {
            // Update counts on load
            updateImageCounts();

            // Add click handlers for images and overlays
            document.querySelectorAll(".rp-img, .rp-overlay-text").forEach(el => {
                el.addEventListener("click", function() {
                    currentProject = parseInt(this.dataset.card);
                    currentIndex = parseInt(this.dataset.index) || 0;
                    openModal();
                });
            });
        });

        function openModal() {
            document.getElementById("rpModal").style.display = "flex";
            updateModal();
        }

        function closeModal() {
            document.getElementById("rpModal").style.display = "none";
        }

        function nextImage() {
            currentIndex = (currentIndex + 1) % projects[currentProject].images.length;
            updateModal();
        }

        function prevImage() {
            currentIndex = (currentIndex - 1 + projects[currentProject].images.length) % projects[currentProject].images.length;
            updateModal();
        }

        function updateModal() {
            const modalImg = document.getElementById("modalImage");
            const modalCount = document.getElementById("modalCount");

            modalImg.src = projects[currentProject].images[currentIndex];
            modalCount.innerText = `${currentIndex + 1} / ${projects[currentProject].images.length}`;
        }

        function toggleRead(cardId) {
            const p = document.getElementById(`desc${cardId}`);
            const btn = event.target;
            p.classList.toggle("expanded");
            btn.innerText = p.classList.contains("expanded") ? "Read Less" : "Read More";
        }

        // Close modal when clicking outside image
        document.getElementById("rpModal").addEventListener("click", function(e) {
            if (e.target === this) {
                closeModal();
            }
        });

        // Keyboard navigation
        document.addEventListener("keydown", function(e) {
            if (document.getElementById("rpModal").style.display === "flex") {
                if (e.key === "ArrowRight") nextImage();
                if (e.key === "ArrowLeft") prevImage();
                if (e.key === "Escape") closeModal();
            }
        });
    </script>
    <?php include 'footer.php' ?>
</body>

</html>