// Make header sticky after scrolling some height
window.addEventListener('scroll', function() {
    const header = document.querySelector('.main-header');
    const scrollPosition = window.scrollY;
    
    // Change header style after scrolling 100px
    if (scrollPosition > 100) {
        header.classList.add('scrolled');
    } else {
        header.classList.remove('scrolled');
    }
});

// Mobile menu toggle
const menuToggle = document.getElementById("menuToggle");
const menuClose = document.getElementById("menuClose");
const navMenu = document.getElementById("navMenu");

menuToggle.addEventListener("click", () => {
    navMenu.classList.add("active");
    menuClose.style.display = "block";
});

menuClose.addEventListener("click", () => {
    navMenu.classList.remove("active");
    menuClose.style.display = "none";
});

// Mobile dropdown toggle
document.querySelectorAll('.dropdown').forEach(dropdown => {
    const toggle = dropdown.querySelector('.dropdown-toggle');
    
    if (toggle) {
        toggle.addEventListener('click', (e) => {
            e.preventDefault();
            dropdown.classList.toggle('open');
        });
    }
});