<!DOCTYPE html>
<html lang="en">

<head>
       <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .social-sidebar {
            position: fixed;
            top: 80%;
            transform: translateY(-50%);
            z-index: 1000;
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .social-left {
            left: 20px;
        }

        .social-right {
            right: 20px;
        }

        .social-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            position: relative;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .social-icon:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.3);
        }

        .social-icon .tooltip {
            position: absolute;
            background-color: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 14px;
            white-space: nowrap;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s ease;
        }

        .social-left .tooltip {
            left: 65px;
            top: 80%;
            transform: translateY(-50%);
        }

        .social-right .tooltip {
            right: 65px;
            top: 50%;
            transform: translateY(-50%);
        }

        .social-icon:hover .tooltip {
            opacity: 1;
        }

        /* Social media brand colors */
        .facebook {
            background-color: #3b5998;
        }

        .twitter {
            background-color: #1da1f2;
        }

        .instagram {
            background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
        }

        .youtube {
            background-color: #ff0000;
        }

        .whatsapp {
            background-color: #25d366;
        }

        .linkedin {
            background-color: #0077b5;
        }

        .pinterest {
            background-color: #bd081c;
        }

        .telegram {
            background-color: #0088cc;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .social-left {
                left: 10px;
            }

            .social-right {
                right: 10px;
            }

            .social-icon {
                width: 40px;
                height: 40px;
                font-size: 16px;
            }

            .social-left .tooltip {
                left: 55px;
            }

            .social-right .tooltip {
                right: 55px;
            }
        }

        @media (max-width: 480px) {
            .social-icon {
                width: 35px;
                height: 35px;
                font-size: 14px;
            }

            .social-left .tooltip {
                left: 50px;
            }

            .social-right .tooltip {
                right: 50px;
            }
        }
    </style>
</head>

<body>
    <!-- Left Sidebar -->
    <div class="social-sidebar social-left">
        <a href="https://www.facebook.com" target="_blank" class="social-icon facebook">
            <i class="fab fa-facebook-f"></i>
            <span class="tooltip">Facebook</span>
        </a>
        <a href="https://twitter.com" target="_blank" class="social-icon twitter">
            <i class="fab fa-twitter"></i>
            <span class="tooltip">Twitter</span>
        </a>
        <a href="https://www.instagram.com" target="_blank" class="social-icon instagram">
            <i class="fab fa-instagram"></i>
            <span class="tooltip">Instagram</span>
        </a>
        <a href="https://www.youtube.com" target="_blank" class="social-icon youtube">
            <i class="fab fa-youtube"></i>
            <span class="tooltip">YouTube</span>
        </a>
    </div>

    <!-- Right Sidebar -->
    <div class="social-sidebar social-right">
        <a href="tel:+91 7323 012345" class="social-icon pinterest">
            <i class="fa-solid fa-phone"></i>
            <span class="tooltip">Call Us</span>
        </a>
        <a href="https://api.whatsapp.com/send?phone=+91 7323 012345&text=WELCOME%20TO%20PAN%20INDIA%20CREATION"
            target="_blank" class="social-icon whatsapp">
            <i class="fab fa-whatsapp"></i>
            <span class="tooltip">WhatsApp</span>
        </a>
        <a href="https://www.linkedin.com" target="_blank" class="social-icon linkedin">
            <i class="fab fa-linkedin-in"></i>
            <span class="tooltip">LinkedIn</span>
        </a>
    </div>
</body>

</html>