<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/how-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 100px;
            }
        }

        a {
            text-decoration: none;
        }

        .hwk-wrapper {
            max-width: 1100px;
            margin: auto;
            padding: 20px 16px;
        }

        .hwk-title {
            text-align: left;
            margin-bottom: 50px;
            position: relative;
            font-size: 26px;
            font-weight: 600;
        }

        .hwk-title::after {
            content: "";
            position: absolute;
            bottom: -10px;
            left: 0;
            width: 100px;
            height: 3px;
            background: #f58220;
        }

        .hwk-timeline {
            position: relative;
            padding-left: 60px;
        }

        /* Vertical line */
        .hwk-timeline::before {
            content: "";
            position: absolute;
            left: 28px;
            top: 0;
            bottom: 0;
            width: 4px;
            background: #cfcfcf;
        }

        .hwk-step {
            position: relative;
            display: flex;
            margin-bottom: 35px;
        }

        /* Icon circle ON the line */
        .hwk-dot {
            position: absolute;
            left: -30px;
            top:10px;
            transform: translateX(-50%);
            width: 40px;
            height: 40px;
            background: #f58220;
            color: #fff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            z-index: 2;
        }

        /* Card */
        .hwk-card {
            background: #fff;
            border: 1px solid #e6e6e6;
            padding: 20px;
            border-radius: 6px;
            width: 100%;
            box-shadow: 0 0 10px #555;
            position: relative;
        }

        .hwk-card h3 {
            margin: 0 0 10px;
            font-weight: 500;
            font-size: 15px;
            text-align: left;
            position: relative;
            padding-bottom: 8px;
        }

        .hwk-card h3::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 0;
            width: 60px;
            height: 2px;
            background: #f58220;
        }

        .hwk-card p {
            margin: 0;
            color: #555;
            font-size: 14px;
        }

        .hwk-more {
            display: none;
            margin-top: 20px;
        }

        .hwk-more-item {
            display: flex;
            gap: 12px;
            margin-bottom: 15px;
        }

        .hwk-more-item p{
            font-size: 14px;
        }

        .hwk-more-item i {
            color: white;
            margin-top: 3px;
            background-color: #f58220;
            padding: 5px;
            height: 30px;
            width: 30px;
            border-radius: 50%;
        }

        .hwk-toggle {
            margin-top: 12px;
            background: none;
            border: none;
            color: #f58220;
            cursor: pointer;
            font-weight: 500;
            text-decoration: underline;
            font-size: 14px;
        }

        /* Expanded */
        .hwk-card.active .hwk-more {
            display: block;
        }

        /* Mobile */
        @media (max-width: 768px) {
            .hwk-card {
                margin-left: 30px;
            }
            
            .hwk-title {
                text-align: center;
            }
            
            .hwk-title::after {
                left: 50%;
                transform: translateX(-50%);
                width: 80px;
            }
        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>How It Works</h1>
        </div>
    </section>

    <section class="hwk-wrapper">
        <h2 class="hwk-title">HOW IT WORKS</h2>

        <div class="hwk-timeline">

            <!-- STEP 1 -->
            <div class="hwk-step">
                <span class="hwk-dot">
                    <i class="fa-solid fa-user"></i>
                </span>

                <div class="hwk-card">
                    <h3>SIGN-UP</h3>
                    <p>
                        The first stage of the interior design process is all about you — the customer. Create your account, share your vision, and get matched with our expert designers who understand your style and needs.
                    </p>

                    <div class="hwk-more">
                        <div class="hwk-more-item">
                            <i class="fa-solid fa-handshake"></i>
                            <div>
                                <span style="font-weight: 500;">Meet a Designer</span>
                                <p>Free design consultation with certified professionals.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-palette"></i>
                            <div>
                                <span style="font-weight: 500;">First-cut Design</span>
                                <p>Initial 3D design presentation within 48 hours.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-file-invoice"></i>
                            <div>
                                <span style="font-weight: 500;">Detailed Estimate</span>
                                <p>Complete cost breakdown with material options.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-percent"></i>
                            <div>
                                <span style="font-weight: 500;">Pay 10% to Book</span>
                                <p>Secure your designer with minimal advance payment.</p>
                            </div>
                        </div>
                    </div>

                    <button class="hwk-toggle">Show more</button>
                </div>
            </div>

            <!-- STEP 2 -->
            <div class="hwk-step">
                <span class="hwk-dot">
                    <i class="fa-solid fa-pen-ruler"></i>
                </span>
                <div class="hwk-card">
                    <h3>DESIGN</h3>
                    <p>Multiple rounds of functional & aesthetic design refinement with your designer to perfect every detail of your space.</p>

                    <div class="hwk-more">
                        <div class="hwk-more-item">
                            <i class="fa-solid fa-ruler-combined"></i>
                            <div>
                                <span style="font-weight: 500;">Space Planning</span>
                                <p>Optimal furniture layout for functionality.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-eye"></i>
                            <div>
                                <span style="font-weight: 500;">3D Visualization</span>
                                <p>Photorealistic walkthroughs of your design.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-pen-fancy"></i>
                            <div>
                                <span style="font-weight: 500;">Custom Revisions</span>
                                <p>Unlimited design iterations until perfect.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-lightbulb"></i>
                            <div>
                                <span style="font-weight: 500;">Lighting Design</span>
                                <p>Strategic lighting for mood & functionality.</p>
                            </div>
                        </div>
                    </div>

                    <button class="hwk-toggle">Show more</button>
                </div>
            </div>

            <!-- STEP 3 -->
            <div class="hwk-step">
                <span class="hwk-dot">
                    <i class="fa-solid fa-layer-group"></i>
                </span>
                <div class="hwk-card">
                    <h3>FINALIZATION</h3>
                    <p>Final technical drawings, material selection, and vendor approvals to lock in your perfect design vision.</p>

                    <div class="hwk-more">
                        <div class="hwk-more-item">
                            <i class="fa-solid fa-drafting-compass"></i>
                            <div>
                                <span style="font-weight: 500;">Technical Drawings</span>
                                <p>Execution-ready architectural plans.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-gem"></i>
                            <div>
                                <span style="font-weight: 500;">Premium Materials</span>
                                <p>Curated material selection process.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-check-double"></i>
                            <div>
                                <span style="font-weight: 500;">Final Approval</span>
                                <p>Client sign-off on complete design package.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-truck"></i>
                            <div>
                                <span style="font-weight: 500;">Vendor Booking</span>
                                <p>Confirmed material procurement schedule.</p>
                            </div>
                        </div>
                    </div>

                    <button class="hwk-toggle">Show more</button>
                </div>
            </div>

            <!-- STEP 4 -->
            <div class="hwk-step">
                <span class="hwk-dot">
                    <i class="fa-solid fa-screwdriver-wrench"></i>
                </span>
                <div class="hwk-card">
                    <h3>EXECUTION</h3>
                    <p>Professional on-site execution with daily quality supervision and progress tracking for flawless implementation.</p>

                    <div class="hwk-more">
                        <div class="hwk-more-item">
                            <i class="fa-solid fa-hard-hat"></i>
                            <div>
                                <span style="font-weight: 500;">Site Execution</span>
                                <p>Expert craftsmen with 10+ years experience.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-eye-slash"></i>
                            <div>
                                <span style="font-weight: 500;">Quality Control</span>
                                <p>Daily site inspections & material checks.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-clock"></i>
                            <div>
                                <span style="font-weight: 500;">Timeline Tracking</span>
                                <p>Real-time project progress dashboard.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-headset"></i>
                            <div>
                                <span style="font-weight: 500;">24/7 Support</span>
                                <p>Dedicated project coordinator available.</p>
                            </div>
                        </div>
                    </div>

                    <button class="hwk-toggle">Show more</button>
                </div>
            </div>

            <!-- STEP 5 -->
            <div class="hwk-step">
                <span class="hwk-dot">
                    <i class="fa-solid fa-house"></i>
                </span>
                <div class="hwk-card">
                    <h3>HANDOVER</h3>
                    <p>Final quality inspection, warranty documentation, and keys handover with maintenance guide.</p>

                    <div class="hwk-more">
                        <div class="hwk-more-item">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <div>
                                <span style="font-weight: 500;">Final Inspection</span>
                                <p>Comprehensive quality walkthrough.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-file-contract"></i>
                            <div>
                                <span style="font-weight: 500;">Warranty Documents</span>
                                <p>1-year comprehensive warranty certificate.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-book-open"></i>
                            <div>
                                <span style="font-weight: 500;">Maintenance Guide</span>
                                <p>Complete care & maintenance manual.</p>
                            </div>
                        </div>

                        <div class="hwk-more-item">
                            <i class="fa-solid fa-star"></i>
                            <div>
                                <span style="font-weight: 500;">Post-Handover</span>
                                <p>30-day free support service included.</p>
                            </div>
                        </div>
                    </div>

                    <button class="hwk-toggle">Show more</button>
                </div>
            </div>

        </div>
    </section>


    <script>
        document.querySelectorAll('.hwk-toggle').forEach(btn => {
            btn.addEventListener('click', () => {
                const card = btn.closest('.hwk-card');
                card.classList.toggle('active');
                btn.textContent = card.classList.contains('active') ?
                    'Show less' :
                    'Show more';
            });
        });
    </script>

    <?php include 'footer.php' ?>
</body>

</html>
