<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
    <style>
        .cs-testimonial-wrap {
            position: relative;
            padding: 20px 0;
            color: #fff;
        }

        .cs-testimonial-overlay {
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.65);
        }

        .cs-testimonial-container {
            position: relative;
            max-width: 1200px;
            margin: auto;
            padding: 0 80px;
            text-align: center;
        }

        .cs-testimonial-title {
            font-size: 26px;
        }

        .cs-testimonial-sub {
            display: block;
            margin-top: 10px;
            font-size: 14px;
            opacity: 0.8;
        }

        .cs-slider {
            position: relative;
            overflow: hidden;
            margin-top: 50px;
        }

        .cs-slide {
            display: none;
        }

        .cs-slide.cs-active {
            display: block;
        }

        .cs-testimonial-box {
            display: flex;
            align-items: center;
            gap: 30px;
        }

        .cs-testimonial-content {
            width: 60%;
            text-align: left;
        }

        .cs-client-name {
            font-size: 18px;
            font-weight: 600;
        }

        .cs-client-company {
            color: #ff7a00;
            margin-bottom: 15px;
        }

        .cs-client-review {
            font-size: 15px;
            line-height: 1.7;
        }

        .cs-testimonial-media {
            width: 40%;
        }

        .cs-testimonial-media img {
            width: 100%;
            border-radius: 6px;
        }

        .cs-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            font-size: 25px;
            color: #fff;
            cursor: pointer;
        }

        .cs-prev {
            left: 20px;
        }

        .cs-next {
            right: 20px;
        }

        .cs-view-more-btn {
            display: inline-block;
            margin-top: 40px;
            padding: 12px 35px;
            background: #ff7a00;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
        }

        /* Responsive */
        @media (max-width: 991px) {
            .cs-testimonial-box {
                flex-direction: column;
            }

            .cs-testimonial-content,
            .cs-testimonial-media {
                width: 100%;
            }

            .cs-testimonial-media {
                order: 1;
            }

            .cs-testimonial-content {
                order: 2;
            }
        }
    </style>
</head>

<body>
    <section class="cs-testimonial-wrap">
        <div class="cs-testimonial-overlay"></div>

        <div class="cs-testimonial-container">
            <h2 class="cs-testimonial-title">WHAT OUR CUSTOMERS SAY</h2>
            <span class="cs-testimonial-sub">Customer Delight Delivered</span>

            <div class="cs-slider">
                <div class="cs-slide cs-active">
                    <div class="cs-testimonial-box">
                        <div class="cs-testimonial-content">
                            <p class="cs-client-name">Mr. Sundar Sampath</p>
                            <p class="cs-client-company">Prestige Summer Fields</p>
                            <p class="cs-client-review">
                                “From the very first discussion, the team clearly understood our vision for a warm and traditional home. They provided thoughtful design options, guided us on materials, and executed everything with precision. The final outcome exceeded our expectations, combining elegance with functionality. We truly appreciate their professionalism and commitment to quality.”
                            </p>
                        </div>

                        <div class="cs-testimonial-media">
                            <img src="./assets/images/r1.jpg" alt="">
                        </div>
                    </div>
                </div>

                <div class="cs-slide">
                    <div class="cs-testimonial-box">
                        <div class="cs-testimonial-content">
                            <p class="cs-client-name">Mrs. Anjali Verma</p>
                            <p class="cs-client-company">Sobha Dream Acres</p>
                            <p class="cs-client-review">
                                “The entire interior journey was smooth and well-organized. From design finalization to execution, every detail was handled with care. The team maintained transparency, met timelines, and delivered excellent craftsmanship. Our home now feels stylish, comfortable, and perfectly planned for everyday living.”
                            </p>
                        </div>

                        <div class="cs-testimonial-media">
                            <img src="./assets/images/r2.jpg" alt="">
                        </div>
                    </div>
                </div>
            </div>

            <button class="cs-nav cs-prev">&#10094;</button>
            <button class="cs-nav cs-next">&#10095;</button>

            <a href="./review.php" class="cs-view-more-btn">View More</a>
        </div>
    </section>

    <script>
        const csSlides = document.querySelectorAll('.cs-slide');
        const csNext = document.querySelector('.cs-next');
        const csPrev = document.querySelector('.cs-prev');

        let csIndex = 0;
        let csInterval;

        function showSlide(index) {
            csSlides.forEach(slide => slide.classList.remove('cs-active'));
            csSlides[index].classList.add('cs-active');
        }

        function nextSlide() {
            csIndex = (csIndex + 1) % csSlides.length;
            showSlide(csIndex);
        }

        function prevSlide() {
            csIndex = (csIndex - 1 + csSlides.length) % csSlides.length;
            showSlide(csIndex);
        }

        function startAutoSlide() {
            csInterval = setInterval(nextSlide, 4000); // 4 seconds
        }

        function resetAutoSlide() {
            clearInterval(csInterval);
            startAutoSlide();
        }

        csNext.addEventListener('click', () => {
            nextSlide();
            resetAutoSlide();
        });

        csPrev.addEventListener('click', () => {
            prevSlide();
            resetAutoSlide();
        });

        showSlide(csIndex);
        startAutoSlide();
    </script>



</body>

</html>