<!DOCTYPE html>
<html lang="en">

<head>
       <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
    <style>
        .partner-showcase-section {
            width: 100%;
            padding: 20px 20px;
            background: rgba(255, 255, 255, 0.95);
        }

        .partner-showcase-container {
            max-width: 1200px;
            margin: auto;
            text-align: center;
        }

        .partner-showcase-title {
            font-size: 26px;
            letter-spacing: 2px;
            color: #f26b21;
            margin-bottom: 10px;
        }

        .partner-showcase-line {
            display: inline-block;
            width: 40px;
            height: 2px;
            background: #f26b21;
            margin-bottom: 15px;
        }

        .partner-showcase-subtitle {
            font-size: 14px;
            color: #777;
            margin-bottom: 20px;
        }

        .partner-showcase-logos {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 30px;
            flex-wrap: wrap;
        }

        .partner-showcase-logos img {
            max-width: 120px;
            cursor: pointer;
            transition: transform 0.3s ease;
        }

        .partner-showcase-logos img:hover {
            transform: scale(1.05);
        }

        /* Modal */
        .partner-image-modal {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.8);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .partner-image-modal img {
            max-width: 90%;
            max-height: 90%;
            background: #fff;
            padding: 10px;
        }

        .partner-modal-close {
            position: absolute;
            top: 30px;
            right: 40px;
            font-size: 40px;
            color: #fff;
            cursor: pointer;
        }

        /* Mobile */
        @media (max-width: 768px) {
            .partner-showcase-logos {
                gap: 30px;
            }

            .partner-showcase-logos img {
                max-width: 120px;
            }
        }
    </style>
</head>

<body>
    <section class="partner-showcase-section">
        <div class="partner-showcase-container">

            <h2 class="partner-showcase-title">WHO WE PARTNERED WITH</h2>
            <span class="partner-showcase-line"></span>
            <p class="partner-showcase-subtitle">
                Curated Partners. Great Products. Impeccable Finish
            </p>

            <div class="partner-showcase-logos">
                <img src="./assets/images/p1.jpg" alt="Partner 1" onclick="openPartnerImage(this)">
                <img src="./assets/images/p2.avif" alt="Partner 2" onclick="openPartnerImage(this)">
                <img src="./assets/images/p3.png" alt="Partner 3" onclick="openPartnerImage(this)">
                <img src="./assets/images/p4.png" alt="Partner 4" onclick="openPartnerImage(this)">
                <img src="./assets/images/p5.avif" alt="Partner 5" onclick="openPartnerImage(this)">
                <img src="./assets/images/p6.png" alt="Partner 6" onclick="openPartnerImage(this)">
                <img src="./assets/images/p7.png" alt="Partner 7" onclick="openPartnerImage(this)">
                <img src="./assets/images/p8.png" alt="Partner 8" onclick="openPartnerImage(this)">
                <img src="./assets/images/p9.png" alt="Partner 8" onclick="openPartnerImage(this)">
                <img src="./assets/images/p10.png" alt="Partner 8" onclick="openPartnerImage(this)">
            </div>

        </div>
    </section>

    <div class="partner-image-modal" id="partnerImageModal">
        <span class="partner-modal-close" onclick="closePartnerImage()">×</span>
        <img id="partnerModalImg">
    </div>

    <script>
        function openPartnerImage(img) {
            document.getElementById('partnerModalImg').src = img.src;
            document.getElementById('partnerImageModal').style.display = 'flex';
        }

        function closePartnerImage() {
            document.getElementById('partnerImageModal').style.display = 'none';
        }
    </script>


</body>

</html>