<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

    <style>
        .dt-section {
            background: rgba(255, 255, 255, 0.95);
            padding: 20px 20px;
        }

        .dt-container {
            max-width: 1200px;
            margin-left: auto;
            margin-right: auto;
            text-align: center;
        }

        .dt-heading {
            font-size: 26px;
            color: #f36b21;
            letter-spacing: 1px;
            margin-bottom: 8px;
        }

        .dt-heading-line {
            display: block;
            width: 40px;
            height: 3px;
            background-color: #f36b21;
            margin: 0 auto 20px auto;
        }

        .dt-description {
            max-width: 900px;
            margin-left: auto;
            margin-right: auto;
            font-size: 14px;
            line-height: 1.7;
            color: #555;
            margin-bottom: 40px;
        }

        .dt-grid {
            display: flex;
            gap: 30px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .dt-card {
            position: relative;
            width: 100%;
            max-width: 585px;
            overflow: hidden;
            border: 2px solid #f36b21;
        }

         

        .dt-card img {
            width: 100%;
            height: auto;
            display: block;
        }

        .dt-card-label {
            position: absolute;
            bottom: 12px;
            left: 12px;
            background: rgba(0, 0, 0, 0.75);
            color: #ffffff;
            padding: 6px 16px;
            font-size: 18px;
            border-radius: 2px;
        }

        .dt-viewall-wrapper {
            margin-top: 40px;
        }

        .dt-viewall-btn {
            display: inline-block;
            padding: 12px 36px;
            border: 1px solid #f36b21;
            color: #f36b21;
            text-decoration: none;
            font-size: 14px;
            transition: all 0.3s ease;
            font-weight: 400;
            font-family: "Poppins", sans-serif;
            border-radius: 10px;
        }

        .dt-viewall-btn:hover {
            background-color: #f36b21;
            color: #ffffff;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .dt-heading {
                font-size: 22px;
            }

            .dt-description {
                font-size: 14px;
            }

            .dt-grid {
                gap: 20px;
            }
        }
    </style>
</head>

<body>
    <section class="dt-section">
        <div class="dt-container">

            <h2 class="dt-heading">WHAT WE OFFER</h2>
            <span class="dt-heading-line"></span>

            <p class="dt-description">
    At <strong>Pan India Creation</strong>, we specialize in transforming spaces with creativity and precision. From innovative Interior & Exterior Design to elegant Interior Decor, professional Landscaping, Terrace Gardening, and a fully equipped Plant Nursery — we offer complete solutions to enhance the beauty and functionality of your residential and commercial spaces across India.
</p>

            <div class="dt-grid">

                <a href="./theme.php">
                    <div class="dt-card">
                        <img src="./assets/images/ed1.png" alt="Zen Theme">
                        <div class="dt-card-label">Interior Design</div>
                    </div>
                </a>

                <a href="./theme.php">
                    <div class="dt-card">
                        <img src="./assets/images/ed2.jpg" alt="Ambassador Theme">
                        <div class="dt-card-label">Exterior Design</div>
                    </div>
                </a>
                
                 <a href="./theme.php">
                    <div class="dt-card">
                        <img src="./assets/images/ed5.png" alt="Ambassador Theme">
                        <div class="dt-card-label">Interior Decor</div>
                    </div>
                </a>

                <a href="./theme.php">
                    <div class="dt-card">
                        <img src="./assets/images/ed3.png" alt="Ambassador Theme">
                        <div class="dt-card-label">Landscaping</div>
                    </div>
                </a>

                <a href="./theme.php">
                    <div class="dt-card">
                        <img src="./assets/images/ed4.png" alt="Ambassador Theme">
                        <div class="dt-card-label">Terrace Gardening</div>
                    </div>
                </a>
                
                <a href="./theme.php">
                    <div class="dt-card">
                        <img src="./assets/images/ed6.png" alt="Ambassador Theme">
                        <div class="dt-card-label">Plant Nursery</div>
                    </div>
                </a>

            </div>

            <div class="dt-viewall-wrapper">
                <a href="./theme.php" class="dt-viewall-btn">View All</a>
            </div>

        </div>
    </section>

</body>

</html>