<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

    <style>
        .hiw-section {
            position: relative;
            padding: 80px 20px;
        }

        .hiw-dark-overlay {
            position: absolute;
            inset: 0;
            background-color: rgba(0, 0, 0, 0.25);
        }

        .hiw-container {
            position: relative;
            max-width: 1200px;
            margin: 0 auto;
            text-align: center;
            color: #ffffff;
        }

        .hiw-title {
            font-size: 32px;
            font-weight: 600;
            letter-spacing: 2px;
        }

        .hiw-subtitle {
            margin-top: 10px;
            font-size: 15px;
            opacity: 0.9;
        }

        .hiw-cards {
            display: flex;
            gap: 30px;
            margin-top: 50px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .hiw-card {
            background-color: white;
            color: #000000;
            width: 340px;
            border-radius: 6px;
            padding: 20px;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.35);
        }

        .hiw-heading-img {
            margin-bottom: 15px;
        }

        .hiw-heading-img img {
            max-width: 100%;
        }

        .hiw-media {
            width: 100%;
            height: 180px;
            overflow: hidden;
            border-radius: 4px;
        }

        .hiw-media img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .hiw-text {
            margin-top: 15px;
            font-size: 14px;
            line-height: 1.6;
            color: #555555;
            text-align: left;
        }

        .hiw-step {
             
            font-weight: 700;
            color: #ff6a00;
            margin-bottom: 5px;
            font-size: 18px;
        }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            
            .hiw-card {
                width: 100%;
                max-width: 360px;
            }

            .hiw-heading-img img {
                max-width: 140px;
            }
        }
    </style>
</head>

<body>
    <section class="hiw-section">
        <div class="hiw-dark-overlay"></div>

        <div class="hiw-container">
            <h2 class="hiw-title">HOW IT WORKS</h2>
            <p class="hiw-subtitle">
                Designing your newly-bought home has never been this simple before
            </p>

            <div class="hiw-cards">
                <div class="hiw-card">
                    <div class="hiw-heading-img">
                        <img src="./assets/images/design.png" alt="We Design">
                    </div>

                    <div class="hiw-media">
                        <img src="./assets/images/ab1.png" alt="Design Process">
                    </div>

                    <p class="hiw-text">
                        <span class="hiw-step">01</span>
                        Book a design consultation with some of Bangalore’s best designers.
                        Get your home designed for the dreams of tomorrow
                    </p>
                </div>

                <div class="hiw-card">
                    <div class="hiw-heading-img">
                        <img src="./assets/images/visual.png" alt="You Visualize">
                    </div>

                    <div class="hiw-media">
                        <img src="./assets/images/ab2.png" alt="Visualize">
                    </div>

                    <p class="hiw-text">
                        <span class="hiw-step">02</span>
                        See your home in every angle and “try before you buy” furniture,
                        using our Virtual Reality walkthrough
                    </p>
                </div>

                <div class="hiw-card">
                    <div class="hiw-heading-img">
                        <img src="./assets/images/imple.png" alt="We Implement">
                    </div>

                    <div class="hiw-media">
                        <img src="./assets/images/ab3.png" alt="Implement">
                    </div>

                    <p class="hiw-text">
                        <span class="hiw-step">03</span>
                        Sit back & relax. In just 60 days, an army of experts will make
                        the Virtual Reality a glorious reality
                    </p>
                </div>
            </div>
        </div>
    </section>

</body>

</html>