<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<link rel="stylesheet" href="css/style.css">
</head>

<body class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'home' : 'inner'; ?>">

<header class="main-header">
    <div class="container">

        <div class="logo">
            <a href="./index.php"><img src="./assets/images/logos.png
" alt="FURDO"></a>
        </div>

        <nav class="nav" id="navMenu">

            <!-- Mobile Logo -->
            <div class="mobile-logo">
                <a href="./index.php"><img src="./assets/images/logos.png
" alt="FURDO"></a>
            </div>

            <ul>
                <li class="dropdown">
                    <a href="javascript:void(0)" class="dropdown-toggle">
                        About <i class="fas fa-chevron-down"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="./about.php">About Us</a></li>
                        <li><a href="./mission.php">Mission | Vision | Values</a></li>
                        <li><a href="./director.php">Director Message</a></li>
                    </ul>
                </li>
                <li class="dropdown">
                    <a href="javascript:void(0)" class="dropdown-toggle">
                        Services <i class="fas fa-chevron-down"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="./theme.php">Interior & Exterior Design</a></li>
                        <li><a href="./theme.php">Interior Decor</a></li>
                        <li><a href="./theme.php">Landscaping</a></li>
                        <li><a href="./theme.php">Terrace Gardening</a></li>
                        <li><a href="./theme.php">Plant Nursery</a></li>
                    </ul>
                </li>
                <li><a href="./projects.php">Recent Projects</a></li>

                <li class="dropdown">
                    <a href="javascript:void(0)" class="dropdown-toggle">
                        Ideas <i class="fas fa-chevron-down"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="./kitchen.php">Kitchen</a></li>
                        <li><a href="#">Living Room</a></li>
                        <li><a href="#">Bedroom</a></li>
                        <li><a href="#">Kids Room</a></li>
                        <li><a href="#">Wardrobes</a></li>
                        <li><a href="#">Puja Room</a></li>
                        <li><a href="#">Foyer</a></li>
                        <li><a href="#">Bar</a></li>
                    </ul>
                </li>

                <li><a href="./usp.php">USP</a></li>
                <li><a href="./csr.php">CSR</a></li>
                <li class="dropdown">
                    <a href="javascript:void(0)" class="dropdown-toggle">
                        Media <i class="fas fa-chevron-down"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="./gallery.php">Image Gallery</a></li>
                        <li><a href="./video.php">Video Gallery</a></li>
                    </ul>
                </li>
                <li><a href="./how-it-work.php">How It Works</a></li>
                <li><a href="./career.php">Career</a></li>
                <li><a href="./contact.php">Get In Touch</a></li>
            </ul>
        </nav>

        <div class="header-right">
            <!--<a href="tel:+91 7323 012345"><i class="fas fa-phone"></i> +91 7323 012345</a>-->
            <!--<a href="tel:1800 123 4747"><i class="fas fa-phone"></i> 1800 123 4747</a>-->
        </div>

        <div class="menu-toggle" id="menuToggle">
            <i class="fas fa-bars"></i>
        </div>

        <div class="menu-close" id="menuClose">
            <i class="fas fa-times"></i>
        </div>

    </div>
</header>

<script src="js/script.js"></script>
</body>
</html>
