    <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    * {
        padding: 0;
        margin: 0;
    }

    a {
        text-decoration: none;
    }

    .nova-footer-wrapper {
        color: white;
    }

    .nova-footer-main {
        background-color: rgba(0, 0, 0, 0.85);
        padding: 20px 20px 40px;
    }

    .nova-footer-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, auto));
        gap: 40px;
        max-width: 1400px;
        margin: 0 auto;
    }

    .nova-footer-column h3 {
        font-size: 20px;
        font-weight: 400;
        margin-bottom: 20px;
        color: white;
        position: relative;
        padding-bottom: 10px;
    }

    .nova-footer-column h3::after {
        content: '';
        position: absolute;
        left: 0;
        bottom: 0;
        width: 50px;
        height: 2px;
        background-color: white;
    }

    .nova-footer-column p {
        font-size: 14px;
        line-height: 1.7;
        color: white;
    }

    .nova-footer-logo {
        margin-bottom: 15px;
    }

    .nova-footer-logo p {
        text-align: justify;
        padding: 5px;
    }

    .nova-footer-logo img {
        max-height: auto;
        width: 350px;
        display: block;
        padding: 5px;
        border:2px solid white;
    }

    /* Links Section */
    .nova-footer-links ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .nova-footer-links ul li {
        margin-bottom: 12px;
    }

    .nova-footer-links ul li a {
        text-decoration: none;
        color: white;
        font-size: 14px;
        display: flex;
        align-items: center;
        transition: color 0.3s ease, transform 0.3s ease;
        font-weight: 400;
    }

    .nova-footer-links ul li a i {
        color: white;
        margin-right: 10px;
        font-size: 12px;
    }

    .nova-footer-links ul li a:hover {
        color: white;
        transform: translateX(5px);
    }

    .nova-footer-links ul li a:hover i {
        color: white;
        transform: translateX(5px);
    }

    .nova-footer-contact-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 15px;
        font-size: 14px;
        color: white;
        font-weight: 400;
    }

    .nova-footer-contact-item i {
        color: white;
        margin-right: 12px;
        margin-top: 3px;
    }

    /* Visitor Counter */
    .visitor-counter {
        display: flex;
        gap: 5px;
        margin-top: 10px;
        font-size: 18px;
        font-weight: 700;
        color: white;
    }

    .visitor-counter span {
        display: inline-block;
        width: 20px;
        text-align: center;
        background-color: orange;
        padding: 5px 0;
        border-radius: 3px;
    }

    .nova-footer-social {
        margin-top: 25px;
    }

    .nova-footer-social a {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 36px;
        height: 36px;
        background-color: rgba(255, 255, 255, 0.1);
        color: white;
        border-radius: 50%;
        margin-right: 10px;
        font-size: 16px;
        transition: background-color 0.3s ease, color 0.3s ease, transform 0.3s ease;
    }

    .nova-footer-social a:hover {
        background-color: #ffcc00;
        color: #203a70;
        transform: translateY(-3px);
    }

    .nova-footer-bottom {
        background-color: white;
        text-align: center;
        padding: 10px;
        font-size: 13px;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
    }

    .nova-footer-bottom p {
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-wrap: wrap;
        gap: 5px;
    }

    .nova-footer-bottom a {
        color: white;
        text-decoration: none;
        font-weight: 400;
    }

    .nova-footer-bottom a:hover {
        text-decoration: underline;
    }

    .designer-logo-link {
        display: inline-block;
        vertical-align: middle;
    }

    .designer-logo-link img {
        height: 30px;
        width: auto;
        vertical-align: middle;
        transition: filter 0.3s ease;
    }

    .designer-logo-link:hover img {
        filter: none;
    }

    /* --- Navigation Buttons --- */
    .nova-footer-nav-buttons {
        display: flex;
        gap: 10px;
        margin-top: 20px;
    }

    .nova-footer-nav-button {
        background-color: #ffcc00;
        color: #203a70;
        border: none;
        padding: 8px 16px;
        border-radius: 5px;
        font-weight: 400;
        cursor: pointer;
        transition: background-color 0.3s ease, color 0.3s ease;
        font-size: 14px;
    }

    .nova-footer-nav-button:hover {
        background-color: #203a70;
        color: #ffcc00;
    }

    /* --- Responsive Design --- */
    @media (max-width: 768px) {
        .nova-footer-grid {
            grid-template-columns: 1fr;
            gap: 30px;
        }

        .nova-footer-column h3::after {
            left: 0;
            transform: none;
        }
        
        .nova-footer-logo img {
        max-height: auto;
        width: 300px;
        }

        .nova-footer-column,
        .nova-footer-links ul,
        .nova-footer-links ul li,
        .nova-footer-contact-item {
            text-align: left;
        }

        .nova-footer-links ul li a,
        .nova-footer-contact-item {
            justify-content: flex-start;
        }

        .nova-footer-nav-buttons {
            flex-direction: column;
        }
    }
</style>
<?php include 'icons.php' ?>
<div class="nova-footer-wrapper">
    <footer class="nova-footer-main">
        <div class="nova-footer-grid">
            <!-- Column 1: About -->
            <div class="nova-footer-column">
                <div class="nova-footer-logo">
                    <a href="./index.php"><img src="./assets/images/logos.png
" alt="Company Logo"></a>
                </div>
                <p style="text-align:justify"><span style="font-weight:600">Pan India Creation</span> is a design-focused company specializing in interior designing and landscaping, dedicated to transforming spaces into elegant, functional, and inspiring environments. We blend creativity, practicality, and natural elements to create spaces that reflect comfort, style, and purpose, serving clients across India.</p><br>
            </div>

            <!-- Column 2: Quick Links -->
            <div class="nova-footer-column nova-footer-links">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="./index.php"><i class="fas fa-angle-right"></i> Home</a></li>
                    <li><a href="./about.php"><i class="fas fa-angle-right"></i> About Us</a></li>
                    <li><a href="./mission.php"><i class="fas fa-angle-right"></i> Mission | Vision | Core Values</a></li>
                    <li><a href="./director.php"><i class="fas fa-angle-right"></i> Director Desk</a></li>
                    <li><a href="#."><i class="fas fa-angle-right"></i>Services</a></li>
                    <li><a href="./usp.php"><i class="fas fa-angle-right"></i>USP</a></li>
                    <li><a href="./csr.php"><i class="fas fa-angle-right"></i>CSR</a></li>
                </ul>
            </div>

            <!-- Column 3: Important Links -->
            <div class="nova-footer-column nova-footer-links">
                <h3>Important Links</h3>
                <ul>
                    <li><a href="./theme.php"><i class="fas fa-angle-right"></i> Theme</a></li>
                    <li><a href="./projects.php"><i class="fas fa-angle-right"></i> Projects</a></li>
                    <li><a href="./how-it-work.php"><i class="fas fa-angle-right"></i> How It Works</a></li>
                    <li><a href="./gallery.php"><i class="fas fa-angle-right"></i> Image Gallery</a></li>
                    <li><a href="./video.php"><i class="fas fa-angle-right"></i> Video Gallery</a></li>
                    <li><a href="./career.php"><i class="fas fa-angle-right"></i> Career</a></li>
                    <li><a href="./contact.php"><i class="fas fa-angle-right"></i> Contact Us</a></li>
                </ul>
            </div>

            <!-- Column 4: Contact Info + Visitor Counter -->
            <div class="nova-footer-column">
                <h3>Contact Info</h3>
                <div class="nova-footer-contact-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <span>Pan India Security & Man Power Pvt. Ltd. 4th Floor, AP Complex, Bailey Road (Near Ranjan Path), Patna (Bihar), PIN: 801503
                        Landmark: In between Ladoo Gopal & Prabhuji</span>
                </div>
                <div class="nova-footer-contact-item">
                    <i class="fas fa-phone"></i>
                    <span><a href="tel:+91 7323 012345" style="color:white">+91 7323 012345</a></span>
                </div>
                <div class="nova-footer-contact-item">
                    <i class="fas fa-phone"></i>
                    <span><a href="tel:1800 123 4747" style="color:white">1800 123 4747</a></span>
                </div>
                <div class="nova-footer-contact-item">
                    <i class="fas fa-envelope"></i>
                    <span><a href="mailto:panindiaservices247@gmail.com" style="color:white">panindiaservices247@gmail.com</a></span>
                </div>

                <!-- Visitor Counter -->
                <div class="visitor-counter">
                    <?php
                    $counter_file = 'counter.txt';
                    if (!file_exists($counter_file)) {
                        file_put_contents($counter_file, '0');
                    }

                    $counter = (int)file_get_contents($counter_file);

                    // Increment only if on index page
                    if (basename($_SERVER['PHP_SELF']) == 'index.php') {
                        $counter++;
                        file_put_contents($counter_file, $counter);
                    }

                    $counter_str = str_pad($counter, 7, '0', STR_PAD_LEFT);

                    // Display each digit in separate span
                    for ($i = 0; $i < 7; $i++) {
                        echo "<span>" . $counter_str[$i] . "</span>";
                    }
                    ?>
                </div>


            </div>
        </div>
    </footer>

    <div class="nova-footer-bottom">
        <p style="color: black; font-weight:500">
            &copy; 2026 <a href="#" style="text-decoration: none; color:black; font-weight:500">PAN INDIA CREATION</a>. All Rights Reserved. | Designed by
            <a href="https://erainfotech.in/" target="_blank" class="designer-logo-link" aria-label="Designer's Portfolio">
                <img src="./assets/images/logo-era.png" alt="Designer Logo">
            </a>
        </p>
    </div>
</div>