<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
</head>

<body>
    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/project-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 100px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Director Message</h1>
        </div>
    </section>
    <style>
        /* ================= ABOUT FOUNDER SECTION ================= */

        .vv-founder-section {
            padding: 40px 20px;
            background: #ffffff;
        }

        .vv-founder-section * {
            box-sizing: border-box;
        }

        .vv-founder-wrapper {
            max-width: 1100px;
            margin: 0 auto;
            position: relative;
            overflow: hidden;
        }

        .vv-founder-bg-text {
            position: absolute;
            top: -20px;
            left: 0;
            font-size: 120px;
            font-weight: 800;
            color: #000;
            opacity: 0.06;
            letter-spacing: 6px;
            pointer-events: none;
        }

        .vv-founder-row {
            display: flex;
            gap: 40px;
            align-items: center;
            flex-wrap: wrap;
        }

        .vv-founder-left {
            flex: 1;
        }

        .vv-founder-heading {
            font-size: 38px;
            font-weight: 700;
            color: #2f2f2f;
            margin-bottom: 10px;
        }

        .vv-founder-heading span {
            color: #f36b21;
        }

        .vv-founder-subtitle {
            font-size: 15px;
            color: #555;
            margin-bottom: 20px;
            font-weight: 500;
        }

        .vv-founder-message {
            font-size: 13px;
            line-height: 1.8;
            color: #444;
            text-align: justify;
            font-weight: 500;
        }

        .vv-founder-right {
            flex: 1;
            text-align: center;
        }

        /* DIRECTOR IMAGE – DESKTOP */
        .vv-founder-image {
            width: 100%;
            max-width: 380px;
            height: auto;
            border-radius: 8px;
        }

        /* ================= TABS ================= */

        .vv-tabs-section {
            margin-top: 50px;
            text-align: center;
        }

        .vv-tabs-buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }

        .vv-tab-btn {
            padding: 10px 24px;
            border: 2px solid #f36b21;
            background: transparent;
            color: #f36b21;
            cursor: pointer;
            font-size: 15px;
            transition: 0.3s;
            font-weight: 500;
        }

        .vv-tab-btn.active {
            background: #f36b21;
            color: #fff;
        }

        .vv-tab-content {
            display: none;
            max-width: 700px;
            margin: 0 auto;
        }

        .vv-tab-content.active {
            display: block;
        }

        /* TAB IMAGE */
        .vv-tab-image {
            width: 100%;
            max-width: 100%;
            height: auto;
            margin-bottom: 15px;
            border: 1.5px solid #eee;
        }

        .vv-tab-text {
            font-size: 14px;
            line-height: 1.7;
            color: #444;
        }

        /* ================= MOBILE FIXES ================= */

        @media (max-width: 768px) {

            .vv-founder-bg-text {
                font-size: 45px;
            }

            .vv-founder-heading {
                font-size: 22px;
            }

            .vv-founder-row {
                flex-direction: column;
                gap: 25px;
            }

            /* SMALL & NATIVE DIRECTOR IMAGE ON MOBILE */
            .vv-founder-image {
                max-width: 180px;
                margin: 0 auto;
                display: block;
            }

            .vv-tab-image {
                max-width: 100%;
            }
        }
    </style>

    <section class="vv-founder-section">
        <div class="vv-founder-wrapper">

            <div class="vv-founder-bg-text">FOUNDER</div>

            <div class="vv-founder-row">
                <div class="vv-founder-left">
                    <h2 class="vv-founder-heading">
                        About <span>Our Founder</span>
                    </h2>

                    <p class="vv-founder-subtitle">Message from the Founder</p>

                    <p class="vv-founder-message">
                        Our journey as a Pan-India interior design firm began with a simple yet powerful
                        vision—to create spaces that are functional, inspiring, and deeply personal.
                        From the outset, the focus has been on delivering thoughtfully designed interiors
                        that combine creativity, quality craftsmanship, and practical solutions tailored
                        to each client’s lifestyle and needs.
                    </p><br>

                    <p class="vv-founder-message">
                        I believe that great interior design goes beyond visual appeal. It is about
                        understanding how people live and work, and translating those insights into
                        well-planned spaces that enhance comfort, efficiency, and well-being. At our
                        organization, we emphasize detailed planning, material quality, and execution
                        excellence to ensure every project meets the highest standards of design and
                        durability.
                    </p><br>

                    <p class="vv-founder-message">
                        As we expand our presence across India, our commitment remains rooted in client
                        satisfaction, transparent processes, and timely delivery. By embracing innovation,
                        skilled professionals, and a collaborative approach, we strive to build long-term
                        relationships and deliver interiors that truly stand the test of time.
                    </p><br>

                    <p class="vv-founder-message">
                        – Mr. Pankaj Kumar, Founder –
                    </p>
                </div>

                <div class="vv-founder-right">
                    <img src="./assets/images/dir.jpeg" alt="Founder Image" class="vv-founder-image">
                </div>
            </div>

        </div>
    </section>

    
    <?php include 'footer.php' ?>
</body>

</html>