<!DOCTYPE html>
<html lang="en">

<head>
       <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            line-height: 1.6;
            color: black;
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }

        img {
            max-width: 100%;
            height: auto;
            display: block;
        }

        .span {
            color: #2e7d32;
            font-weight: bold;
        }

        /* ---------- Banner ---------- */
        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/csr-bn.jfif') no-repeat center center / cover;
            position: relative;
        }

        /* ---------- First Section ---------- */
        .section-wrapper {
            width: 100%;
            background-color: #fff;
            padding: 2rem 1rem;
        }

        .responsive-section {
            max-width: 1200px;
            margin: auto;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 2rem;
        }

        .section-image {
            flex: 1 1 300px;
            text-align: center;
        }

        .section-image img {
            width: 100%;
            max-width: 400px;
            height: auto;
            border-radius: 8px;
        }

        .section-content {
            flex: 1 1 400px;
            padding: 1rem;
            text-align: justify;
        }

        .section-content p {
            margin-bottom: 1.5rem;
            font-size: 0.95rem;
            line-height: 1.7;
        }

        /* ---------- Cards Section ---------- */
        .responsive-card-section {
            max-width: 1200px;
            margin: auto;
            padding: 2rem 1rem;
        }

        .section-title {
            text-align: center;
            font-size: 26px;
            margin-bottom: 2rem;
            position: relative;
            padding-bottom: 1rem;
            font-family: "Poppins", sans-serif;
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 3px;
            background-color: #2e7d32;
        }

        .card-container {
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }

        .card {
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .card-content {
            display: flex;
            flex-direction: column;
        }

        @media (min-width: 768px) {
            .card-content {
                flex-direction: row;
            }

            .card:nth-child(odd) .card-content {
                flex-direction: row-reverse;
            }
        }

        .card-image {
            width: 100%;
            height: 260px;
            object-fit: cover;
        }

        @media (min-width: 768px) {
            .card-image {
                width: 50%;
                height: auto;
            }
        }

        .card-body {
            padding: 2rem;
            width: 100%;
        }

        @media (min-width: 768px) {
            .card-body {
                width: 50%;
            }
        }

        .card-heading {
            font-size: 1.3rem;
            margin-bottom: 1rem;
            color: #2e7d32;
            position: relative;
            padding-bottom: 0.5rem;
        }

        .card-heading::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 50px;
            height: 2px;
            background-color: #2e7d32;
        }

        .card-text {
            font-size: 0.85rem;
            margin-bottom: 1rem;
            line-height: 1.7;
        }

        /* ---------- Mobile Tweaks ---------- */
        @media (max-width: 767px) {
            .custom-banner-section {
                height: 120px;
                margin-top: 50px;
            }

            .section-title {
                font-size: 1.5rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .card-text {
                font-size: 0.9rem;
            }
        }

        @media (max-width: 480px) {
            .section-content p {
                font-size: 0.95rem;
            }

            .card-body {
                padding: 1rem;
            }
        }

        a {
            text-decoration: none;
        }
    </style>
</head>

<body>

    <?php include 'header.php'; ?>

    <section class="custom-banner-section"></section>

    <div class="section-wrapper">
        <div class="responsive-section">
            <div class="section-image">
                <img src="./assets/images/pakshi.jpeg" alt="Pan India Security">
            </div>
            <div class="section-content">
                <p>
                    Pan India Group of Company popularly known as PI Group of company supports and run the
                    <b class="span">PAKSHI FOUNDATION.</b>
                </p>

                <p>
                    <b class="span">PAKSHI FOUNDATION:</b> Aiming to "secure our mother planet Earth and the people on it".
                    It operates effectively by focusing on a blend of
                    <b class="span">environmental conservation, wildlife protection, sustainable development,</b>
                    and <b class="span">community education.</b> Along with this, it also emphasizes the
                    <b class="span">empowerment of women.</b>
                </p>
            </div>
        </div>
    </div>

    <!-- Responsive Cards Section -->
    <section class="responsive-card-section">
        <h2 class="section-title">AIM OF <span class="span">PAKSHI FOUNDATION</span></h2>

        <div class="card-container">
            <!-- Card 1 (Odd) - Image will be on right -->
            <div class="card">
                <div class="card-content">
                    <img src="./assets/images/s1.jpg" alt="Securing Environment" class="card-image">
                    <div class="card-body">
                        <h3 class="card-heading"><b>1. Securing Environment</b></h3>
                        <p class="card-text"><b class="span">• Tree Plantation Drives:</b><br> Organize mass plantation events in urban and rural areas to restore green cover.</p>
                        <p class="card-text"><b class="span">• Reforestation & Afforestation Projects:</b><br> Partner with local authorities to rehabilitate degraded land and increase forest areas.</p>
                        <p class="card-text"><b class="span">• River & Water Body Cleanups:</b><br> Conduct regular cleanup drives and raise awareness about water pollution.</p>
                        <p class="card-text"><b class="span">• Lobby for Stronger Environmental Laws:</b><br> Work with policymakers to enforce stricter regulations on pollution and land use.</p>
                        <p class="card-text"><b class="span">• Partner with NGOs, Corporates, and Governments:</b><br> Combine efforts for funding, reach, and impact.</p>
                        <p class="card-text"><b class="span">• Grants & Support for Green Innovators:</b><br> Offer mentorship and financial backing to eco-conscious startups or projects.</p>
                        <p class="card-text"><b class="span">• GIS & Satellite Data for Land Monitoring:</b><br> Analyze forest cover, deforestation, and water levels.</p>
                    </div>
                </div>
            </div>

            <!-- Card 2 (Even) - Image will be on left -->
            <div class="card">
                <div class="card-content">
                    <img src="./assets/images/s2.jpg" alt="Securing Wildlife" class="card-image">
                    <div class="card-body">
                        <h3 class="card-heading"><b>2. Securing Wildlife</b></h3>
                        <p class="card-text"><b class="span">• Bird & Wildlife Rescue Operations:</b><br> Create helplines, rescue centers, and response teams for injured or endangered birds and animals.</p>
                        <p class="card-text"><b class="span">• Habitat Preservation:</b><br> Work with government and private stakeholders to protect and restore natural habitats.</p>
                        <p class="card-text"><b class="span">• Research & Monitoring:</b><br> Use technology like drones and GPS trackers to study migration patterns, behaviour, and threats to wildlife.</p>
                        <p class="card-text"><b class="span">• Mobile Apps for Bird Sightings & Wildlife Alerts:</b><br> Let citizens report sightings, track injured animals, or get involved.</p>
                        <p class="card-text"><b class="span">• Social Media for Mobilization:</b><br> Build a strong online presence to attract volunteers, donors, and public engagement.</p>
                    </div>
                </div>
            </div>

            <!-- Card 3 (Odd) - Image will be on right -->
            <div class="card">
                <div class="card-content">
                    <img src="./assets/images/s3.jpg" alt="Sustainable Development" class="card-image">
                    <div class="card-body">
                        <h3 class="card-heading"><b>3. Securing Sustainable Development</b></h3>
                        <p class="card-text"><b class="span">• Promote Organic Farming & Eco-Friendly Products:</b><br> Help farmers adopt sustainable practices and connect them to green markets.</p>
                        <p class="card-text"><b class="span">• Waste Management Solutions:</b><br> Implement community recycling, composting, and zero-waste education programs.</p>
                        <p class="card-text"><b class="span">• Renewable Energy Projects:</b><br> Encourage use of solar, wind, and biogas, especially in rural communities.</p>
                    </div>
                </div>
            </div>

            <!-- Card 4 (Even) - Image will be on left -->
            <div class="card">
                <div class="card-content">
                    <img src="./assets/images/s4.jpg" alt="Securing Communities" class="card-image">
                    <div class="card-body">
                        <h3 class="card-heading"><b>4. Securing Communities</b></h3>
                        <p class="card-text"><b class="span">• Environmental Education in Schools:</b><br> Design curriculums and extracurricular activities that teach kids the importance of ecological balance.</p>
                        <p class="card-text"><b class="span">• Awareness Campaigns:</b><br> Use media, workshops, and social events to spread knowledge about climate change, pollution, and conservation.</p>
                        <p class="card-text"><b class="span">• Volunteer Programs:</b><br> Engage youth and citizens in action-oriented programs like cleanups, surveys, and nature clubs.</p>
                    </div>
                </div>
            </div>

            <!-- Card 5 (Odd) - Image will be on right -->
            <div class="card">
                <div class="card-content">
                    <img src="./assets/images/s5.jpg" alt="Women Empowerment" class="card-image">
                    <div class="card-body">
                        <h3 class="card-heading"><b>5. Securing Women's Socio-Economic Condition</b></h3>
                        <p class="card-text">Women's empowerment and skill development across India, including in regions like Patna, Bihar. These organisations implement a variety of programs aimed at enhancing women's socio-economic status through education, vocational training, and leadership development.</p>
                        <p class="card-text"><b class="span">• Vocational Training and Skill Development:</b><br> Pakshi Foundation provide training in diverse fields such as saloon professional, tailoring, digital literacy, financial management, and entrepreneurship to equip women with marketable skills.</p>
                        <p class="card-text"><b class="span">• Economic Empowerment through Self-Help Groups (SHGs):</b><br> Pakshi in Bihar focus on forming and nurturing SHGs, enabling women to engage in collective savings and income-generating activities, thereby fostering financial independence.</p>
                        <p class="card-text"><b class="span">• Education and Leadership Development</b><br> Pakshi in Patna emphasize improving the quality of life for rural women through educational programs, skill development and leadership training, aiming to enhance their participation in community decision-making. <br><br> The Pakshi Foundation supports innovative solutions by facilitating their access to digital technology, which is crucial for education, healthcare, and livelihood opportunities. We access social media for mobilisation and build a strong online presence to attract volunteers, donors, and public engagement for effective positive change.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php include 'footer.php'; ?>

</body>

</html>