<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
</head>

<body>
    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/contact-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 80px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 120px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Contact With Us</h1>
        </div>
    </section>

    <section class="vv-contact-section">
        <div class="vv-contact-container">

            <!-- LEFT SIDE -->
            <div class="vv-contact-left">
                <div class="vv-contact-scroll">

                    <h4 class="vv-contact-title">PAN INDIA CREATION-PATNA (BIHAR)</h4>
                    <p><a>Pan India Security & Man Power Pvt. Ltd.
                            4th Floor, AP Complex,
                            Bailey Road (Near Ranjan Path),
                            Patna (Bihar), PIN: 801503 <br>
                            Landmark: In between Ladoo Gopal & Prabhuji</a></p>
                    <p><a href="tel:+91 7323 012345">Contact No: +91 7323 012345</a></p>
                    <p><a href="tel:1800 123 4747">Toll Free No: 1800 123 4747</a></p>
                    <p><a href="mailto:panindiaservices247@gmail.com">Email: panindiaservices247@gmail.com</a></p>
                    <p><a href="#">Website: www.domain</a></p>

                    <hr>

                    <!-- MAP INSTEAD OF BANGALORE & MUMBAI -->

                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d7195.34106836698!2d85.051979!3d25.615862!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39ed565ad89614eb%3A0xbac67afc3875b339!2sPan%20India%20Security%20%26%20Manpower%20Pvt%20Ltd!5e0!3m2!1sen!2sin!4v1769604888441!5m2!1sen!2sin"
                        width="100%"
                        height="200"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>

                </div>
            </div>

            <!-- RIGHT SIDE -->
            <div class="vv-contact-right">
                <h2 class="vv-form-heading">Get <span class="span">In Touch</span> With Us</h2>

                <form class="vv-contact-form" action="send-mail.php" method="post">

                    <input type="text" name="name" placeholder="Enter Name" required>
                    <input type="email" name="email" placeholder="Enter Email Id" required>

                    <input type="text" name="phone" placeholder="Enter Phone No" required>
                    <textarea name="message" placeholder="Message" required></textarea>

                    <div class="vv-form-row">
                        <span class="vv-captcha-box" id="vvCaptcha"></span>
                        <input type="text" name="captcha_input" placeholder="Enter Code" required>
                        <button type="submit" name="submit">Submit</button>
                    </div>

                </form>
            </div>

        </div>
    </section>

    <style>
        .vv-contact-section {
            padding: 40px 0;
            background: #ffffff;
        }

        .vv-contact-container {
            max-width: 1200px;
            margin: auto;
            display: flex;
            gap: 30px;
            padding: 0 15px;
        }

        .vv-contact-left {
            width: 50%;
            border-right: 1px solid #ddd;
        }

        .vv-contact-scroll {
            max-height: 500px;
            overflow-y: auto;
            padding-right: 15px;
        }

        .vv-contact-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .vv-contact-left p {
            font-size: 14px;
            color: #555;
            margin-bottom: 6px;
        }

        .vv-contact-left p a {
            color: #555;
        }

        .vv-contact-left hr {
            margin: 20px 0;
            border: none;
            border-top: 1px solid #ddd;
        }

        .vv-contact-right {
            width: 50%;
        }

        .vv-form-heading {
            font-size: 26px;
            margin-bottom: 20px;
            font-weight: 600;
        }

        .vv-contact-form input,
        .vv-contact-form select,
        .vv-contact-form textarea {
            width: 100%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            font-size: 14px;
        }

        .vv-contact-form textarea {
            resize: none;
            height: 100px;
        }

        .vv-form-row {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .vv-captcha-box {
            padding: 12px 16px;
            background: #f3f3f3;
            font-weight: bold;
            letter-spacing: 3px;
            border: 1px solid #ccc;
        }

        .vv-form-row input {
            flex: 1;
        }

        .vv-form-row button {
            padding: 12px 25px;
            border: none;
            background: #ff6600;
            color: #fff;
            cursor: pointer;
            font-size: 14px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .vv-contact-container {
                flex-direction: column;
            }

            .vv-contact-left,
            .vv-contact-right {
                width: 100%;
                border: none;
            }

            .vv-form-row {
                flex-direction: column;
                align-items: stretch;
            }
        }
    </style>

    <script>
        function generateCaptcha() {
            const code = Math.floor(100 + Math.random() * 900);
            document.getElementById("vvCaptcha").innerText = code;
        }
        generateCaptcha();
    </script>

    <?php include 'footer.php' ?>
</body>

</html>