<!DOCTYPE html>
<html lang="en">

<head>
       <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

</head>

<body>
    <?php include 'header.php' ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/career-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 60px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.1rem;
                margin: 0;
                position: relative;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Build Your Career With Pan India Creation</h1>
        </div>
    </section>
    <div class="vvsc-career-section">
        <div class="vvsc-career-container">

            <h2 class="vvsc-career-title">
                Ready to <span>Build Your Career With Pan India Creation?</span>
            </h2>

            <p class="vvsc-career-desc">
                At Pan India Creation, we believe exceptional spaces are created by passionate
                people. Our team is the foundation of our success, and we are committed to
                fostering a creative, professional, and growth-driven environment for everyone
                who becomes part of our journey.
            </p>

            <p class="vvsc-career-desc">
                We collaborate with skilled designers, project managers, craftsmen, and industry
                experts who bring ideas to life with precision and creativity. Through continuous
                learning, clear career growth opportunities, and a culture built on trust and
                collaboration, Pan India Creation empowers its people to design with confidence
                and deliver excellence across every project.
            </p>



            <div class="vvsc-career-filters">
                <select class="vvsc-career-select">
                    <option>All Job Type</option>
                </select>

                <select class="vvsc-career-select">
                    <option>All Job Location</option>
                </select>

                <select class="vvsc-career-select">
                    <option>All Company Group</option>
                </select>
            </div>

            <div class="vvsc-career-cards">

                <div class="vvsc-career-card">
                    <div class="vvsc-career-card-title">Senior Interior Designer</div>
                    <p class="vvsc-career-meta">
                        <i class="fa-solid fa-location-dot"></i> Patna (Bihar)
                    </p>
                    <p class="vvsc-career-meta">
                        <i class="fa-solid fa-building"></i> Pan India Creation
                    </p>
                    <a href="./career-detail.php" class="vvsc-career-link">More Details →</a>
                </div>

                <div class="vvsc-career-card">
                    <div class="vvsc-career-card-title">Project Manager – Interior Projects</div>
                    <p class="vvsc-career-meta">
                        <i class="fa-solid fa-location-dot"></i> Patna (Bihar)
                    </p>
                    <p class="vvsc-career-meta">
                        <i class="fa-solid fa-building"></i> Pan India Creation
                    </p>
                    <a href="./career-detail.php" class="vvsc-career-link">More Details →</a>
                </div>

                <div class="vvsc-career-card">
                    <div class="vvsc-career-card-title">Site Supervisor (Interior Works)</div>
                    <p class="vvsc-career-meta">
                        <i class="fa-solid fa-location-dot"></i> Patna (Bihar)
                    </p>
                    <p class="vvsc-career-meta">
                        <i class="fa-solid fa-building"></i> Pan India Creation
                    </p>
                    <a href="./career-detail.php" class="vvsc-career-link">More Details →</a>
                </div>

            </div>


        </div>
    </div>

    <style>
        .vvsc-career-meta i {
            margin-right: 6px;
            color: #f36b21;
        }

        .vvsc-career-section {
            width: 100%;
            padding: 50px 20px;
            background: #ffffff;
        }

        .vvsc-career-container {
            max-width: 1200px;
            margin: auto;
        }

        .vvsc-career-title {
            font-size: 26px;
            font-weight: 600;
            margin-bottom: 15px;
            color: black;
        }

        .vvsc-career-title span {
            color: #f36b21;
        }

        .vvsc-career-desc {
            font-size: 14px;
            color: black;
            line-height: 1.6;
            margin-bottom: 10px;
            text-align: justify;
        }

        .vvsc-career-filters {
            display: flex;
            gap: 20px;
            margin: 30px 0;
            flex-wrap: wrap;
        }

        .vvsc-career-select {
            flex: 1;
            min-width: 220px;
            padding: 12px;
            border: 1px solid #ddd;
            font-size: 14px;
        }

        .vvsc-career-cards {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 25px;
        }

        .vvsc-career-card {
            border: 1px solid #eee;
            padding: 20px;
            background: #fff;
        }

        .vvsc-career-card-title {
            background: #f36b21;
            color: #fff;
            padding: 12px;
            font-weight: 600;
            font-size: 16px;
            margin-bottom: 15px;
        }

        .vvsc-career-meta {
            font-size: 14px;
            color: #444;
            margin: 6px 0;
        }

        .vvsc-career-link {
            display: inline-block;
            margin-top: 15px;
            font-size: 14px;
            color: #f36b21;
            text-decoration: none;
            font-weight: 600;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .vvsc-career-cards {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 600px) {
            .vvsc-career-cards {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <?php include 'footer.php' ?>
</body>

</html>