<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/career-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 60px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.1rem;
                margin: 0;
                position: relative;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <style>
        .vv-job-section {
            padding: 50px 20px;
            background: #ffffff;
            font-family: Arial, sans-serif;
        }

        .vv-job-wrapper {
            max-width: 1200px;
            margin: auto;
            display: flex;
            gap: 40px;
        }

        .vv-job-left {
            flex: 1.2;
        }

        .vv-job-right {
            flex: 0.8;
            background: #f7f7f7;
            padding: 30px;
            border-radius: 6px;
            height: 530px;
        }

        .vv-job-main-heading {
            font-size: 26px;
            margin-bottom: 25px;
            color: #f36b21;
        }

        .vv-job-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px 30px;
            margin-bottom: 25px;
        }

        .vv-job-label {
            color: black;
            font-weight: 600;
        }

        .vv-job-value {
            display: block;
            margin-top: 4px;
            font-size: 14px;
        }

        .vv-job-info p {
            margin: 6px 0;
            font-size: 14px;
        }

        .vv-job-subheading {
            margin-top: 25px;
            font-size: 20px;
        }

        .vv-job-role-title {
            margin-top: 10px;
            font-size: 16px;
            font-weight: bold;
        }

        .vv-job-list {
            margin-top: 10px;
            padding-left: 18px;
        }

        .vv-job-list li {
            margin-bottom: 8px;
            font-size: 14px;
        }

        .vv-form-heading {
            font-size: 20px;
            margin-bottom: 20px;
            font-weight: 600;
        }

        .vv-job-form {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .vv-form-input,
        .vv-form-textarea {
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        .vv-form-textarea {
            min-height: 90px;
            resize: vertical;
        }

        .vv-form-upload small {
            display: block;
            margin-top: 6px;
            font-size: 12px;
        }

        .vv-form-checkbox {
            font-size: 12px;
        }

        .vv-form-btn {
            margin-top: 15px;
            padding: 12px;
            background: #f36b21;
            color: #fff;
            border: none;
            cursor: pointer;
        }

        /* RESPONSIVE */
        @media (max-width: 900px) {
            .vv-job-wrapper {
                flex-direction: column;
            }

            .vv-job-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Build Your Career With Pan India Creation</h1>
        </div>
    </section>

    <section class="vv-job-section">
        <div class="vv-job-wrapper">

            <!-- LEFT PART -->
            <div class="vv-job-left">
                <div class="vv-job-grid">
                    <div class="vv-job-item">
                        <span class="vv-job-label">Job Category:</span>
                        <span class="vv-job-value">Senior Interior Designer</span>
                    </div>

                    <div class="vv-job-item">
                        <span class="vv-job-label">Job Type:</span>
                        <span class="vv-job-value">Full Time</span>
                    </div>

                    <div class="vv-job-item">
                        <span class="vv-job-label">Job Location:</span>
                        <span class="vv-job-value">Pan India</span>
                    </div>

                    <div class="vv-job-item">
                        <span class="vv-job-label">Company Group:</span>
                        <span class="vv-job-value">Pan India Creation</span>
                    </div>
                </div>

                <div class="vv-job-info">
                    <p><strong>Date:</strong> 23rd Jan 2026</p>
                    <p><strong>Designation:</strong> Senior Interior Designer</p>
                    <p><strong>Salary:</strong> Negotiable based on experience + Performance Incentives</p>
                    <p><strong>Experience:</strong> 4+ Years</p>
                    <p><strong>No. Of Vacancies:</strong> 2</p>
                    <p><strong>Phone No.:</strong> +91 7323 012345</p>
                    <p><strong>Toll Free No.:</strong> 1800 123 4747</p>
                    <p><strong>Email Id:</strong> panindiaservices247@gmail.com</p>
                </div>

                <h3 class="vv-job-subheading">Roles & Responsibilities</h3>
                <h4 class="vv-job-role-title">DESIGN & PROJECT EXECUTION</h4>

                <ul class="vv-job-list">
                    <li>Create innovative interior design concepts based on client requirements.</li>
                    <li>Prepare layouts, 3D visualizations, and detailed drawings.</li>
                    <li>Coordinate with project managers, vendors, and site teams for execution.</li>
                    <li>Ensure design quality, timelines, and budget compliance.</li>
                    <li>Attend client meetings and manage design approvals.</li>
                </ul>
            </div>

            <!-- RIGHT PART -->
            <div class="vv-job-right">
                <h3 class="vv-form-heading">Apply Here</h3>

                <form class="vv-job-form">
                    <input class="vv-form-input" type="text" placeholder="Full Name *">
                    <input class="vv-form-input" type="email" placeholder="Email *">
                    <input class="vv-form-input" type="tel" placeholder="Phone *">
                    <textarea class="vv-form-textarea" placeholder="Cover Letter *"></textarea>

                    <div class="vv-form-upload">
                        <input type="file">
                        <small>Allowed Type(s): .pdf, .doc, .docx</small>
                    </div>

                    <label class="vv-form-checkbox">
                        <input type="checkbox">
                        By using this form you agree with the storage and handling of your data by this website.
                    </label>

                    <button class="vv-form-btn">Submit</button>
                </form>
            </div>

        </div>
    </section>

    <?php include 'footer.php' ?>
</body>

</html>