    <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />

<section class="hero-animate-wrap">
    <div class="hero-animate-content">
        <h1 id="heroText" class="hero-text">PAN INDIA CREATION</h1>
        <i class="fas fa-arrow-down hero-down-icon"></i>
    </div>
</section>


<style>
    .hero-animate-wrap {
        width: 100%;
        height: 400px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .hero-animate-content {
        text-align: center;
    }

    .hero-text {
        color: #ffffff;
        margin-bottom: 20px;
        opacity: 0;
        transform: translateY(30px);
        filter: blur(6px);
        transition: all 0.8s ease;
        font-family: "Calistoga", serif;
        font-weight: 500;
        text-transform: uppercase;
    }

    .hero-text.show {
        opacity: 1;
        transform: translateY(0);
        filter: blur(0);
    }

    /* Arrow animation */
    .hero-down-icon {
        color: #ffffff;
        font-size: 32px;
        animation: bounceArrow 1.8s infinite;
    }

    /* Responsive font sizes */
    @media (min-width: 1024px) {
        .hero-text {
            font-size: 60px;
        }
    }

    @media (max-width: 1023px) and (min-width: 768px) {
        .hero-text {
            font-size: 48px;
        }
    }

    @media (max-width: 767px) {
        .hero-text {
            font-size: 34px;
        }

        .hero-down-icon {
            font-size: 26px;
        }
    }

    @keyframes bounceArrow {

        0%,
        100% {
            transform: translateY(0);
        }

        50% {
            transform: translateY(10px);
        }
    }
</style>

<style>
@import url('https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Bree+Serif&family=Bungee&family=Calistoga&family=Carter+One&family=Concert+One&family=Laila:wght@300;400;500;600;700&family=Lobster&family=Merienda:wght@300..900&family=Oleo+Script:wght@400;700&family=Permanent+Marker&family=Rowdies:wght@300;400;700&family=Rozha+One&family=Rubik+Wet+Paint&family=Satisfy&family=Sekuya&family=Tangerine:wght@400;700&display=swap');
</style>    

<script>
    const heroTexts = [
        "PAN INDIA CREATION",
        "BEAUTY THAT MATTERS",
        "Where ideas become interiors",
        "Because every home tells a story",
        "Designed around the way you live"
    ];

    let heroIndex = 0;
    const heroTextEl = document.getElementById("heroText");

    function changeHeroText() {
        heroTextEl.classList.remove("show");

        setTimeout(() => {
            heroIndex = (heroIndex + 1) % heroTexts.length;
            heroTextEl.textContent = heroTexts[heroIndex];
            heroTextEl.classList.add("show");
        }, 500);
    }

    /* Initial load */
    setTimeout(() => heroTextEl.classList.add("show"), 200);

    /* Change every 3 seconds */
    setInterval(changeHeroText, 3000);
</script>