<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Pan India Creation | Interior & Exterior Design, Landscaping & Terrace Gardening Services in India</title>

<meta name="description" content="Pan India Creation is a leading Interior & Exterior Design company in India offering premium interior decor, landscaping, terrace gardening, plant nursery, home renovation, commercial space design, modern architecture solutions, and customized green spaces. We transform homes, offices, villas, apartments, hotels, and commercial properties with innovative design concepts and sustainable greenery solutions across India.">

<meta name="keywords" content="Pan India Creation, interior designer in India, exterior design services, home interior design, commercial interior design, luxury interior decor, landscaping services India, terrace gardening services, rooftop garden design, plant nursery India, garden design company, modern home design, office interior designer, residential interior design, green landscaping solutions, sustainable garden design, balcony garden setup, villa landscaping, architectural design services, home renovation India, best interior company India">

<meta name="author" content="Pan India Creation">
<meta name="robots" content="index, follow">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="rating" content="General">

<!-- Open Graph for social sharing -->
<meta property="og:title" content="Pan India Creation | Transforming Spaces with Interior & Exterior Design">
<meta property="og:description" content="Expert Interior Design, Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. We create elegant, modern and sustainable living spaces.">
<meta property="og:type" content="website">
<meta property="og:locale" content="en_IN">
<meta property="og:image" content="assets/images/logos.png">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Pan India Creation | Interior & Landscaping Experts in India">
<meta name="twitter:description" content="Premium Interior & Exterior Design, Landscaping, Terrace Gardening and Plant Nursery services across India. Transform your space with Pan India Creation.">
<meta name="twitter:image" content="assets/images/favicon.png">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="32x32" href="./assets/images/favicon.png">
<link rel="icon" type="image/png" sizes="16x16" href="./assets/images/favicon.png">
<link rel="apple-touch-icon" href="./assets/images/favicon.png">

<meta name="theme-color" content="#2e7d32">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        .vv-philosophy-section {
            position: relative;
            padding: 40px 20px;
            background: white;
            overflow: hidden;
        }

        .vv-philosophy-wrapper {
            max-width: 1100px;
            margin: 0 auto;
            position: relative;
        }

        .vv-philosophy-bg-text {
            position: absolute;
            top: -20px;
            left: 0;
            font-size: 120px;
            font-weight: 800;
            color: #000000;
            opacity: 0.1;
            letter-spacing: 6px;
            white-space: nowrap;
            pointer-events: none;
        }

        .vv-philosophy-heading {
            font-size: 40px;
            font-weight: 700;
            color: #2f2f2f;
            line-height: 1.3;
            margin-bottom: 10px;
            max-width: 900px;
        }

        .vv-philosophy-heading span {
            color: #f36b21;
        }

        .vv-philosophy-author {
            font-size: 15px;
            color: #666666;
            margin-bottom: 25px;
        }

        .vv-philosophy-text {
            font-size: 14px;
            line-height: 1.8;
            color: #444444;
            max-width: 1200px;
            margin-bottom: 20px;
            text-align: justify;
        }

        @media (max-width:768px) {
            .vv-philosophy-bg-text {
                font-size: 40px;
            }

            .vv-philosophy-heading {
                font-size: 20px;
            }
        }
    </style>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/about-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            top: 130px;
            left: 110px;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 600;
                font-size: 0.8rem;
                margin: 0;
                position: relative;
                top: 80px;
                left: 20px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

</head>

<body>
    <?php include 'header.php' ?>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>About Pan India Creation</h1>
        </div>
    </section>
    <section class="vv-philosophy-section">
        <div class="vv-philosophy-wrapper">

            <div class="vv-philosophy-bg-text">WHO WE ARE</div>

            <h2 class="vv-philosophy-heading">
                Designing spaces that inspire,
                <span>function beautifully, and feel like home.</span>
            </h2>

            <p class="vv-philosophy-author">
                – Mr. Pankaj Kumar, Founder Of Pan India Creation –
            </p>

            <p class="vv-philosophy-text">
                <span style="font-weight:600">Pan India Creation</span> is a design-focused company specializing in <span style="font-weight:600">interior designing and landscaping,</span> dedicated to transforming spaces into elegant, functional, and inspiring environments. We blend creativity, practicality, and natural elements to create spaces that reflect comfort, style, and purpose, serving clients across India.
            </p>
            
<!--            <p class="vv-philosophy-text">-->
<!--    Our expertise extends to comprehensive <span style="font-weight:600">Interior & Exterior Design solutions</span> for residential, commercial, and corporate spaces. From modern apartments and luxury villas to offices, showrooms, and hospitality projects, we carefully plan layouts, lighting, textures, and materials to ensure every detail enhances both beauty and functionality.-->
<!--</p>-->

<!--<p class="vv-philosophy-text">-->
<!--    At Pan India Creation, we believe that nature plays a vital role in modern living. Our specialized <span style="font-weight:600">landscaping and terrace gardening services</span> are designed to create refreshing green spaces, rooftop gardens, balcony gardens, and vertical gardens that improve air quality and add natural charm to urban environments.-->
<!--</p>-->

<!--<p class="vv-philosophy-text">-->
<!--    We also operate a dedicated <span style="font-weight:600">Plant Nursery</span> offering a wide range of indoor plants, outdoor plants, decorative planters, and garden essentials. Our team provides expert guidance to help clients choose low-maintenance, climate-friendly plants suitable for homes, offices, and commercial properties.-->
<!--</p>-->

<!--<p class="vv-philosophy-text">-->
<!--    With a strong commitment to quality craftsmanship, innovative design concepts, and customer satisfaction, Pan India Creation delivers end-to-end project execution across India. Our mission is to transform ordinary spaces into visually stunning, sustainable, and value-enhancing environments that leave a lasting impression.-->
<!--</p>-->


             
        </div>
    </section>
    <?php include 'footer.php' ?>
</body>

</html>