      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <title>OneChef® India | Premium Food Manufacturing Company</title>

      <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

      <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

      <meta name="author" content="OneChef® India">
      <meta name="robots" content="index, follow">
      <meta name="language" content="English">
      <meta name="revisit-after" content="7 days">
      <meta name="rating" content="General">

      <!-- Open Graph for social sharing -->
      <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
      <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
      <meta property="og:type" content="website">
      <meta property="og:locale" content="en_IN">
      <meta property="og:image" content="assets/images/logo.pngfav.jpg">

      <!-- Twitter Card for social sharing -->
      <meta name="twitter:card" content="summary_large_image">
      <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
      <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
      <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

      <!-- Favicon -->
      <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
      <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
      <link rel="apple-touch-icon" href="./assets/images/logo.png">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">

      <section class="np-why-section">
          <div class="np-why-container">

              <h2 class="np-why-title">Why Choose OneChef® India?</h2>
              <p class="np-why-subtitle">
                  Delivering premium food manufacturing solutions with quality, innovation, and reliability you can trust.
              </p>

              <div class="np-why-grid">

                  <!-- Card 1 -->
                  <div class="np-why-card">
                      <div class="np-why-img">
                          <img src="./assets/images/wc1.jpeg" alt="">
                      </div>
                      <h3>Advanced Manufacturing Facilities</h3>
                      <p>
                          Our modern production units use advanced technology and efficient processes to ensure high-quality,
                          consistent, and scalable food manufacturing solutions.
                      </p>
                  </div>

                  <!-- Card 2 -->
                  <div class="np-why-card">
                      <div class="np-why-img">
                          <img src="./assets/images/wc2.jpeg" alt="">
                      </div>
                      <h3>Strict Quality & Food Safety Standards</h3>
                      <p>
                          We follow rigorous hygiene practices and quality control measures to ensure every product meets
                          industry standards, safety regulations, and customer expectations.
                      </p>
                  </div>

                  <!-- Card 3 -->
                  <div class="np-why-card">
                      <div class="np-why-img">
                          <img src="./assets/images/wc3.jpeg" alt="">
                      </div>
                      <h3>Reliable Supply & Timely Delivery</h3>
                      <p>
                          With strong production capacity and efficient logistics, we ensure uninterrupted supply,
                          consistent product availability, and on-time delivery.
                      </p>
                  </div>

                  <!-- Card 4 -->
                  <div class="np-why-card">
                      <div class="np-why-img">
                          <img src="./assets/images/wc4.jpeg" alt="">
                      </div>
                      <h3>Customized Food Solutions</h3>
                      <p>
                          We provide tailored food products and flexible manufacturing solutions designed to support
                          your business growth and evolving market needs.
                      </p>
                  </div>

              </div>

          </div>

      </section>

      <style>
          .np-why-section {
              background: white;
              padding: 20px 20px;
          }

          .np-why-container {
              max-width: 1200px;
              margin: auto;
          }

          .np-why-title {
              font-size: 3rem;
              font-weight: 500;
              margin-bottom: 10px;
              color: brown;
              font-family: "Berkshire Swash", serif;
          }

          .np-why-subtitle {
              font-size: 13px;
              color: brown;
              margin-bottom: 25px;
          }

          .np-why-grid {
              display: grid;
              grid-template-columns: repeat(4, 1fr);
              gap: 30px;
          }

          .np-why-card {
              background: #ffffff;
              padding: 0;
          }

          .np-why-img {
              width: 100%;
              height: auto;
              overflow: hidden;
              margin-bottom: 18px;
          }

          .np-why-img img {
              width: 100%;
              height: 100%;
              object-fit: cover;
              display: block;
          }

          .np-why-card h3 {
              font-size: 16px;
              font-weight: 600;
              margin-bottom: 12px;
              color: brown;
          }

          .np-why-card p {
              font-size: 13px;
              color: black;
              line-height: 1.6;
          }

          /* Tablet */
          @media (max-width: 992px) {
              .np-why-grid {
                  grid-template-columns: repeat(2, 1fr);
              }
          }

          /* Mobile */
          @media (max-width: 600px) {
              .np-why-grid {
                  grid-template-columns: 1fr;
              }

              .np-why-title {
                  font-size: 1.5rem;
              }

              .np-why-subtitle {
                  font-size: 14px;
              }
          }
      </style>