<?php include 'header.php'; ?>
<?php include 'admin/connection.php'; ?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 250px;
            background: url('./assets/images/team-bn.jpeg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: black;
            font-weight: 500;
            font-size: 3rem;
            margin: 0;
            position: relative;
            left: 80px;
            font-family: "Berkshire Swash", serif;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300px;
            }

            .custom-banner-box h1 {
                font-size: 2rem;
                left: 10px;
            }
        }

        /* Team Section */
        .team-section {
            width: 100%;
            padding: 60px 20px;
            background: rgba(255, 255, 255, 0.95);
        }

        .team-container {
            max-width: 1200px;
            margin: auto;
            text-align: center;
        }

        .team-title {
            font-size: 3rem;
            color: brown;
            margin-bottom: 10px;
            font-family: "Berkshire Swash", serif;
            font-weight: 500;
        }

        .team-subtitle {
            font-size: 14px;
            color: brown;
            margin-bottom: 50px;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }

        .team-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 30px;
        }

        .team-card {
            background: #fff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .team-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        }

        .team-image {
            width: 100%;
            height: 280px;
            overflow: hidden;
            position: relative;
        }

        .team-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .team-card:hover .team-image img {
            transform: scale(1.05);
        }

        .team-info {
            padding: 20px 15px;
            background: brown;
            text-align: center;
        }

        .team-name {
            font-size: 18px;
            color: white;
            margin: 0 0 5px;
            font-weight: 600;
        }

        .team-designation {
            font-size: 13px;
            color: rgba(255, 255, 255, 0.8);
            margin: 0;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* No Image Placeholder */
        .no-image-placeholder {
            width: 100%;
            height: 280px;
            background: linear-gradient(135deg, #e0e0e0, #f5f5f5);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .no-image-placeholder i {
            font-size: 80px;
            color: #bbb;
        }

        @media (max-width: 1200px) {
            .team-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        @media (max-width: 992px) {
            .team-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 576px) {
            .team-grid {
                grid-template-columns: 1fr;
            }

            .team-title {
                font-size: 2rem;
            }

            .team-image,
            .no-image-placeholder {
                height: 350px;
            }
        }
    </style>
</head>

<body>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Our Team</h1>
        </div>
    </section>

    <section class="team-section">
        <div class="team-container">
            <h2 class="team-title">Meet Our Experts</h2>
            <p class="team-subtitle">
                Our dedicated team of professionals brings together years of experience in food and beverage distribution, committed to delivering excellence in every aspect of our service.
            </p>

            <div class="team-grid">
                <?php
                $sql = "SELECT * FROM team_members WHERE status = 1 ORDER BY id ASC";
                $res = $conn->query($sql);

                if ($res->num_rows > 0) {
                    while ($row = $res->fetch_assoc()) {
                        $image = !empty($row['image']) ? $row['image'] : '';

                        echo '
                        <div class="team-card">
                            <div class="team-image">';

                        if (!empty($image)) {
                            echo '<img src="./' . htmlspecialchars($image) . '" alt="' . htmlspecialchars($row['name']) . '">';
                        } else {
                            echo '<div class="no-image-placeholder"><i class="fas fa-user"></i></div>';
                        }

                        echo '
                            </div>
                            <div class="team-info">
                                <h3 class="team-name">' . htmlspecialchars($row['name']) . '</h3>
                                <p class="team-designation">' . htmlspecialchars($row['designation']) . '</p>
                            </div>
                        </div>';
                    }
                } else {
                    echo '<p style="text-align:center; width:100%; color:brown; grid-column:1/-1;">No team members found.</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <?php include 'footer.php'; ?>
</body>

</html>