<?php
include 'admin/connection.php';

// Set header to return plain text response for AJAX
header('Content-Type: text/plain');

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // 1. Validate Inputs
    $required = ['product_id', 'name', 'email', 'address', 'quantity'];
    foreach ($required as $field) {
        if (empty($_POST[$field])) {
            echo "missing_fields";
            exit;
        }
    }

    $product_id = (int)$_POST['product_id'];
    $quantity = (int)$_POST['quantity'];

    $name = $conn->real_escape_string(trim($_POST['name']));
    $email = $conn->real_escape_string(trim($_POST['email']));
    $phone = $conn->real_escape_string(trim($_POST['phone']));
    $address = $conn->real_escape_string(trim($_POST['address']));
    $upi_transaction_id = $conn->real_escape_string(trim($_POST['upi_transaction_id']));

    // 2. Check Stock (Server-side safety)
    $stockCheck = $conn->query("SELECT quantity, price FROM products WHERE id = $product_id");
    if ($stockCheck->num_rows == 0) {
        echo "product_not_found";
        exit;
    }

    $productData = $stockCheck->fetch_assoc();
    $currentStock = (int)$productData['quantity'];
    $unitPrice = (float)$productData['price'];
    $totalPrice = $unitPrice * $quantity;

    if ($quantity > $currentStock) {
        echo "out_of_stock";
        exit;
    }

    // 3. Handle File Upload
    $receipt_path = '';
    if (!empty($_FILES['receipt']['name'])) {
        $targetDir = "assets/receipts/";
        if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

        $fileExt = pathinfo($_FILES['receipt']['name'], PATHINFO_EXTENSION);
        $fileName = time() . "_" . uniqid() . '.' . $fileExt;
        $targetFile = $targetDir . $fileName;

        if (move_uploaded_file($_FILES['receipt']['tmp_name'], $targetFile)) {
            $receipt_path = $targetFile;
        } else {
            echo "file_error";
            exit;
        }
    }

    // 4. Insert Order
    $stmt = $conn->prepare("
        INSERT INTO product_orders 
        (product_id, name, email, phone, address, payment_method, payment_receipt, upi_transaction_id, quantity, total_amount, order_date) 
        VALUES (?, ?, ?, ?, ?, 'QR', ?, ?, ?, ?, NOW())
    ");

    if (!$stmt) {
        echo "db_error: " . $conn->error;
        exit;
    }

    $stmt->bind_param(
        "issssssid",
        $product_id,
        $name,
        $email,
        $phone,
        $address,
        $receipt_path,
        $upi_transaction_id,
        $quantity,
        $totalPrice
    );


    if ($stmt->execute()) {
        // 5. Deduct Stock
        $newStock = $currentStock - $quantity;
        $conn->query("UPDATE products SET quantity = $newStock WHERE id = $product_id");

        echo "success";
    } else {
        echo "db_error: " . $stmt->error;
    }
} else {
    header("Location: products.php");
    exit;
}
