      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <title>OneChef® India | Premium Food Manufacturing Company</title>

      <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

      <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

      <meta name="author" content="OneChef® India">
      <meta name="robots" content="index, follow">
      <meta name="language" content="English">
      <meta name="revisit-after" content="7 days">
      <meta name="rating" content="General">

      <!-- Open Graph for social sharing -->
      <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
      <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
      <meta property="og:type" content="website">
      <meta property="og:locale" content="en_IN">
      <meta property="og:image" content="assets/images/logo.pngfav.jpg">

      <!-- Twitter Card for social sharing -->
      <meta name="twitter:card" content="summary_large_image">
      <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
      <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
      <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

      <!-- Favicon -->
      <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
      <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
      <link rel="apple-touch-icon" href="./assets/images/logo.png">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">

      <style>
          .hindi-slider-wrapper {
              width: 100%;
              overflow: hidden;
              position: relative;
          }

          .hindi-slider-container {
              width: 100%;
              height: 520px;
              position: relative;
          }

          .hindi-slider-track {
              display: flex;
              width: 100%;
              height: 100%;
              transition: transform 0.6s ease-in-out;
          }

          .hindi-slide-item {
              min-width: 100%;
              height: 100%;
              position: relative;
              background: #000;
          }

          .hindi-slide-item img,
          .hindi-slide-item video {
              width: 100%;
              height: 100%;
              object-fit: cover;
          }

          /* NAV BUTTONS */
          .hindi-slider-btn {
              position: absolute;
              top: 50%;
              transform: translateY(-50%);
              background: rgba(90, 58, 28, 0.6);
              color: #ffffff;
              border: none;
              font-size: 18px;
              padding: 10px 14px;
              cursor: pointer;
              z-index: 5;
          }

          .hindi-slider-prev {
              left: 12px;
          }

          .hindi-slider-next {
              right: 12px;
          }

          /* DOTS */
          .hindi-slider-dots {
              position: absolute;
              bottom: 14px;
              width: 100%;
              display: flex;
              justify-content: center;
              gap: 8px;
              z-index: 6;
          }

          .hindi-slider-dot {
              width: 10px;
              height: 10px;
              background: #e2d6c3;
              border-radius: 50%;
              cursor: pointer;
          }

          .hindi-slider-dot.active {
              background: #5a3a1c;
          }

          @media (max-width: 1024px) {
              .hindi-slider-container {
                  height: auto;
              }
          }

          @media (max-width: 768px) {
              .hindi-slider-container {
                  height: auto;
              }
          }

          @media (max-width: 480px) {
              .hindi-slider-container {
                  height: auto;
              }
          }
      </style>

      <div class="hindi-slider-wrapper">
          <div class="hindi-slider-container">

              <div class="hindi-slider-track" id="hindiSliderTrack">

                  <!-- <div class="hindi-slide-item">
                <video muted loop playsinline>
                    <source src="./assets/images/v2.mp4" type="video/mp4">
                </video>
            </div> -->

                  <!-- IMAGE SLIDE -->
                  <div class="hindi-slide-item">
                      <img src="./assets/images/bn2.jpg" alt="">
                  </div>

                  <!-- IMAGE SLIDE -->
                  <div class="hindi-slide-item">
                      <img src="./assets/images/bn4.jpg" alt="">
                  </div>

                  <div class="hindi-slide-item">
                      <img src="./assets/images/bn1.jpg" alt="">
                  </div>
                  <div class="hindi-slide-item">
                      <img src="./assets/images/bn3.jpg" alt="">
                  </div>
              </div>

              <button class="hindi-slider-btn hindi-slider-prev" onclick="moveHindiSlide(-1)">❮</button>
              <button class="hindi-slider-btn hindi-slider-next" onclick="moveHindiSlide(1)">❯</button>

              <div class="hindi-slider-dots" id="hindiSliderDots"></div>

          </div>
      </div>

      <script>
          let hindiSlideIndex = 0;
          const hindiSlides = document.querySelectorAll('.hindi-slide-item');
          const hindiTrack = document.getElementById('hindiSliderTrack');
          const hindiDotsContainer = document.getElementById('hindiSliderDots');
          let hindiAutoSlide;

          /* CREATE DOTS */
          hindiSlides.forEach((_, index) => {
              const dot = document.createElement('div');
              dot.className = 'hindi-slider-dot';
              dot.onclick = () => goToHindiSlide(index);
              hindiDotsContainer.appendChild(dot);
          });

          function stopAllVideos() {
              document.querySelectorAll('.hindi-slide-item video').forEach(video => {
                  video.pause();
                  video.currentTime = 0;
              });
          }

          function playActiveVideo() {
              const activeSlide = hindiSlides[hindiSlideIndex];
              const video = activeSlide.querySelector('video');
              if (video) {
                  video.play().catch(() => {});
              }
          }

          /* UPDATE SLIDER */
          function updateHindiSlider() {
              hindiTrack.style.transform = `translateX(-${hindiSlideIndex * 100}%)`;

              document.querySelectorAll('.hindi-slider-dot').forEach((dot, i) => {
                  dot.classList.toggle('active', i === hindiSlideIndex);
              });

              stopAllVideos();
              playActiveVideo();
          }

          /* MOVE SLIDE */
          function moveHindiSlide(step) {
              hindiSlideIndex += step;
              if (hindiSlideIndex >= hindiSlides.length) hindiSlideIndex = 0;
              if (hindiSlideIndex < 0) hindiSlideIndex = hindiSlides.length - 1;
              updateHindiSlider();
              resetHindiAuto();
          }

          function goToHindiSlide(index) {
              hindiSlideIndex = index;
              updateHindiSlider();
              resetHindiAuto();
          }

          /* AUTO SLIDE */
          function startHindiAuto() {
              hindiAutoSlide = setInterval(() => {
                  moveHindiSlide(1);
              }, 8000);
          }

          function resetHindiAuto() {
              clearInterval(hindiAutoSlide);
              startHindiAuto();
          }

          updateHindiSlider();
          startHindiAuto();
      </script>