      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <title>OneChef® India | Premium Food Manufacturing Company</title>

      <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

      <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

      <meta name="author" content="OneChef® India">
      <meta name="robots" content="index, follow">
      <meta name="language" content="English">
      <meta name="revisit-after" content="7 days">
      <meta name="rating" content="General">

      <!-- Open Graph for social sharing -->
      <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
      <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
      <meta property="og:type" content="website">
      <meta property="og:locale" content="en_IN">
      <meta property="og:image" content="assets/images/logo.pngfav.jpg">

      <!-- Twitter Card for social sharing -->
      <meta name="twitter:card" content="summary_large_image">
      <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
      <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
      <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

      <!-- Favicon -->
      <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
      <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
      <link rel="apple-touch-icon" href="./assets/images/logo.png">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">

      <section class="pspl-review-section">
          <div class="pspl-review-container">

              <h2 class="pspl-review-heading">
                  What Our Clients Say
              </h2>

              <div class="pspl-review-slider-wrapper">

                  <button class="pspl-review-nav pspl-review-prev">
                      <i class="fa-solid fa-arrow-left"></i>
                  </button>

                  <div class="pspl-review-slider" id="psplUniqueReviewSlider">

                      <!-- 1 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Mr. Arjun Kapoor</h3>
                              <p>
                                  OneChef India delivers exceptional product quality with consistent taste and reliable manufacturing standards.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 2 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Ms. Priya Sharma</h3>
                              <p>
                                  Their strict hygiene and food safety standards give us complete confidence in their products.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 3 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Mr. Rohit Verma</h3>
                              <p>
                                  OneChef India's efficient production and timely delivery have greatly supported our business operations.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 4 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Ms. Kavita Iyer</h3>
                              <p>
                                  Professional, reliable, and committed to delivering premium food products with consistent quality.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 5 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Mr. Sandeep Nair</h3>
                              <p>
                                  Their advanced manufacturing process ensures reliable supply and superior product standards.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 6 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Ms. Neha Reddy</h3>
                              <p>
                                  We appreciate their strong quality control and commitment to food safety in every batch.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 7 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Mr. Amit Chawla</h3>
                              <p>
                                  OneChef India provides innovative and customized food solutions that help our brand grow.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 8 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Ms. Ritu Malhotra</h3>
                              <p>
                                  Their dedication to quality ingredients and modern production technology truly stands out.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 9 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Mr. Karan Singh</h3>
                              <p>
                                  A dependable food manufacturing partner focused on excellence, consistency, and customer satisfaction.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                      <!-- 10 -->
                      <div class="pspl-review-card">
                          <div class="pspl-review-card-inner">
                              <div class="pspl-review-image">
                                  <img src="./assets/images/review.png">
                              </div>
                              <h3>Ms. Anjali Deshmukh</h3>
                              <p>
                                  OneChef India consistently delivers high-quality food products that meet our expectations and market needs.
                              </p>
                              <div class="pspl-quote-icon">
                                  <i class="fa-solid fa-quote-right"></i>
                              </div>
                          </div>
                      </div>

                  </div>

                  <button class="pspl-review-nav pspl-review-next">
                      <i class="fa-solid fa-arrow-right"></i>
                  </button>

              </div>

          </div>
      </section>

      <style>
          .pspl-review-section {
              background: white;
              padding: 20px 20px;
              font-family: Arial, sans-serif;
          }

          .pspl-review-container {
              max-width: 1300px;
              margin: auto;
              text-align: center;
          }

          .pspl-review-heading {
              font-size: 3rem;
              margin-bottom: 30px;
              font-weight: 500;
              font-family: "Berkshire Swash", serif;
              color: brown;
          }

          .pspl-review-slider-wrapper {
              position: relative;
              overflow: hidden;
          }

          .pspl-review-slider {
              display: flex;
              transition: transform 0.6s ease;
          }

          .pspl-review-card {
              flex: 0 0 25%;
              padding: 25px;
              box-sizing: border-box;
          }

          .pspl-review-card-inner {
              background: #b5122b;
              color: #fff;
              border-radius: 12px;
              padding: 60px 25px 40px;
              position: relative;
              min-height: auto;
              overflow: visible;
          }

          /* IMAGE FIXED */

          .pspl-review-image {
              width: 95px;
              height: 95px;
              border-radius: 50%;
              overflow: hidden;
              position: absolute;
              top: -25px;
              left: 50%;
              transform: translateX(-50%);
              border: 6px solid #b5122b;
              background: #fff;
          }

          .pspl-review-image img {
              width: 100%;
              height: 100%;
              object-fit: cover;
          }

          /* QUOTE FIXED */

          .pspl-quote-icon {
              position: absolute;
              right: 20px;
              bottom: 15px;
              font-size: 80px;
              color: rgba(255, 255, 255, 0.08);
          }

          .pspl-review-card h3 {
              margin-top: 20px;
              font-size: 16px;
              font-weight: 600;
          }

          .pspl-review-card p {
              font-size: 13px;
              line-height: 1.6;
              margin-top: 10px;
          }

          /* NAV BUTTON FIXED */

          .pspl-review-nav {
              position: absolute;
              top: 50%;
              transform: translateY(-50%);
              width: 50px;
              height: 50px;
              border-radius: 50%;
              border: none;
              background: white;
              color: brown;
              font-size: 18px;
              cursor: pointer;
              z-index: 10;
          }

          .pspl-review-prev {
              left: -0px;
          }

          .pspl-review-next {
              right: -0px;
          }

          /* TABLET */

          @media (max-width: 992px) {
              .pspl-review-card {
                  flex: 0 0 50%;
              }
          }

          /* MOBILE */

          @media (max-width: 600px) {

              .pspl-review-card {
                  flex: 0 0 100%;
                  padding: 20px 10px;
              }

              .pspl-review-prev {
                  left: 10px;
              }

              .pspl-review-next {
                  right: 10px;
              }

              .pspl-review-heading {
                  font-size: 2rem;
              }

          }
      </style>


      <script>
          (function() {

              const slider = document.getElementById("psplUniqueReviewSlider");
              const prev = document.querySelector(".pspl-review-prev");
              const next = document.querySelector(".pspl-review-next");

              let index = 0;

              function visibleCards() {
                  if (window.innerWidth <= 600) return 1;
                  if (window.innerWidth <= 992) return 2;
                  return 4;
              }

              function updateSlider() {
                  const cardWidth = slider.children[0].offsetWidth;
                  slider.style.transform = "translateX(-" + (index * cardWidth) + "px)";
              }

              function nextSlide() {
                  const maxIndex = slider.children.length - visibleCards();
                  index = (index >= maxIndex) ? 0 : index + 1;
                  updateSlider();
              }

              function prevSlide() {
                  const maxIndex = slider.children.length - visibleCards();
                  index = (index <= 0) ? maxIndex : index - 1;
                  updateSlider();
              }

              next.addEventListener("click", nextSlide);
              prev.addEventListener("click", prevSlide);

              window.addEventListener("resize", updateSlider);

              setInterval(nextSlide, 4000); // auto slide

          })();
      </script>