<?php
include 'admin/connection.php';

// Fetch product
$product = null;
if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $res = $conn->query("SELECT * FROM products WHERE id = $id");
    if ($res->num_rows > 0) {
        $product = $res->fetch_assoc();
    }
}

if (!$product) {
    header("Location: products.php");
    exit;
}

// Check stock status
$quantity = isset($product['quantity']) ? intval($product['quantity']) : 0;
$isInStock = $quantity > 0;

// Fetch Related Products
$relatedProducts = [];
$category = isset($product['category']) ? $product['category'] : '';

if (!empty($category)) {
    $cat_safe = $conn->real_escape_string($category);
    $relRes = $conn->query("SELECT * FROM products WHERE category = '$cat_safe' AND id != $id ORDER BY RAND() LIMIT 5");
    if ($relRes && $relRes->num_rows > 0) {
        while ($row = $relRes->fetch_assoc()) {
            $relatedProducts[] = $row;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        /* CSS Styles - Kept exactly as requested */
        :root {
            --primary-brown: #6B3E26;
            --light-brown: #8B5A3C;
            --dark-brown: #4A2C1A;
            --cream: white;
            --gold: white;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background-color: var(--cream);
            font-family: 'Inter', sans-serif;
        }

        .detail-reveal {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .detail-reveal.active {
            opacity: 1;
            transform: translateY(0);
        }

        .detail-wrapper {
            background: white;
            border-radius: 20px;
            overflow: hidden;
        }

        .detail-gallery {
            position: relative;
            background: white;
        }

        .detail-badge {
            position: absolute;
            top: 20px;
            left: 20px;
            width: 32px;
            height: 32px;
            border-radius: 6px;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            z-index: 10;
        }

        .detail-badge::after {
            content: '';
            width: 16px;
            height: 16px;
            border-radius: 50%;
        }

        .detail-badge.veg::after {
            background-color: #4CAF50;
        }

        .detail-category {
            position: absolute;
            top: 20px;
            right: 20px;
            background: var(--primary-brown);
            color: white;
            padding: 8px 18px;
            border-radius: 25px;
            font-size: 12px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
            z-index: 10;
        }

        .out-of-stock-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.7);
            z-index: 5;
            display: flex;
            align-items: center;
            justify-content: center;
            pointer-events: none;
        }

        .out-of-stock-text {
            transform: rotate(-30deg);
            font-size: 3rem;
            font-weight: 800;
            color: rgba(220, 53, 69, 0.4);
            text-transform: uppercase;
            letter-spacing: 8px;
            white-space: nowrap;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
            border: 4px solid rgba(220, 53, 69, 0.4);
            padding: 10px 40px;
            border-radius: 8px;
        }

        .main-product-image {
            width: 100%;
            height: 420px;
            object-fit: contain;
            transition: transform 0.6s ease;
        }

        .thumbnail-container {
            display: flex;
            gap: 12px;
            padding: 20px;
            background: rgba(107, 62, 38, 0.02);
            justify-content: center;
        }

        .thumbnail-item {
            width: 70px;
            height: 70px;
            border-radius: 10px;
            overflow: hidden;
            cursor: pointer;
            border: 2px solid transparent;
            transition: all 0.3s ease;
            background: white;
        }

        .thumbnail-item:hover,
        .thumbnail-item.active {
            border-color: var(--primary-brown);
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(107, 62, 38, 0.2);
        }

        .thumbnail-img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .detail-content {
            padding: 40px;
        }

        .detail-title {
            color: var(--primary-brown);
            font-size: 28px;
            font-weight: 600;
            line-height: 1.3;
            margin-bottom: 8px;
        }

        .detail-brand {
            color: var(--light-brown);
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .price-block {
            background: linear-gradient(135deg, rgba(107, 62, 38, 0.05) 0%, rgba(212, 165, 116, 0.1) 100%);
            border-radius: 14px;
            padding: 20px;
            margin-bottom: 28px;
            border: 1px solid rgba(107, 62, 38, 0.08);
        }

        .price-row {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .current-price {
            font-size: 32px;
            font-weight: 700;
            color: var(--primary-brown);
        }

        .original-price {
            font-size: 18px;
            color: var(--light-brown);
            text-decoration: line-through;
            opacity: 0.7;
            margin-left: 12px;
        }

        .discount-tag {
            background: #4CAF50;
            color: white;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }

        .tax-info {
            font-size: 12px;
            color: var(--light-brown);
            margin-top: 8px;
            opacity: 0.8;
        }

        .specs-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 16px;
            margin-bottom: 28px;
        }

        .spec-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 14px 16px;
            background: rgba(107, 62, 38, 0.03);
            border-radius: 10px;
            border: 1px solid rgba(107, 62, 38, 0.08);
        }

        .spec-icon {
            width: 36px;
            height: 36px;
            border-radius: 8px;
            background: var(--primary-brown);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            flex-shrink: 0;
        }

        .spec-text-group {
            display: flex;
            flex-direction: column;
        }

        .spec-label {
            font-size: 11px;
            color: var(--light-brown);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .spec-value {
            font-size: 15px;
            color: var(--primary-brown);
            font-weight: 600;
        }

        .qty-section {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 28px;
        }

        .qty-label {
            font-size: 14px;
            font-weight: 600;
            color: var(--primary-brown);
        }

        .qty-selector {
            display: flex;
            align-items: center;
            border: 2px solid var(--primary-brown);
            border-radius: 10px;
            overflow: hidden;
        }

        .qty-btn {
            width: 44px;
            height: 44px;
            background: transparent;
            border: none;
            color: var(--primary-brown);
            font-size: 18px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .qty-btn:hover {
            background: var(--primary-brown);
            color: white;
        }

        .qty-display {
            width: 60px;
            height: 44px;
            border: none;
            text-align: center;
            font-size: 16px;
            font-weight: 600;
            color: var(--primary-brown);
            background: transparent;
            border-left: 1px solid rgba(107, 62, 38, 0.2);
            border-right: 1px solid rgba(107, 62, 38, 0.2);
        }

        .action-btn {
            padding: 16px 24px;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .btn-buy {
            background: linear-gradient(135deg, var(--primary-brown) 0%, var(--dark-brown) 100%);
            color: white;
            box-shadow: 0 6px 20px rgba(107, 62, 38, 0.35);
        }

        .btn-buy:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(107, 62, 38, 0.45);
        }

        .btn-disabled {
            background: #e0e0e0 !important;
            color: #888 !important;
            cursor: not-allowed !important;
            box-shadow: none !important;
            transform: none !important;
            opacity: 0.8;
        }

        /* Popup Styles */
        .popup-overlay {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            padding: 16px;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .popup-overlay.active {
            display: flex;
            opacity: 1;
        }

        .popup-container {
            background: white;
            border-radius: 16px;
            width: 100%;
            max-width: 420px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.25);
            transform: scale(0.9) translateY(20px);
            transition: transform 0.3s ease;
        }

        .popup-overlay.active .popup-container {
            transform: scale(1) translateY(0);
        }

        .popup-header {
            background: linear-gradient(135deg, var(--primary-brown) 0%, var(--dark-brown) 100%);
            color: white;
            padding: 16px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-radius: 16px 16px 0 0;
        }

        .popup-header h3 {
            font-size: 16px;
            font-weight: 600;
        }

        .popup-close {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s ease;
        }

        .popup-close:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        .popup-body {
            padding: 20px;
        }

        .payment-step {
            display: none;
        }

        .payment-step.active {
            display: block;
        }

        .qr-payment-container {
            display: flex;
            gap: 20px;
            align-items: center;
            margin-bottom: 16px;
        }

        .qr-left {
            flex-shrink: 0;
        }

        .qr-code {
            width: 130px;
            height: 130px;
            background: white;
            border: 2px solid rgba(107, 62, 38, 0.15);
            border-radius: 8px;
            padding: 6px;
        }

        .qr-code img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .qr-right {
            flex-grow: 1;
        }

        .product-info-box {
            background: rgba(107, 62, 38, 0.05);
            border-radius: 8px;
            padding: 12px;
        }

        .product-info-box .name {
            font-size: 14px;
            font-weight: 600;
            color: var(--dark-brown);
            margin-bottom: 8px;
            line-height: 1.4;
        }

        .product-info-box .amount {
            font-size: 22px;
            font-weight: 700;
            color: var(--primary-brown);
        }

        .product-info-box .label {
            font-size: 11px;
            color: var(--light-brown);
        }

        .payment-details {
            background: rgba(107, 62, 38, 0.03);
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 12px;
            font-size: 12px;
            color: var(--dark-brown);
        }

        .payment-details p {
            margin-bottom: 4px;
        }

        .payment-details p:last-child {
            margin-bottom: 0;
        }

        .payment-details strong {
            color: var(--primary-brown);
        }

        .btn-complete {
            width: 100%;
            padding: 12px;
            background: var(--primary-brown);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s ease;
        }

        .btn-complete:hover {
            background: var(--dark-brown);
        }

        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }

        .form-group {
            margin-bottom: 10px;
        }

        .form-group.full-width {
            grid-column: span 2;
        }

        .form-group label {
            display: block;
            font-size: 11px;
            font-weight: 600;
            color: var(--primary-brown);
            margin-bottom: 4px;
        }

        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 8px 10px;
            border: 1.5px solid rgba(107, 62, 38, 0.2);
            border-radius: 6px;
            font-size: 13px;
            color: var(--dark-brown);
            transition: border-color 0.2s ease;
        }

        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-brown);
        }

        .form-group textarea {
            resize: none;
            height: 50px;
        }

        .form-group input[type="file"] {
            padding: 6px;
            font-size: 11px;
        }

        .btn-submit {
            width: 100%;
            padding: 12px;
            background: var(--primary-brown);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s ease;
            margin-top: 6px;
        }

        .btn-submit:hover {
            background: var(--dark-brown);
        }

        .success-step {
            display: none;
            text-align: center;
            padding: 20px 0;
        }

        .success-step.active {
            display: block;
        }

        .success-icon {
            width: 60px;
            height: 60px;
            background: #4CAF50;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 14px;
            animation: successPop 0.4s ease;
        }

        .success-icon i {
            font-size: 26px;
            color: white;
        }

        .success-title {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary-brown);
            margin-bottom: 6px;
        }

        .success-message {
            font-size: 13px;
            color: var(--light-brown);
        }

        @keyframes successPop {
            0% {
                transform: scale(0);
            }

            50% {
                transform: scale(1.1);
            }

            100% {
                transform: scale(1);
            }
        }

        .step-indicator {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-bottom: 14px;
        }

        .step-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: rgba(107, 62, 38, 0.2);
            transition: background 0.3s ease;
            cursor: pointer;
        }

        .step-dot.active {
            background: var(--primary-brown);
        }

        .related-section {
            margin-top: 40px;
        }

        .related-card {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            transition: all 0.3s ease;
            border: 1px solid rgba(107, 62, 38, 0.1);
        }

        .related-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(107, 62, 38, 0.1);
            border-color: var(--primary-brown);
        }

        .related-img-container {
            height: 250px;
            padding: 15px;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .related-img-container img {
            max-height: 100%;
            max-width: 100%;
            object-fit: contain;
        }

        .related-info {
            padding: 15px;
            border-top: 1px solid rgba(107, 62, 38, 0.05);
        }

        .related-name {
            font-weight: 600;
            color: var(--dark-brown);
            font-size: 15px;
            margin-bottom: 5px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .related-price {
            color: var(--primary-brown);
            font-weight: 700;
        }

        @media (max-width: 1024px) {
            .detail-layout {
                grid-template-columns: 1fr !important;
            }
        }

        @media (max-width: 768px) {
            .main-product-image {
                height: 350px;
            }

            .detail-content {
                padding: 24px;
            }

            .detail-title {
                font-size: 24px;
            }

            .current-price {
                font-size: 28px;
            }
        }

        @media (max-width: 576px) {
            .main-product-image {
                height: 280px;
            }

            .detail-content {
                padding: 20px;
            }

            .specs-grid {
                grid-template-columns: 1fr;
            }

            .current-price {
                font-size: 26px;
            }

            .price-row {
                flex-wrap: wrap;
                gap: 10px;
            }

            .qty-section {
                flex-direction: column;
                align-items: stretch;
                gap: 16px;
            }

            .qty-selector {
                align-self: flex-start;
            }

            .action-btn {
                width: 100%;
            }

            .qr-payment-container {
                flex-direction: column;
                text-align: center;
            }

            .form-grid {
                grid-template-columns: 1fr;
            }

            .form-group.full-width {
                grid-column: span 1;
            }
        }

        @media (prefers-reduced-motion: reduce) {

            .detail-reveal,
            .main-product-image,
            .popup-overlay,
            .popup-container {
                transition: none;
            }

            .detail-reveal {
                opacity: 1;
                transform: none;
            }
        }
    </style>
</head>

<?php include 'header.php' ?>

<section class="py-10 px-4 md:px-8">
    <div class="max-w-7xl mx-auto">
        <nav class="mb-6 detail-reveal">
            <ol class="flex items-center gap-2 text-sm flex-wrap" style="color: var(--light-brown);">
                <li><a href="./index.php" style="color: var(--primary-brown);">Home</a></li>
                <li><i class="fa-solid fa-chevron-right text-xs"></i></li>
                <li><a href="./products.php" style="color: var(--primary-brown);">Products</a></li>
                <li><i class="fa-solid fa-chevron-right text-xs"></i></li>
                <li><?= htmlspecialchars($product['name']) ?></li>
            </ol>
        </nav>

        <div class="detail-wrapper detail-reveal">
            <div class="detail-layout grid grid-cols-1 lg:grid-cols-2 gap-0">
                <div class="detail-gallery">
                    <span class="detail-badge <?= $product['diet_type'] ?>" title="<?= ucfirst($product['diet_type']) ?>"></span>
                    <?php if (!empty($product['category'])): ?>
                        <span class="detail-category"><?= htmlspecialchars($product['category']) ?></span>
                    <?php endif; ?>

                    <?php if (!$isInStock): ?>
                        <div class="out-of-stock-overlay">
                            <div class="out-of-stock-text">Sold Out</div>
                        </div>
                    <?php endif; ?>

                    <img src="<?= htmlspecialchars($product['image']) ?>" alt="<?= htmlspecialchars($product['name']) ?>" class="main-product-image" id="mainImage" onerror="this.src='https://via.placeholder.com/400'">
                </div>

                <div class="detail-content">
                    <h1 class="detail-title"><?= htmlspecialchars($product['name']) ?></h1>
                    <p class="detail-brand">
                        <i class="fa-solid fa-award"></i> Brand: OneChef® India
                    </p>

                    <div class="price-block">
                        <div class="price-row">
                            <div class="flex items-baseline">
                                <span class="current-price">₹<?= number_format($product['price'], 0) ?></span>
                                <?php if (!empty($product['original_price']) && $product['original_price'] > $product['price']): ?>
                                    <span class="original-price">₹<?= number_format($product['original_price'], 0) ?></span>
                                <?php endif; ?>
                            </div>
                            <?php
                            if (!empty($product['original_price']) && $product['original_price'] > $product['price']):
                                $perc = round((($product['original_price'] - $product['price']) / $product['original_price']) * 100);
                            ?>
                                <span class="discount-tag"><?= $perc ?>% OFF</span>
                            <?php endif; ?>
                        </div>
                        <p class="tax-info">Inclusive of all taxes.</p>
                    </div>

                    <div class="specs-grid">
                        <div class="spec-item">
                            <div class="spec-icon"><i class="fa-solid fa-weight-hanging"></i></div>
                            <div class="spec-text-group">
                                <span class="spec-label">Weight</span>
                                <span class="spec-value"><?= htmlspecialchars($product['weight']) ?: 'N/A' ?></span>
                            </div>
                        </div>
                        <div class="spec-item">
                            <div class="spec-icon"><i class="fa-solid fa-boxes-stacked"></i></div>
                            <div class="spec-text-group">
                                <span class="spec-label">Availability</span>
                                <span class="spec-value" style="color: <?= $isInStock ? '#4CAF50' : '#dc3545' ?>">
                                    <?= $isInStock ? 'In Stock (' . $quantity . ' available)' : 'Out of Stock' ?>
                                </span>
                            </div>
                        </div>
                        <div class="spec-item">
                            <div class="spec-icon"><i class="fa-solid fa-leaf"></i></div>
                            <div class="spec-text-group">
                                <span class="spec-label">Diet Type</span>
                                <span class="spec-value"><?= ucfirst($product['diet_type']) ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="qty-section">
                        <div class="flex items-center gap-4">
                            <span class="qty-label">Quantity:</span>
                            <div class="qty-selector">
                                <button type="button" class="qty-btn" onclick="updateQty(-1)">−</button>
                                <input type="text" class="qty-display" value="1" id="qtyInput" readonly>
                                <button type="button" class="qty-btn" onclick="updateQty(1)">+</button>
                            </div>
                        </div>

                        <?php if ($isInStock): ?>
                            <button class="action-btn btn-buy" id="buyNowBtn" data-id="<?= $product['id'] ?>" data-name="<?= htmlspecialchars($product['name']) ?>" data-price="<?= $product['price'] ?>" data-stock="<?= $quantity ?>">
                                <i class="fa-solid fa-bolt"></i> Buy Now
                            </button>
                        <?php else: ?>
                            <button class="action-btn btn-buy btn-disabled" disabled>
                                <i class="fa-solid fa-ban"></i> Out of Stock
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- RELATED PRODUCTS SECTION -->
        <?php if (!empty($relatedProducts)): ?>
            <div class="related-section detail-reveal">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-2xl font-bold" style="color: var(--primary-brown);">Related Products</h2>
                    <span class="text-sm" style="color: var(--light-brown);">From category: <?= htmlspecialchars($category) ?></span>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                    <?php foreach ($relatedProducts as $item):
                        $relQty = isset($item['quantity']) ? intval($item['quantity']) : 0;
                        $relInStock = $relQty > 0;
                    ?>
                        <a href="product-detail.php?id=<?= $item['id'] ?>" class="related-card">
                            <div class="related-img-container relative">
                                <img src="<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['name']) ?>" onerror="this.src='https://via.placeholder.com/300'">
                                <?php if (!$relInStock): ?>
                                    <div style="position:absolute;top:50%;left:50%;transform:translate(-50%,-50%) rotate(-30deg);font-size:1.2rem;font-weight:800;color:rgba(220,53,69,0.5);text-transform:uppercase;white-space:nowrap;border:2px solid rgba(220,53,69,0.5);padding:5px 20px;border-radius:4px;">Sold Out</div>
                                <?php endif; ?>
                            </div>
                            <div class="related-info">
                                <h3 class="related-name"><?= htmlspecialchars($item['name']) ?></h3>
                                <div class="flex items-center gap-2">
                                    <span class="related-price">₹<?= number_format($item['price'], 0) ?></span>
                                    <?php if (!empty($item['original_price']) && $item['original_price'] > $item['price']): ?>
                                        <span class="text-xs line-through" style="color: var(--light-brown);">₹<?= number_format($item['original_price'], 0) ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

    </div>
</section>

<!-- Payment Popup -->
<div class="popup-overlay" id="paymentPopup">
    <div class="popup-container">
        <div class="popup-header">
            <h3 id="popupTitle">Payment</h3>
            <button class="popup-close" id="closePopup" aria-label="Close popup">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
        <div class="popup-body">
            <div class="step-indicator">
                <div class="step-dot active" id="dot1"></div>
                <div class="step-dot" id="dot2"></div>
                <div class="step-dot" id="dot3"></div>
            </div>

            <!-- Step 1 -->
            <div class="payment-step active" id="step1">
                <div class="qr-payment-container">
                    <div class="qr-left">
                        <div class="qr-code">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=upi://pay?pa=yourupi@upi&pn=WellexyFoods&am=45" alt="Payment QR Code" id="qrCodeImg">
                        </div>
                    </div>
                    <div class="qr-right">
                        <div class="product-info-box">
                            <div class="name" id="qrProductName">Product Name</div>
                            <div class="label">Total Amount</div>
                            <div class="amount" id="popupTotalPrice">₹0</div>
                        </div>
                    </div>
                </div>

                <div class="payment-details">
                    <p><strong>UPI ID:</strong> wellexyfoods@upi</p>
                    <p><strong>Amount:</strong> <span id="paymentAmount">₹0</span></p>
                    <p><strong>Available Stock:</strong> <span id="availableStock">0</span></p>
                </div>

                <button class="btn-complete" id="completePaymentBtn">I Have Made Payment</button>
            </div>

            <!-- Step 2 -->
            <div class="payment-step" id="step2">
                <form id="orderForm" method="POST" enctype="multipart/form-data">
                    <!-- Action field to identify submission in PHP -->
                    <input type="hidden" name="action" value="submit_order">

                    <input type="hidden" name="product_id" id="formProductId" value="<?= $product['id'] ?>">
                    <input type="hidden" name="quantity" id="formQuantity" value="1">

                    <div class="form-grid">
                        <div class="form-group">
                            <label for="customerName">Full Name</label>
                            <input type="text" id="customerName" name="name" placeholder="Your Name" required>
                        </div>
                        <div class="form-group">
                            <label for="customerContact">Contact No.</label>
                            <input type="tel" id="customerContact" name="phone" placeholder="Phone" required>
                        </div>
                        <div class="form-group">
                            <label for="customerEmail">Email Address</label>
                            <input type="email" id="customerEmail" name="email" placeholder="Email" required>
                        </div>
                        <div class="form-group">
                            <label for="upiId">UPI Transaction ID</label>
                            <input type="text" id="upiId" name="upi_transaction_id" placeholder="Enter UPI Transaction ID" required>
                        </div>
                        <div class="form-group full-width">
                            <label for="customerAddress">Delivery Address</label>
                            <textarea id="customerAddress" name="address" placeholder="Full Address" required></textarea>
                        </div>
                        <div class="form-group full-width">
                            <label for="paymentReceipt">Payment Receipt</label>
                            <input type="file" id="paymentReceipt" name="receipt" accept="image/*" required>
                        </div>
                    </div>
                    <button type="submit" class="btn-submit">Submit Order</button>
                </form>
            </div>

            <!-- Step 3 -->
            <div class="success-step" id="step3">
                <div class="success-icon">
                    <i class="fa-solid fa-check"></i>
                </div>
                <h4 class="success-title">Order Placed Successfully</h4>
                <p class="success-message">Thank you! We will contact you shortly.</p>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php' ?>

<script>
    // Initialize variables from PHP
    const unitPrice = <?= $product['price'] ?>;
    const productId = <?= $product['id'] ?>;
    const productName = "<?= htmlspecialchars($product['name'], ENT_QUOTES) ?>";
    const maxStock = <?= $quantity ?>;
    const isInStock = <?= $isInStock ? 'true' : 'false' ?>;

    let currentQty = 1;
    const qtyInput = document.getElementById('qtyInput');
    const mainImage = document.getElementById('mainImage');

    // Popup elements
    const paymentPopup = document.getElementById('paymentPopup');
    const buyNowBtn = document.getElementById('buyNowBtn');
    const closePopup = document.getElementById('closePopup');
    const completePaymentBtn = document.getElementById('completePaymentBtn');
    const orderForm = document.getElementById('orderForm');
    const popupTitle = document.getElementById('popupTitle');

    // Step elements
    const step1 = document.getElementById('step1');
    const step2 = document.getElementById('step2');
    const step3 = document.getElementById('step3');
    const dot1 = document.getElementById('dot1');
    const dot2 = document.getElementById('dot2');
    const dot3 = document.getElementById('dot3');

    // Price display elements
    const popupTotalPrice = document.getElementById('popupTotalPrice');
    const paymentAmount = document.getElementById('paymentAmount');
    const qrCodeImg = document.getElementById('qrCodeImg');
    const qrProductName = document.getElementById('qrProductName');

    // Scroll reveal animation
    const revealElements = document.querySelectorAll('.detail-reveal');
    const revealObserver = new IntersectionObserver((entries) => {
        entries.forEach((entry, index) => {
            if (entry.isIntersecting) {
                setTimeout(() => {
                    entry.target.classList.add('active');
                }, index * 150);
            }
        });
    }, {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    });

    revealElements.forEach(el => revealObserver.observe(el));

    // Update quantity
    function updateQty(change) {
        const newQty = currentQty + change;
        if (newQty < 1) {
            currentQty = 1;
        } else if (newQty > maxStock) {
            alert('Sorry, only ' + maxStock + ' items available in stock.');
            currentQty = maxStock;
        } else {
            currentQty = newQty;
        }

        if (qtyInput) qtyInput.value = currentQty;
        const formQty = document.getElementById('formQuantity');
        if (formQty) formQty.value = currentQty;

        // Update popup info if open
        updatePriceDisplays();
    }

    // Calculate total
    function calculateTotal() {
        return currentQty * unitPrice;
    }

    // Update price displays
    function updatePriceDisplays() {
        const total = calculateTotal();
        const priceText = '₹' + total;

        popupTotalPrice.textContent = priceText;
        paymentAmount.textContent = priceText;
        document.getElementById('availableStock').textContent = maxStock;

        if (qrProductName) qrProductName.textContent = productName;

        // Update QR code
        const qrUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=upi://pay?pa=wellexyfoods@upi&pn=WellexyFoods&am=' + total;
        qrCodeImg.src = qrUrl;
    }

    // Open popup
    function openPopup() {
        if (!isInStock) return;
        if (currentQty === 0) currentQty = 1;
        updatePriceDisplays();
        paymentPopup.classList.add('active');
        document.body.style.overflow = 'hidden';
        showStep(1);
    }

    // Close popup
    function closePopupHandler() {
        paymentPopup.classList.remove('active');
        document.body.style.overflow = '';
        setTimeout(() => showStep(1), 300);
    }

    // Show step
    function showStep(stepNum) {
        step1.classList.remove('active');
        step2.classList.remove('active');
        step3.classList.remove('active');

        dot1.classList.remove('active');
        dot2.classList.remove('active');
        dot3.classList.remove('active');

        if (stepNum === 1) {
            step1.classList.add('active');
            dot1.classList.add('active');
            popupTitle.textContent = 'Payment';
        } else if (stepNum === 2) {
            step2.classList.add('active');
            dot1.classList.add('active');
            dot2.classList.add('active');
            popupTitle.textContent = 'Complete Order';
        } else if (stepNum === 3) {
            step3.classList.add('active');
            dot1.classList.add('active');
            dot2.classList.add('active');
            dot3.classList.add('active');
            popupTitle.textContent = 'Success';
        }
    }

    // Event Listeners
    if (buyNowBtn) buyNowBtn.addEventListener('click', openPopup);
    closePopup.addEventListener('click', closePopupHandler);
    paymentPopup.addEventListener('click', function(e) {
        if (e.target === paymentPopup) closePopupHandler();
    });
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && paymentPopup.classList.contains('active')) closePopupHandler();
    });
    completePaymentBtn.addEventListener('click', function() {
        showStep(2);
    });

    // Dot Navigation
    dot1.addEventListener('click', function() {
        showStep(1);
    });
    dot2.addEventListener('click', function() {
        showStep(1);
    });
    dot3.addEventListener('click', function() {
        showStep(2);
    });

    // Form submission with AJAX
    orderForm.addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(this);
        // Ensure quantity is set correctly
        formData.set('quantity', currentQty);

        const submitBtn = this.querySelector('.btn-submit');
        const originalText = submitBtn.textContent;
        submitBtn.textContent = 'Processing...';
        submitBtn.disabled = true;

        // Submit to the separate file
        fetch('submit_order.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                if (data.trim() === 'success') {
                    showStep(3);
                    orderForm.reset();
                    currentQty = 1;
                    if (qtyInput) qtyInput.value = 1;

                    setTimeout(() => {
                        closePopupHandler();
                        location.reload();
                    }, 2500);
                } else if (data.trim() === 'out_of_stock') {
                    alert('Sorry, the product went out of stock while you were ordering.');
                    location.reload();
                } else {
                    console.log("Response:", data);
                    alert('An error occurred: ' + data);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error submitting order. Please check your connection.');
            })
            .finally(() => {
                submitBtn.textContent = originalText;
                submitBtn.disabled = false;
            });
    });
</script>

</html>