      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <title>OneChef® India | Premium Food Manufacturing Company</title>

      <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

      <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

      <meta name="author" content="OneChef® India">
      <meta name="robots" content="index, follow">
      <meta name="language" content="English">
      <meta name="revisit-after" content="7 days">
      <meta name="rating" content="General">

      <!-- Open Graph for social sharing -->
      <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
      <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
      <meta property="og:type" content="website">
      <meta property="og:locale" content="en_IN">
      <meta property="og:image" content="assets/images/logo.pngfav.jpg">

      <!-- Twitter Card for social sharing -->
      <meta name="twitter:card" content="summary_large_image">
      <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
      <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
      <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

      <!-- Favicon -->
      <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
      <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
      <link rel="apple-touch-icon" href="./assets/images/logo.png">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">

      <section class="np-partner-section">
    <div class="np-partner-container">

        <h2 class="np-partner-title">
            Partner with OneChef® India to Accelerate Your Brand Growth
        </h2>

        <div class="np-partner-grid">

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p1.svg" alt="Growth">
                </div>
                <p>Expand your brand presence across new markets with strategic marketing support and strong distribution networks.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p2.svg" alt="Brand Value">
                </div>
                <p>Build a powerful brand identity that connects emotionally with customers and increases long-term loyalty.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p3.svg" alt="Promotion">
                </div>
                <p>Boost product visibility through targeted promotional campaigns and digital marketing strategies.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p4.svg" alt="Customer Reach">
                </div>
                <p>Reach the right audience with data-driven marketing insights and customer-focused branding.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p5.svg" alt="Sales">
                </div>
                <p>Increase sales performance with result-oriented marketing plans designed to maximize ROI.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p6.svg" alt="Distribution">
                </div>
                <p>Strengthen market penetration with efficient supply chain coordination and retail partnerships.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p7.svg" alt="Support">
                </div>
                <p>Get dedicated marketing and branding support to ensure smooth campaign execution and consistent growth.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p8.svg" alt="Private Label">
                </div>
                <p>Enhance your market position with customized branding and private label marketing solutions.</p>
            </div>

            <div class="np-partner-card">
                <div class="np-partner-icon">
                    <img src="./assets/images/p9.svg" alt="Innovation">
                </div>
                <p>Stay ahead of competitors with innovative marketing strategies aligned with evolving consumer trends.</p>
            </div>

        </div>
    </div>
</section>

      <style>
          .np-partner-section {
              padding: 20px 20px;
              background: whitesmoke;
          }

          .np-partner-container {
              max-width: 1200px;
              margin: 0 auto;
          }

          .np-partner-title {
              font-size: 2.5rem;
              font-weight: 500;
              margin-bottom: 40px;
              color: brown;
              font-family: "Berkshire Swash", serif;
          }

          .np-partner-grid {
              display: grid;
              grid-template-columns: repeat(3, 1fr);
              gap: 20px;
          }

          .np-partner-card {
              background: #fafafa;
              border: 1px solid #e5e5e5;
              border-radius: 6px;
              padding: 25px;
              display: flex;
              align-items: flex-start;
              gap: 18px;
              transition: 0.3s ease;
          }

          .np-partner-card:hover {
              box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
          }

          .np-partner-icon img {
              width: 80px;
              height: 80px;
              object-fit: contain;
          }

          .np-partner-card p {
              margin: 0;
              font-size: 14px;
              line-height: 1.6;
              color: #555;
          }

          /* Tablet */
          @media (max-width: 992px) {
              .np-partner-grid {
                  grid-template-columns: repeat(2, 1fr);
              }
          }

          /* Mobile */
          @media (max-width: 576px) {
              .np-partner-grid {
                  grid-template-columns: 1fr;
              }

              .np-partner-title {
                  font-size: 1.2rem;
              }
          }
      </style>