<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>OneChef® India | Premium Food Manufacturing Company</title>

  <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

  <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

  <meta name="author" content="OneChef® India">
  <meta name="robots" content="index, follow">
  <meta name="language" content="English">
  <meta name="revisit-after" content="7 days">
  <meta name="rating" content="General">

  <!-- Open Graph for social sharing -->
  <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
  <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
  <meta property="og:type" content="website">
  <meta property="og:locale" content="en_IN">
  <meta property="og:image" content="assets/images/logo.pngfav.jpg">

  <!-- Twitter Card for social sharing -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
  <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
  <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

  <!-- Favicon -->
  <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
  <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
  <link rel="apple-touch-icon" href="./assets/images/logo.png">

  <!-- Accessibility improvements -->
  <meta name="theme-color" content="brown">

  <style>
    * {
      a {
        text-decoration: none;
      }

      font-family: 'Poppins',
      sans-serif;
    }
  </style>
</head>

<body>
  <?php include 'header.php' ?>
  <?php include 'slider.php' ?>
  <?php include 'home-about.php' ?>
  <?php include 'home-services.php' ?>
  <?php include 'home-product.php' ?>
  <?php include 'collaborate.php' ?>
  <?php include 'why-choose.php' ?>
   
  <?php include 'footer.php' ?>
</body>

</html>