      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <title>OneChef® India | Premium Food Manufacturing Company</title>

      <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

      <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

      <meta name="author" content="OneChef® India">
      <meta name="robots" content="index, follow">
      <meta name="language" content="English">
      <meta name="revisit-after" content="7 days">
      <meta name="rating" content="General">

      <!-- Open Graph for social sharing -->
      <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
      <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
      <meta property="og:type" content="website">
      <meta property="og:locale" content="en_IN">
      <meta property="og:image" content="assets/images/logo.pngfav.jpg">

      <!-- Twitter Card for social sharing -->
      <meta name="twitter:card" content="summary_large_image">
      <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
      <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
      <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

      <!-- Favicon -->
      <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
      <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
      <link rel="apple-touch-icon" href="./assets/images/logo.png">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">

      <section class="rr-services-section">
          <div class="rr-services-container">

              <h2 class="rr-services-heading">Solutions For Your Business</h2>
              <p class="rr-services-subtext">
                  Explore our high-quality food manufacturing solutions, designed to deliver premium products, consistent quality, and reliable supply tailored to your business needs.
              </p>


              <div class="rr-services-grid">

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s1.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss1.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Office & Workplace</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s2.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss2.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Cafes & Bakery</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s3.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss3.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Hotels</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s4.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss4.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Restaurants</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s5.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss5.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Caterers</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s6.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss6.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Canteens</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s7.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss7.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Travel & Transportation</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s8.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss8.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Food Delivery</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s9.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss9.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Industrial Manufacturers</div>
                  </div>

                  <div class="rr-service-item">
                      <div class="rr-service-card">
                          <img src="./assets/images/s10.jpeg" alt="" class="rr-service-bg">
                          <div class="rr-service-content">
                              <img src="./assets/images/ss10.svg" alt="" class="rr-service-center-image">
                          </div>
                      </div>
                      <div class="rr-service-title">Leisure & Entertainment</div>
                  </div>

              </div>
          </div>
      </section>

      <style>
          .rr-services-section {
              width: 100%;
              padding: 20px 20px;
              background-color: whitesmoke;
          }

          .rr-services-container {
              max-width: 1200px;
              margin: auto;
          }

          .rr-services-heading {
              text-align: center;
              color: brown;
              font-size: 3rem;
              font-weight: 500;
              margin-bottom: 10px;
              font-family: "Berkshire Swash", serif;
          }

          .rr-services-subtext {
              text-align: center;
              color: brown;
              font-size: 15px;
              max-width: 700px;
              margin: 0 auto 40px;
              line-height: 1.6;
          }

          .rr-services-grid {
              display: grid;
              grid-template-columns: repeat(5, 1fr);
              gap: 25px;
          }

          /* NEW WRAPPER */
          .rr-service-item {
              text-align: center;
          }

          .rr-service-card {
              border-radius: 10px;
              position: relative;
              overflow: hidden;
              height: 250px;
              transition: transform 0.4s ease, box-shadow 0.4s ease;
              cursor: pointer;
          }

          .rr-service-bg {
              position: absolute;
              top: 0;
              left: 0;
              width: 100%;
              height: 100%;
              object-fit: cover;
              z-index: 0;
          }

          .rr-service-content {
              position: relative;
              z-index: 1;
              height: 100%;
              display: flex;
              justify-content: center;
              align-items: center;
              padding: 20px;
          }

          .rr-service-center-image {
              width: 60px;
              height: 60px;
              border-radius: 50%;
              object-fit: cover;
          }

          .rr-service-title {
              font-size: 15px;
              color: brown;
              font-weight: 500;
              margin-top: 12px;
              border: 1px solid brown;
              padding: 10px;
              border-radius: 10px;
          }

          @media (max-width: 992px) {
              .rr-services-grid {
                  grid-template-columns: repeat(2, 1fr);
              }
          }

          @media (max-width: 576px) {
              .rr-services-grid {
                  grid-template-columns: 1fr;
              }

              .rr-services-heading {
                  font-size: 26px;
              }
          }
      </style>