<?php
include 'admin/connection.php'; // Ensure this path is correct

// Fetch active products
$productResult = $conn->query("SELECT * FROM products WHERE status = 1 ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">

    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-brown: #6B3E26;
            --light-brown: #8B5A3C;
            --dark-brown: #4A2C1A;
            --cream: white;
            --gold: #D4A574;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background-color: var(--cream);
            font-family: 'Inter', sans-serif;
        }

        .font-display {
            font-family: "Berkshire Swash", serif;
        }

        /* Hide scrollbar */
        #productSlider {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }

        #productSlider::-webkit-scrollbar {
            display: none;
        }

        /* Scroll animations */
        .reveal {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .reveal.active {
            opacity: 1;
            transform: translateY(0);
        }

        /* Product card styling */
        .product-card {
            background: white;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(107, 62, 38, 0.15);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .product-image-container {
            position: relative;
            background: white;
            overflow: hidden;
        }

        .product-image-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 30% 30%, rgba(212, 165, 116, 0.2) 0%, transparent 60%);
            pointer-events: none;
        }

        .product-image {
            width: 100%;
            height: 280px;
            object-fit: contain;
            transition: transform 0.5s ease;
        }

        .diet-badge {
            position: absolute;
            top: 16px;
            left: 16px;
            width: 28px;
            height: 28px;
            border-radius: 4px;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
            z-index: 2;
        }

        .diet-badge::after {
            content: '';
            width: 14px;
            height: 14px;
            border-radius: 50%;
        }

        .diet-badge.veg::after {
            background-color: #4CAF50;
        }

        .diet-badge.non-veg::after {
            background-color: #F44336;
        }

        .category-tag {
            position: absolute;
            top: 16px;
            right: 16px;
            background: var(--primary-brown);
            color: white;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
            z-index: 2;
        }

        /* --- Out of Stock Styling --- */
        .out-of-stock-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.7);
            z-index: 3;
            /* Above image and badges */
            display: flex;
            align-items: center;
            justify-content: center;
            pointer-events: none;
        }

        .out-of-stock-text {
            transform: rotate(-30deg);
            font-size: 2.5rem;
            font-weight: 800;
            color: rgba(220, 53, 69, 0.4);
            text-transform: uppercase;
            letter-spacing: 5px;
            white-space: nowrap;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
            border: 4px solid rgba(220, 53, 69, 0.4);
            padding: 10px 30px;
            border-radius: 8px;
        }

        .product-name {
            color: var(--primary-brown);
            font-size: 15px;
            font-weight: 500;
            line-height: 1.3;
            margin-bottom: 6px;
        }

        /* Combined Info Row Styling */
        .info-container {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dashed rgba(107, 62, 38, 0.2);
            margin-bottom: 16px;
        }

        .info-group {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .info-icon {
            color: var(--primary-brown);
            font-size: 15px;
        }

        .info-value {
            font-size: 15px;
            color: var(--primary-brown);
            font-weight: 500;
        }

        /* Buttons */
        .btn {
            padding: 12px 20px;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 500;
            text-decoration: none;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            cursor: pointer;
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-brown) 0%, var(--dark-brown) 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(107, 62, 38, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(107, 62, 38, 0.4);
        }

        /* Disabled Button Styling */
        .btn-disabled {
            background: #e0e0e0 !important;
            color: #888 !important;
            cursor: not-allowed !important;
            box-shadow: none !important;
            transform: none !important;
            opacity: 0.8;
        }

        .btn-secondary {
            background: transparent;
            color: var(--primary-brown);
            border: 2px solid var(--primary-brown);
        }

        .btn-secondary:hover {
            background: var(--primary-brown);
            color: white;
        }

        .btn-icon {
            width: 16px;
            height: 16px;
        }

        /* Button container hover effect */
        .btn-group {
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
        }

        .btn-group .btn {
            flex: 1;
            min-width: 130px;
        }

        /* Slider controls */
        .slider-btn {
            background: var(--primary-brown);
            color: white;
            border: none;
            width: 48px;
            height: 48px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 20px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(107, 62, 38, 0.3);
        }

        .slider-btn:hover {
            background: var(--dark-brown);
            transform: scale(1.1);
        }

        /* Payment Popup Styles */
        .popup-overlay {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            padding: 16px;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .popup-overlay.active {
            display: flex;
            opacity: 1;
        }

        .popup-container {
            background: white;
            border-radius: 16px;
            width: 100%;
            max-width: 420px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.25);
            transform: scale(0.9) translateY(20px);
            transition: transform 0.3s ease;
        }

        .popup-overlay.active .popup-container {
            transform: scale(1) translateY(0);
        }

        .popup-header {
            background: linear-gradient(135deg, var(--primary-brown) 0%, var(--dark-brown) 100%);
            color: white;
            padding: 16px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-radius: 16px 16px 0 0;
        }

        .popup-header h3 {
            font-size: 16px;
            font-weight: 600;
        }

        .popup-close {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s ease;
        }

        .popup-close:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        .popup-body {
            padding: 20px;
        }

        /* Payment Step */
        .payment-step {
            display: none;
        }

        .payment-step.active {
            display: block;
        }

        /* QR Layout */
        .qr-payment-container {
            display: flex;
            gap: 20px;
            align-items: center;
            margin-bottom: 16px;
        }

        .qr-left {
            flex-shrink: 0;
        }

        .qr-code {
            width: 130px;
            height: 130px;
            background: white;
            border: 2px solid rgba(107, 62, 38, 0.15);
            border-radius: 8px;
            padding: 6px;
        }

        .qr-code img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .qr-right {
            flex-grow: 1;
        }

        .product-info-box {
            background: rgba(107, 62, 38, 0.05);
            border-radius: 8px;
            padding: 12px;
        }

        .product-info-box .name {
            font-size: 14px;
            font-weight: 600;
            color: var(--dark-brown);
            margin-bottom: 8px;
            line-height: 1.4;
        }

        .product-info-box .amount {
            font-size: 22px;
            font-weight: 700;
            color: var(--primary-brown);
        }

        .product-info-box .label {
            font-size: 11px;
            color: var(--light-brown);
        }

        .payment-details {
            background: rgba(107, 62, 38, 0.03);
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 12px;
            font-size: 12px;
            color: var(--dark-brown);
        }

        .payment-details p {
            margin-bottom: 4px;
        }

        .payment-details p:last-child {
            margin-bottom: 0;
        }

        .payment-details strong {
            color: var(--primary-brown);
        }

        .btn-complete {
            width: 100%;
            padding: 12px;
            background: var(--primary-brown);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s ease;
        }

        .btn-complete:hover {
            background: var(--dark-brown);
        }

        /* Form Styles */
        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }

        .form-group {
            margin-bottom: 10px;
        }

        .form-group.full-width {
            grid-column: span 2;
        }

        .form-group label {
            display: block;
            font-size: 11px;
            font-weight: 600;
            color: var(--primary-brown);
            margin-bottom: 4px;
        }

        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 8px 10px;
            border: 1.5px solid rgba(107, 62, 38, 0.2);
            border-radius: 6px;
            font-size: 13px;
            color: var(--dark-brown);
            transition: border-color 0.2s ease;
        }

        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-brown);
        }

        .form-group textarea {
            resize: none;
            height: 50px;
        }

        .form-group input[type="file"] {
            padding: 6px;
            font-size: 11px;
        }

        .btn-submit {
            width: 100%;
            padding: 12px;
            background: var(--primary-brown);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s ease;
            margin-top: 6px;
        }

        .btn-submit:hover {
            background: var(--dark-brown);
        }

        /* Success Step */
        .success-step {
            display: none;
            text-align: center;
            padding: 20px 0;
        }

        .success-step.active {
            display: block;
        }

        .success-icon {
            width: 60px;
            height: 60px;
            background: #4CAF50;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 14px;
            animation: successPop 0.4s ease;
        }

        .success-icon i {
            font-size: 26px;
            color: white;
        }

        .success-title {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary-brown);
            margin-bottom: 6px;
        }

        .success-message {
            font-size: 13px;
            color: var(--light-brown);
        }

        @keyframes successPop {
            0% {
                transform: scale(0);
            }

            50% {
                transform: scale(1.1);
            }

            100% {
                transform: scale(1);
            }
        }

        /* Step Indicator */
        .step-indicator {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-bottom: 14px;
        }

        .step-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: rgba(107, 62, 38, 0.2);
            transition: background 0.3s ease;
            cursor: pointer;
        }

        .step-dot.active {
            background: var(--primary-brown);
        }

        /* Quantity Selector in Popup */
        .qty-selector-popup {
            display: flex;
            align-items: center;
            margin-top: 8px;
            border: 1px solid rgba(107, 62, 38, 0.3);
            border-radius: 6px;
            overflow: hidden;
            width: fit-content;
        }

        .qty-btn-popup {
            width: 32px;
            height: 32px;
            background: transparent;
            border: none;
            color: var(--primary-brown);
            font-size: 14px;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .qty-btn-popup:hover {
            background: var(--primary-brown);
            color: white;
        }

        .qty-display-popup {
            width: 40px;
            height: 32px;
            border: none;
            text-align: center;
            font-size: 14px;
            font-weight: 600;
            color: var(--primary-brown);
            background: transparent;
            border-left: 1px solid rgba(107, 62, 38, 0.1);
            border-right: 1px solid rgba(107, 62, 38, 0.1);
        }

        /* Reduced motion */
        @media (prefers-reduced-motion: reduce) {

            .reveal,
            .product-card,
            .popup-overlay,
            .popup-container {
                transition: none;
                animation: none;
            }

            .reveal,
            .product-card {
                opacity: 1;
                transform: none;
            }
        }

        /* Responsive */
        @media (max-width: 576px) {
            .product-image {
                height: 220px;
            }

            .product-name {
                font-size: 16px;
            }

            .btn-group {
                flex-direction: column;
            }

            .btn-group .btn {
                width: 100%;
            }

            /* Popup adjustments */
            .qr-payment-container {
                flex-direction: column;
                text-align: center;
            }

            .form-grid {
                grid-template-columns: 1fr;
            }

            .form-group.full-width {
                grid-column: span 1;
            }
        }
    </style>
</head>

<body>

    <section class="py-12 px-4 md:px-8">
        <div class="max-w-7xl mx-auto">

            <!-- Section Header -->
            <div class="text-center mb-12 reveal">
                <h2 class="font-display text-4xl md:text-5xl mb-4" style="color: var(--primary-brown);">
                    Our Products
                </h2>
                <p class="text-base max-w-2xl mx-auto" style="color: var(--primary-brown); opacity: 0.8;">
                    Discover our premium range of food and beverage products, carefully sourced and quality-assured for your business needs.
                </p>
            </div>

            <!-- Slider Wrapper -->
            <div class="relative flex items-center reveal" style="animation-delay: 0.2s;">
                <!-- Previous Button -->
                <button class="slider-btn absolute -left-4 z-10 hidden md:flex" id="prevBtn" aria-label="Previous products">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M15 18l-6-6 6-6" />
                    </svg>
                </button>

                <!-- Products Slider -->
                <div class="flex gap-6 overflow-x-auto scroll-smooth pb-4 w-full" id="productSlider" style="scroll-snap-type: x mandatory; -webkit-overflow-scrolling: touch;">

                    <?php
                    if ($productResult->num_rows > 0):
                        while ($row = $productResult->fetch_assoc()):
                            $badgeClass = ($row['diet_type'] == 'veg') ? 'veg' : 'non-veg';

                            // Check if product is in stock
                            $quantity = isset($row['quantity']) ? intval($row['quantity']) : 0;
                            $isInStock = $quantity > 0;
                    ?>
                            <!-- Product Card Dynamic -->
                            <div class="product-card flex-shrink-0 w-[320px] md:w-[340px]" style="scroll-snap-align: start;">
                                <div class="product-image-container">
                                    <span class="diet-badge <?= $badgeClass ?>" title="<?= ucfirst($row['diet_type']) ?>"></span>
                                    <span class="category-tag"><?= htmlspecialchars($row['category']) ?></span>

                                    <?php if (!$isInStock): ?>
                                        <!-- Updated Watermark Style Overlay -->
                                        <div class="out-of-stock-overlay">
                                            <div class="out-of-stock-text">Sold Out</div>
                                        </div>
                                    <?php endif; ?>

                                    <img src="<?= htmlspecialchars($row['image']) ?>" alt="<?= htmlspecialchars($row['name']) ?>" class="product-image" onerror="this.src='https://via.placeholder.com/300x280?text=No+Image'">
                                </div>
                                <div class="p-5">
                                    <h3 class="product-name"><?= htmlspecialchars($row['name']) ?></h3>
                                    <div class="info-container">
                                        <div class="info-group">
                                            <i class="fa-solid fa-weight-hanging info-icon"></i>
                                            <span class="info-value">Weight : <?= htmlspecialchars($row['weight']) ?: 'N/A' ?></span>
                                        </div>
                                        <div class="info-group">
                                            <i class="fa-solid fa-tag info-icon"></i>
                                            <span class="info-value">Price : Rs <?= number_format($row['price'], 0) ?></span>
                                        </div>
                                    </div>
                                    <div class="btn-group">
                                        <?php if ($isInStock): ?>
                                            <button class="btn btn-primary buy-now-btn"
                                                data-id="<?= $row['id'] ?>"
                                                data-name="<?= htmlspecialchars($row['name']) ?>"
                                                data-price="<?= $row['price'] ?>"
                                                data-stock="<?= $quantity ?>">
                                                <svg class="btn-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                    <circle cx="9" cy="21" r="1" />
                                                    <circle cx="20" cy="21" r="1" />
                                                    <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6" />
                                                </svg>
                                                Buy Now
                                            </button>
                                        <?php else: ?>
                                            <!-- Disabled button, no click functionality, no hover effects -->
                                            <button class="btn btn-primary btn-disabled" disabled>
                                                <i class="fa-solid fa-ban"></i>

                                            </button>
                                        <?php endif; ?>

                                        <!-- View Details button always works -->
                                        <a href="product-detail.php?id=<?= $row['id'] ?>" class="btn btn-secondary">
                                            View Details
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php
                        endwhile;
                    else:
                        ?>
                        <div class="text-center py-10 w-full">
                            <p style="color: var(--primary-brown);">No products found.</p>
                        </div>
                    <?php endif; ?>

                </div>

                <!-- Next Button -->
                <button class="slider-btn absolute -right-4 z-10 hidden md:flex" id="nextBtn" aria-label="Next products">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 18l6-6-6-6" />
                    </svg>
                </button>
            </div>

        </div>
    </section>

    <!-- Payment Popup -->
    <div class="popup-overlay" id="paymentPopup">
        <div class="popup-container">
            <div class="popup-header">
                <h3 id="popupTitle">Payment</h3>
                <button class="popup-close" id="closePopup" aria-label="Close popup">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
            <div class="popup-body">
                <!-- Step Indicator -->
                <div class="step-indicator">
                    <div class="step-dot active" id="dot1"></div>
                    <div class="step-dot" id="dot2"></div>
                    <div class="step-dot" id="dot3"></div>
                </div>

                <!-- Step 1: Payment -->
                <div class="payment-step active" id="step1">
                    <input type="hidden" id="currentProductId" value="">

                    <div class="qr-payment-container">
                        <div class="qr-left">
                            <div class="qr-code">
                                <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=upi://pay?pa=wellexyfoods@upi" alt="Payment QR Code" id="qrCodeImg">
                            </div>
                        </div>
                        <div class="qr-right">
                            <div class="product-info-box">
                                <div class="name" id="qrProductName">Product Name</div>
                                <div class="label">Quantity</div>
                                <div class="qty-selector-popup">
                                    <button class="qty-btn-popup" onclick="updatePopupQty(-1)">−</button>
                                    <input type="text" class="qty-display-popup" value="1" id="qtyInputPopup" readonly>
                                    <button class="qty-btn-popup" onclick="updatePopupQty(1)">+</button>
                                </div>
                                <div class="label" style="margin-top:8px;">Total Amount</div>
                                <div class="amount" id="popupTotalPrice">₹0</div>
                            </div>
                        </div>
                    </div>

                    <div class="payment-details">
                        <p><strong>UPI ID:</strong> wellexyfoods@upi</p>
                        <p><strong>Amount:</strong> <span id="paymentAmount">₹0</span></p>
                        <p><strong>Available Stock:</strong> <span id="availableStock">0</span></p>
                    </div>

                    <button class="btn-complete" id="completePaymentBtn">I Have Made Payment</button>
                </div>

                <!-- Step 2: Form -->
                <div class="payment-step" id="step2">
                    <form id="orderForm" action="submit_order.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="product_id" id="formProductId" value="">
                        <input type="hidden" name="quantity" id="formQuantity" value="1">

                        <div class="form-grid">
                            <div class="form-group">
                                <label>Full Name</label>
                                <input type="text" name="name" placeholder="Your Name" required>
                            </div>
                            <div class="form-group">
                                <label>Contact No.</label>
                                <input type="tel" name="phone" placeholder="Phone" required>
                            </div>
                            <div class="form-group">
                                <label>Email Address</label>
                                <input type="email" name="email" placeholder="Email" required>
                            </div>
                            <div class="form-group">
                                <label>UPI Transaction ID</label>
                                <input type="text" name="upi_transaction_id" placeholder="Enter UPI Transaction ID" required>
                            </div>
                            <div class="form-group full-width">
                                <label>Delivery Address</label>
                                <textarea name="address" placeholder="Full Address" required></textarea>
                            </div>
                            <div class="form-group full-width">
                                <label>Payment Receipt</label>
                                <input type="file" name="receipt" accept="image/*" required>
                            </div>
                        </div>
                        <button type="submit" class="btn-submit">Submit Order</button>
                    </form>
                </div>

                <!-- Step 3: Success -->
                <div class="success-step" id="step3">
                    <div class="success-icon">
                        <i class="fa-solid fa-check"></i>
                    </div>
                    <h4 class="success-title">Order Placed Successfully</h4>
                    <p class="success-message">Thank you! We will contact you shortly.</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // --- Slider Logic ---
        const slider = document.getElementById('productSlider');
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');
        let autoSlideInterval = null;

        // Scroll reveal animation
        const revealElements = document.querySelectorAll('.reveal');
        const revealObserver = new IntersectionObserver((entries) => {
            entries.forEach((entry, index) => {
                if (entry.isIntersecting) {
                    setTimeout(() => {
                        entry.target.classList.add('active');
                    }, index * 150);
                }
            });
        }, {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        });
        revealElements.forEach(el => revealObserver.observe(el));

        // Slider navigation
        function getScrollAmount() {
            const cardWidth = 360; // card width + gap
            return cardWidth;
        }

        if (nextBtn && slider) {
            nextBtn.addEventListener('click', () => {
                slider.scrollBy({
                    left: getScrollAmount(),
                    behavior: 'smooth'
                });
            });
        }

        if (prevBtn && slider) {
            prevBtn.addEventListener('click', () => {
                slider.scrollBy({
                    left: -getScrollAmount(),
                    behavior: 'smooth'
                });
            });
        }

        // Auto slide for mobile
        function startAutoSlide() {
            if (window.innerWidth <= 768 && slider) {
                autoSlideInterval = setInterval(() => {
                    const maxScroll = slider.scrollWidth - slider.clientWidth;
                    if (slider.scrollLeft >= maxScroll - 10) {
                        slider.scrollTo({
                            left: 0,
                            behavior: 'smooth'
                        });
                    } else {
                        slider.scrollBy({
                            left: slider.clientWidth,
                            behavior: 'smooth'
                        });
                    }
                }, 4000);
            }
        }

        function stopAutoSlide() {
            if (autoSlideInterval) {
                clearInterval(autoSlideInterval);
                autoSlideInterval = null;
            }
        }

        window.addEventListener('resize', () => {
            stopAutoSlide();
            startAutoSlide();
        });

        startAutoSlide();

        if (slider) {
            slider.addEventListener('touchstart', stopAutoSlide, {
                passive: true
            });
            slider.addEventListener('touchend', () => {
                setTimeout(startAutoSlide, 2000);
            }, {
                passive: true
            });
        }

        // Keyboard navigation
        document.addEventListener('keydown', (e) => {
            if (e.key === 'ArrowLeft' && slider) slider.scrollBy({
                left: -getScrollAmount(),
                behavior: 'smooth'
            });
            else if (e.key === 'ArrowRight' && slider) slider.scrollBy({
                left: getScrollAmount(),
                behavior: 'smooth'
            });
        });

        // --- Popup Logic ---
        const paymentPopup = document.getElementById('paymentPopup');
        const closePopup = document.getElementById('closePopup');
        const completePaymentBtn = document.getElementById('completePaymentBtn');
        const orderForm = document.getElementById('orderForm');
        const popupTitle = document.getElementById('popupTitle');

        const step1 = document.getElementById('step1');
        const step2 = document.getElementById('step2');
        const step3 = document.getElementById('step3');
        const dot1 = document.getElementById('dot1');
        const dot2 = document.getElementById('dot2');
        const dot3 = document.getElementById('dot3');

        const popupTotalPrice = document.getElementById('popupTotalPrice');
        const paymentAmount = document.getElementById('paymentAmount');
        const qrCodeImg = document.getElementById('qrCodeImg');
        const qrProductName = document.getElementById('qrProductName');
        const qtyInputPopup = document.getElementById('qtyInputPopup');
        const formQuantityInput = document.getElementById('formQuantity');

        let currentProductPrice = 0;
        let currentPopupQty = 1;
        let maxStock = 0;

        // Open Popup (Only for In-Stock items)
        document.querySelectorAll('.buy-now-btn').forEach(btn => {
            btn.addEventListener('click', function(e) {
                // Ripple
                const ripple = document.createElement('span');
                ripple.style.cssText = `position: absolute; background: rgba(255,255,255,0.3); border-radius: 50%; transform: scale(0); animation: ripple 0.6s linear; pointer-events: none;`;
                const rect = this.getBoundingClientRect();
                const size = Math.max(rect.width, rect.height);
                ripple.style.width = ripple.style.height = size + 'px';
                ripple.style.left = (e.clientX - rect.left - size / 2) + 'px';
                ripple.style.top = (e.clientY - rect.top - size / 2) + 'px';
                this.style.position = 'relative';
                this.style.overflow = 'hidden';
                this.appendChild(ripple);
                setTimeout(() => ripple.remove(), 600);

                // Open Popup Logic
                const id = this.getAttribute('data-id');
                const name = this.getAttribute('data-name');
                const price = parseInt(this.getAttribute('data-price'));
                maxStock = parseInt(this.getAttribute('data-stock'));

                currentProductPrice = price;
                currentPopupQty = 1;
                qtyInputPopup.value = 1;
                formQuantityInput.value = 1;

                document.getElementById('currentProductId').value = id;
                document.getElementById('formProductId').value = id;
                document.getElementById('availableStock').textContent = maxStock;

                qrProductName.textContent = name;
                updatePriceDisplays();

                paymentPopup.classList.add('active');
                document.body.style.overflow = 'hidden';
                showStep(1);
            });
        });

        // Update Quantity in Popup
        function updatePopupQty(change) {
            const newQty = currentPopupQty + change;

            if (newQty < 1) {
                currentPopupQty = 1;
            } else if (newQty > maxStock) {
                alert('Sorry, only ' + maxStock + ' items available in stock.');
                currentPopupQty = maxStock;
            } else {
                currentPopupQty = newQty;
            }

            qtyInputPopup.value = currentPopupQty;
            formQuantityInput.value = currentPopupQty;
            updatePriceDisplays();
        }

        // Calculate Total
        function calculateTotal() {
            return currentPopupQty * currentProductPrice;
        }

        // Update Prices
        function updatePriceDisplays() {
            const total = calculateTotal();
            const priceText = '₹' + total;
            popupTotalPrice.textContent = priceText;
            paymentAmount.textContent = priceText;

            const qrUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=upi://pay?pa=wellexyfoods@upi&pn=WellexyFoods&am=' + total;
            qrCodeImg.src = qrUrl;
        }

        // Close Popup
        function closePopupHandler() {
            paymentPopup.classList.remove('active');
            document.body.style.overflow = '';
            setTimeout(() => showStep(1), 300);
        }

        closePopup.addEventListener('click', closePopupHandler);
        paymentPopup.addEventListener('click', function(e) {
            if (e.target === paymentPopup) closePopupHandler();
        });
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && paymentPopup.classList.contains('active')) closePopupHandler();
        });

        // Show Step
        function showStep(stepNum) {
            step1.classList.remove('active');
            step2.classList.remove('active');
            step3.classList.remove('active');

            dot1.classList.remove('active');
            dot2.classList.remove('active');
            dot3.classList.remove('active');

            if (stepNum === 1) {
                step1.classList.add('active');
                dot1.classList.add('active');
                popupTitle.textContent = 'Payment';
            } else if (stepNum === 2) {
                step2.classList.add('active');
                dot1.classList.add('active');
                dot2.classList.add('active');
                popupTitle.textContent = 'Complete Order';
            } else if (stepNum === 3) {
                step3.classList.add('active');
                dot1.classList.add('active');
                dot2.classList.add('active');
                dot3.classList.add('active');
                popupTitle.textContent = 'Success';
            }
        }

        // Dot Navigation (Backward)
        dot1.addEventListener('click', () => showStep(1));
        dot2.addEventListener('click', () => showStep(1));
        dot3.addEventListener('click', () => showStep(2));

        // Step Navigation
        completePaymentBtn.addEventListener('click', () => showStep(2));

        // Form Submit with AJAX
        orderForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);

            fetch('submit_order.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    if (data === 'out_of_stock') {
                        alert('Sorry, the product went out of stock while you were ordering.');
                        location.reload();
                    } else if (data === 'success') {
                        showStep(3);
                        orderForm.reset();
                        setTimeout(() => {
                            closePopupHandler();
                            location.reload(); // Reload to update stock badges
                        }, 2500);
                    } else {
                        alert('Error submitting order. Please try again.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error submitting order. Please try again.');
                });
        });

        // Ripple animation style
        const style = document.createElement('style');
        style.textContent = `
            @keyframes ripple {
                to { transform: scale(4); opacity: 0; }
            }
        `;
        document.head.appendChild(style);
    </script>

</body>

</html>