<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .cb-main-section {
            width: 100%;
            position: relative;
        }

        .cb-outer {
            background-color: white;
            margin-top: -32px;
            padding: 20px 0;
        }

        .cb-inner {
            max-width: 1200px;
            margin: auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            gap: 60px;
        }

        .cb-left {
            flex: 1;
        }

        .cb-heading {
            font-size: 2.8rem;
            font-weight: 500;
            color: brown;
            margin-bottom: 20px;
            font-family: "Berkshire Swash", serif;
        }

        .cb-description {
            font-size: 15px;
            line-height: 1.7;
            color: brown;
            margin-bottom: 20px;
            text-align: justify;
        }

        .cb-readmore {
            display: inline-block;
            padding: 12px 28px;
            background-color: transparent;
            color: brown;
            font-size: 14px;
            text-decoration: none;
            border-radius: 4px;
            border: 2px solid brown;
        }

        .cb-readmore:hover {
            color: #f5f5f5;
            background-color: brown;
            transition: 0.4s;
        }

        /* RIGHT SLIDER */
        .cb-right {
            flex: 1;
            position: relative;
            height: 400px;
            width: 100%;
            /* Ensures full width always */
            overflow: hidden;
            border-radius: 10px;
        }

        .cb-slider {
            width: 100%;
            height: 100%;
            position: relative;
        }

        .cb-slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 1s ease, transform 1s ease;
            animation: floatUpDown 4s ease-in-out infinite;
        }

        .cb-slide.active {
            opacity: 1;
            transform: translateY(0);
            /* We pause the float animation on the active slide so it doesn't conflict with the fade */
            animation-play-state: running;
        }

        .cb-slide img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            border-radius: 10px;
        }



        /* --- MOBILE FIX --- */
        @media (max-width: 768px) {

            .cb-outer {
                margin-top: 0 !important;
                padding-top: 20px;
            }

            .cb-inner {
                flex-direction: column !important;
                gap: 20px;
            }

            /* Force Slider to be visible at top */
            .cb-right {
                order: -1;
                /* Moves slider above text */
                width: 100%;
                /* Full width */
                height: 300px;
                /* FIXED HEIGHT - This solves the visibility issue */
                flex: none;
                /* Prevents flexbox from collapsing it */
                min-height: 250px;
                /* Safety minimum height */
            }

            .cb-left {
                width: 100%;
            }

            .cb-heading {
                font-size: 24px;
                text-align: center;
            }

            .cb-description {
                text-align: center;
            }

            .cb-readmore {
                display: block;
                width: fit-content;
                margin: 15px auto 0;
            }
        }
    </style>
</head>

<body>

    <section class="cb-main-section">
        <div class="cb-outer">
            <div class="cb-inner">

                <!-- IMAGE SLIDER (Moved to top via CSS Order) -->

                <div class="cb-left">
                    <h2 class="cb-heading">Welcome To OneChef<sup>®</sup> India</h2>

                    <p class="cb-description">
                        <span class="span">OneChef<sup>®</sup> India</span> is a leading food manufacturing company dedicated to producing high-quality, hygienic, and innovative food products. We specialize in creating a wide range of food solutions using advanced manufacturing processes and premium ingredients to meet diverse consumer and market demands.
                    </p>

                    <p class="cb-description">
                        With a strong commitment to quality, safety, and consistency, OneChef India follows strict manufacturing standards and modern production practices. Our customer-focused approach, reliable supply chain, and passion for excellence enable us to deliver nutritious and value-driven food products that enhance everyday living.
                    </p>


                    <a href="./about.php" class="cb-readmore">Discover More OneChef<sup>®</sup></a>
                </div>

                <div class="cb-right">
                    <div class="cb-slider">
                        <div class="cb-slide active">
                            <img src="./assets/images/chef.avif" alt="Gift 1">
                        </div>


                    </div>
                </div>


            </div>
        </div>
    </section>

    <script>
        let slides = document.querySelectorAll('.cb-slide');
        let index = 0;

        setInterval(() => {
            slides[index].classList.remove('active');
            index = (index + 1) % slides.length;
            slides[index].classList.add('active');
        }, 3000);
    </script>

</body>

</html>