  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>OneChef® India | Premium Food Manufacturing Company</title>

  <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

  <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

  <meta name="author" content="OneChef® India">
  <meta name="robots" content="index, follow">
  <meta name="language" content="English">
  <meta name="revisit-after" content="7 days">
  <meta name="rating" content="General">

  <!-- Open Graph for social sharing -->
  <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
  <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
  <meta property="og:type" content="website">
  <meta property="og:locale" content="en_IN">
  <meta property="og:image" content="assets/images/logo.pngfav.jpg">

  <!-- Twitter Card for social sharing -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
  <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
  <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

  <!-- Favicon -->
  <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
  <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
  <link rel="apple-touch-icon" href="./assets/images/logo.png">

  <!-- Accessibility improvements -->
  <meta name="theme-color" content="brown">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Bree+Serif&family=Bungee&family=Calistoga&family=Carter+One&family=Concert+One&family=Dancing+Script:wght@400..700&family=Laila:wght@300;400;500;600;700&family=Lobster&family=Lobster+Two:ital,wght@0,400;0,700;1,400;1,700&family=Merienda:wght@300..900&family=Oleo+Script:wght@400;700&family=Permanent+Marker&family=Rowdies:wght@300;400;700&family=Rozha+One&family=Rubik+Wet+Paint&family=Satisfy&family=Sekuya&family=Tangerine:wght@400;700&family=Young+Serif&display=swap');
  </style>

  <style>
    @import url('https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Bree+Serif&family=Calistoga&family=Carter+One&family=Concert+One&family=Laila:wght@300;400;500;600;700&family=Lobster&family=Merienda:wght@300..900&family=Permanent+Marker&family=Rowdies:wght@300;400;700&family=Rozha+One&family=Rubik+Wet+Paint&family=Satisfy&family=Sekuya&display=swap');
  </style>

  <style>
    * {
      a {
        text-decoration: none;
      }

      font-family: 'Poppins',
      sans-serif;
    }
  </style>



  <header class="chanakya-header-unique">
    <div class="chanakya-container-unique">
      <a href="./index.php">
        <div class="chanakya-logo-container-unique">
          <img src="./assets/images/logo.png" alt="Chanakya Hotels Logo" class="chanakya-logo-unique">
        </div>
      </a>

      <nav class="chanakya-nav-unique">
        <ul class="chanakya-nav-list-unique">

          <li class="chanakya-nav-item-unique">
            <a href="index.php" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
              <i class="fas fa-home"></i> Home
            </a>
          </li>

          <li class="chanakya-nav-item-unique chanakya-dropdown-unique">
            <a href="#" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'about.php' ? 'active' : ''; ?>">
              <i class="fas fa-info-circle"></i> About Us
            </a>
            <ul class="chanakya-dropdown-menu-unique">
              <li><a href="about.php"><i class="fas fa-building"></i> About Company</a></li>
              <li><a href="mission.php"><i class="fas fa-bullseye"></i> Mission | Vision | Values</a></li>
              <li><a href="director.php"><i class="fas fa-user-tie"></i> Director's Desk</a></li>
            </ul>
          </li>

          <li class="chanakya-nav-item-unique">
            <a href="products.php" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'products.php' ? 'active' : ''; ?>">
              <i class="fas fa-box"></i> Products
            </a>
          </li>

          <li class="chanakya-nav-item-unique">
            <a href="foods.php" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'foods.php' ? 'active' : ''; ?>">
              <i class="fas fa-utensils"></i> Foods
            </a>
          </li>

          <!--<li class="chanakya-nav-item-unique">-->
          <!--  <a href="beverage.php" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'beverage.php' ? 'active' : ''; ?>">-->
          <!--    <i class="fas fa-mug-hot"></i> Beverages-->
          <!--  </a>-->
          <!--</li>-->

          <li class="chanakya-nav-item-unique">
            <a href="gallery.php" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'gallery.php' ? 'active' : ''; ?>">
              <i class="fas fa-image"></i> Gallery
            </a>
          </li>

          <!--<li class="chanakya-nav-item-unique">-->
          <!--  <a href="team.php" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'team.php' ? 'active' : ''; ?>">-->
          <!--    <i class="fas fa-users"></i> Team-->
          <!--  </a>-->
          <!--</li>-->

          <li class="chanakya-nav-item-unique">
            <a href="contact.php" class="chanakya-nav-link-unique <?php echo basename($_SERVER['PHP_SELF']) == 'contact.php' ? 'active' : ''; ?>">
              <i class="fas fa-envelope"></i> Contact
            </a>
          </li>

        </ul>
      </nav>

      <div class="chanakya-mobile-toggle-unique">
        <span class="chanakya-bar-unique"></span>
        <span class="chanakya-bar-unique"></span>
        <span class="chanakya-bar-unique"></span>
      </div>
    </div>
  </header>

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    html {
      scroll-behavior: smooth;
    }

    body {
      margin: 0;
      padding: 0;
      overflow-x:hidden;
    }

    .span {
      color: brown;
      font-weight: 600;
    }

    .chanakya-header-unique {
      background-image: url('./assets/images/footer-bg.png');
      background-position: center;
      background-size: cover;
      background-repeat: no-repeat;
      width: 100%;
      position: relative;
      z-index: 1000;
      padding: 0;
      margin: 0;
      transition: all 0.3s ease;
    }

    .chanakya-header-unique.sticky {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .chanakya-container-unique {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 2px 0;
      width: 100%;
      max-width: 100%;
      margin: 0;
    }

    .chanakya-logo-container-unique {
      display: flex;
      align-items: center;
      padding-left: 30px;
    }

    .chanakya-logo-unique {
      height: 100px;
      margin-left: 55px;
    }

    .chanakya-logo-text-unique {
      font-family: 'Georgia', serif;
      font-size: 18px;
      font-weight: bold;
      color: brown;
      letter-spacing: 1px;
      white-space: nowrap;
    }

    .chanakya-nav-unique {
      flex-grow: 1;
      display: flex;
      justify-content: center;
    }

    .chanakya-nav-list-unique {
      display: flex;
      list-style: none;
      padding: 0;
    }

    .chanakya-nav-item-unique {
      margin: 0 10px;
      position: relative;
    }

    .chanakya-nav-link-unique {
      font-family: "Concert One", sans-serif;
      font-size: 18px;
      font-weight: 400;
      color: brown;
      text-decoration: none;
      text-transform: uppercase;
      letter-spacing: 1px;
      transition: color 0.3s ease;
      display: flex;
      align-items: center;
    }

    .chanakya-nav-link-unique i {
      margin-right: 8px;
    }

    .chanakya-nav-link-unique i.fa-chevron-down {
      margin-left: 5px;
      font-size: 12px;
    }

    .chanakya-nav-link-unique:hover,
    .chanakya-nav-link-unique.active {
      color: black;
    }

    /* Dropdown styles */
    .chanakya-dropdown-unique {
      position: relative;
    }

    .chanakya-dropdown-menu-unique {
      position: absolute;
      top: 200%;
      left: 0;
      background-image: url('./assets/images/footer-bg.png');
      background-position: center;
      background-size: cover;
      background-repeat: no-repeat;
      min-width: 300px;
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
      z-index: 1001;
      opacity: 0;
      visibility: hidden;
      transform: translateY(10px);
      transition: all 0.3s ease;
      border-radius: 4px;
      padding: 10px 0;
    }

    .chanakya-dropdown-unique.active .chanakya-dropdown-menu-unique {
      opacity: 1;
      visibility: visible;
      transform: translateY(0);
    }

    .chanakya-dropdown-menu-unique li {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    .chanakya-dropdown-menu-unique li a {
      display: flex;
      align-items: center;
      padding: 10px 20px;
      color: black;
      text-decoration: none;
      font-family: "Concert One", sans-serif;
      font-size: 18px;
      transition: all 0.3s ease;
      text-transform: uppercase;
    }

    .chanakya-dropdown-menu-unique li a i {
      margin-right: 10px;
      width: 20px;
      text-align: center;
    }

    .chanakya-dropdown-menu-unique li a:hover {
      background-color: rgba(201, 169, 97, 0.2);
      color: black;
    }

    .chanakya-book-now-unique {
      margin-right: 30px;
    }

    .chanakya-book-btn-unique {
      font-family: 'Arial', sans-serif;
      font-size: 14px;
      font-weight: 600;
      color: #fff;
      background-color: black;
      padding: 10px 20px;
      border-radius: 4px;
      text-decoration: none;
      text-transform: uppercase;
      letter-spacing: 1px;
      transition: background-color 0.3s ease;
      display: inline-block;
    }

    .chanakya-book-btn-unique:hover {
      background-color: #b89455;
    }

    .chanakya-mobile-toggle-unique {
      display: none;
      flex-direction: column;
      cursor: pointer;
      margin-right: 20px;
    }

    .chanakya-bar-unique {
      width: 25px;
      height: 3px;
      background-color: brown;
      margin: 3px 0;
      transition: 0.3s;
    }
    
    @media (min-width: 1000px){
        .chanakya-nav-unique{
            position:relative;
            left: 160px;
        }
    }

    @media (max-width: 992px) {
      .chanakya-logo-container-unique {
        padding-left: 20px;
      }

      .chanakya-book-now-unique {
        margin-right: 20px;
      }

      .chanakya-logo-text-unique {
        font-size: 16px;
      }

      .chanakya-nav-item-unique {
        margin: 0 10px;
      }

      .chanakya-nav-link-unique {
        font-size: 13px;
      }
    }

    @media (max-width: 768px) {
      .chanakya-logo-container-unique {
        padding-left: 15px;
      }

      .chanakya-logo-unique {
        height: 80px;
        position: relative;
        right: 50px;
      }

      .chanakya-logo-text-unique {
        font-size: 14px;
      }

      .chanakya-nav-unique {
        position: absolute;
        top: 100%;
        left: 0;
        width: 100%;
        background-image: url('./assets/images/footer-bg.png');
        background-position: center;
        background-size: cover;
        background-repeat: no-repeat;
        display: none;
        z-index: 1000;
      }

      .chanakya-nav-list-unique {
        flex-direction: column;
        padding: 10px 0;
      }

      .chanakya-nav-item-unique {
        margin: 0;
        padding: 10px 40px;
      }

      .chanakya-nav-link-unique {
        display: block;
        color: brown;
      }

      .chanakya-book-now-unique {
        display: none;
      }

      .chanakya-mobile-toggle-unique {
        display: flex;
      }

      /* Mobile dropdown styles */
      .chanakya-dropdown-menu-unique {
        position: static;
        opacity: 1;
        visibility: visible;
        transform: none;
        display: none;
        box-shadow: none;
        background-color: rgba(0, 0, 0, 0.7);
        min-width: 100%;
        padding-left: 20px;
      }

      .chanakya-dropdown-unique.active .chanakya-dropdown-menu-unique {
        display: block;
      }

      .chanakya-nav-unique.active {
        display: block;
      }
    }

    @media (max-width: 480px) {
      .chanakya-logo-text-unique {
        display: none;
      }

      .chanakya-header-unique {
        background-color: black;
      }

      .chanakya-dropdown-menu-unique li a {
        font-size: 14px;
      }

    }
  </style>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Use more specific selectors to avoid conflicts
      const mobileToggle = document.querySelector('.chanakya-mobile-toggle-unique');
      const navMenu = document.querySelector('.chanakya-nav-unique');
      const header = document.querySelector('.chanakya-header-unique');
      const dropdownItems = document.querySelectorAll('.chanakya-dropdown-unique');
      let lastScrollTop = 0;

      // Mobile menu toggle
      if (mobileToggle && navMenu) {
        mobileToggle.addEventListener('click', function() {
          navMenu.classList.toggle('active');
        });

        // Close mobile menu when clicking on nav links (except dropdown toggles)
        const navLinks = document.querySelectorAll('.chanakya-nav-link-unique');
        navLinks.forEach(link => {
          link.addEventListener('click', function(e) {
            // Don't close menu if clicking on a dropdown parent
            if (!link.parentElement.classList.contains('chanakya-dropdown-unique')) {
              navMenu.classList.remove('active');
            }
          });
        });
      }

      // Dropdown toggle for both desktop and mobile
      dropdownItems.forEach(dropdown => {
        const dropdownLink = dropdown.querySelector('.chanakya-nav-link-unique');
        const dropdownMenu = dropdown.querySelector('.chanakya-dropdown-menu-unique');

        // Create a separate toggle button for mobile
        const isMobile = window.innerWidth <= 768;

        dropdownLink.addEventListener('click', function(e) {
          // Prevent default only if it's the dropdown parent
          if (dropdown.classList.contains('chanakya-dropdown-unique')) {
            e.preventDefault();

            // Close other dropdowns
            dropdownItems.forEach(otherDropdown => {
              if (otherDropdown !== dropdown) {
                otherDropdown.classList.remove('active');
              }
            });

            // Toggle current dropdown
            dropdown.classList.toggle('active');

            // For mobile, prevent the menu from closing when dropdown is clicked
            if (isMobile) {
              e.stopPropagation();
            }
          }
        });

        // For mobile dropdown items, close the menu when clicked
        if (dropdownMenu) {
          const dropdownLinks = dropdownMenu.querySelectorAll('a');
          dropdownLinks.forEach(link => {
            link.addEventListener('click', function() {
              if (navMenu) {
                navMenu.classList.remove('active');
              }
            });
          });
        }
      });

      // Close dropdowns when clicking outside
      document.addEventListener('click', function(e) {
        if (!e.target.closest('.chanakya-dropdown-unique')) {
          dropdownItems.forEach(dropdown => {
            dropdown.classList.remove('active');
          });
        }
      });

      // Sticky header on scroll
      window.addEventListener('scroll', function() {
        let scrollTop = window.pageYOffset || document.documentElement.scrollTop;

        // Make header sticky when scrolling down
        if (scrollTop > 50) {
          header.classList.add('sticky');
        } else {
          header.classList.remove('sticky');
        }

        lastScrollTop = scrollTop;
      });
    });
  </script>

  <!-- Add Font Awesome for icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">