<?php include 'header.php'; ?>
<?php include 'admin/connection.php'; ?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 250px;
            background: url('./assets/images/gallery-bn.webp') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: white;
            font-weight: 500;
            font-size: 3rem;
            margin: 0;
            position: relative;
            left: 80px;
            font-family: "Berkshire Swash", serif;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300px;
            }

            .custom-banner-box h1 {
                font-size: 2rem;
                left: 10px;
            }
        }

        a {
            text-decoration: none;
        }

        .partner-showcase-section {
            width: 100%;
            padding: 40px 20px;
            background: rgba(255, 255, 255, 0.95);
        }

        .partner-showcase-container {
            max-width: 1200px;
            margin: auto;
            text-align: center;
        }

        .partner-showcase-title {
            font-size: 3rem;
            letter-spacing: 2px;
            color: brown;
            margin-bottom: 10px;
            font-family: "Berkshire Swash", serif;
            font-weight: 500;
        }

        .partner-showcase-line {
            display: inline-block;
            width: 40px;
            height: 2px;
            background: brown;
            margin-bottom: 15px;
        }

        .partner-showcase-subtitle {
            font-size: 14px;
            color: brown;
            margin-bottom: 20px;
        }

        .filter-buttons {
            margin-bottom: 30px;
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
        }

        .filter-btn {
            padding: 10px 25px;
            background: transparent;
            border: 2px solid brown;
            color: brown;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            border-top-left-radius: 10px;
            border-bottom-right-radius: 10px;
            transition: all 0.3s ease;
            text-transform: uppercase;
        }

        .filter-btn:hover,
        .filter-btn.active {
            background: brown;
            color: #fff;
        }

        .partner-showcase-logos {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 25px;
            justify-items: center;
        }

        .gallery-item {
            position: relative;
            overflow: hidden;
            border-radius: 8px;
            cursor: pointer;
            transition: transform 0.3s ease;
        }

        .gallery-item:hover {
            transform: scale(1.05);
        }

        .gallery-item img {
            width: 100%;
            height: 300px;
            object-fit: cover;
            display: block;
        }

        /* Modal */
        .partner-image-modal {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.85);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .partner-image-modal img {
            max-width: 90%;
            max-height: 90%;
            background: #fff;
            padding: 10px;
            border-radius: 8px;
        }

        .partner-modal-close {
            position: absolute;
            top: 30px;
            right: 40px;
            font-size: 40px;
            color: #fff;
            cursor: pointer;
            transition: color 0.3s;
        }

        .partner-modal-close:hover {
            color: brown;
        }

        /* Navigation arrows */
        .modal-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            font-size: 50px;
            color: white;
            cursor: pointer;
            padding: 20px;
            user-select: none;
            transition: color 0.3s;
        }

        .modal-nav:hover {
            color: brown;
        }

        .modal-prev {
            left: 20px;
        }

        .modal-next {
            right: 20px;
        }

        @media (max-width: 992px) {
            .partner-showcase-logos {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        @media (max-width: 768px) {
            .partner-showcase-logos {
                grid-template-columns: repeat(2, 1fr);
                gap: 15px;
            }

            .gallery-item img {
                height: 150px;
            }
        }

        @media (max-width: 576px) {
            .partner-showcase-logos {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>OneChef® Gallery</h1>
        </div>
    </section>

    <section class="partner-showcase-section">
        <div class="partner-showcase-container">
            <h2 class="partner-showcase-title">Image Gallery</h2>
            <p class="partner-showcase-subtitle">
                Explore a visual collection showcasing our work, events, and collaborations captured with clarity, purpose, and style.
            </p>

            <!-- Filter Buttons -->
            <div class="filter-buttons">
                <button class="filter-btn active" onclick="filterGallery('all')">All</button>
                <?php
                $cats = $conn->query("SELECT * FROM gallery_categories WHERE status=1 ORDER BY name ASC");
                while ($cat = $cats->fetch_assoc()) {
                    echo '<button class="filter-btn" onclick="filterGallery(\'' . $cat['slug'] . '\')">' . htmlspecialchars($cat['name']) . '</button>';
                }
                ?>
            </div>

            <!-- Gallery Grid -->
            <div class="partner-showcase-logos">
                <?php
                $images = $conn->query("SELECT gi.image, gc.slug as category_slug, gc.name as category_name 
                                        FROM gallery_images gi 
                                        JOIN gallery_categories gc ON gi.category_id = gc.id 
                                        WHERE gi.status=1 AND gc.status=1 
                                        ORDER BY gi.id DESC");

                while ($img = $images->fetch_assoc()) {
                    echo '
                    <div class="gallery-item" data-category="' . $img['category_slug'] . '">
                        <img src="./' . $img['image'] . '" alt="' . htmlspecialchars($img['category_name']) . '" onclick="openImage(this, \'' . $img['image'] . '\')">
                    </div>';
                }
                ?>
            </div>
        </div>
    </section>

    <!-- Modal -->
    <div class="partner-image-modal" id="partnerImageModal">
        <span class="partner-modal-close" onclick="closeModal()">&times;</span>
        <span class="modal-nav modal-prev" onclick="navigateImage(-1)">&#10094;</span>
        <img id="partnerModalImg" src="">
        <span class="modal-nav modal-next" onclick="navigateImage(1)">&#10095;</span>
    </div>

    <script>
        let currentIndex = 0;
        let visibleImages = [];

        function filterGallery(category) {
            const images = document.querySelectorAll('.gallery-item');
            const buttons = document.querySelectorAll('.filter-btn');

            // Update active button
            buttons.forEach(btn => btn.classList.remove('active'));
            event.target.classList.add('active');

            // Filter images
            images.forEach(img => {
                if (category === 'all' || img.getAttribute('data-category') === category) {
                    img.style.display = 'block';
                } else {
                    img.style.display = 'none';
                }
            });

            // Update visible images array
            updateVisibleImages();
        }

        function updateVisibleImages() {
            visibleImages = [];
            document.querySelectorAll('.gallery-item').forEach(item => {
                if (item.style.display !== 'none') {
                    visibleImages.push(item.querySelector('img'));
                }
            });
        }

        function openImage(img, src) {
            updateVisibleImages();
            currentIndex = visibleImages.indexOf(img);
            document.getElementById('partnerModalImg').src = './' + src;
            document.getElementById('partnerImageModal').style.display = 'flex';
        }

        function closeModal() {
            document.getElementById('partnerImageModal').style.display = 'none';
        }

        function navigateImage(direction) {
            currentIndex += direction;
            if (currentIndex >= visibleImages.length) currentIndex = 0;
            if (currentIndex < 0) currentIndex = visibleImages.length - 1;

            const img = visibleImages[currentIndex];
            const src = img.getAttribute('onclick').match(/'([^']+)'/)[1];
            document.getElementById('partnerModalImg').src = './' + src;
        }

        // Close modal on outside click
        document.getElementById('partnerImageModal').addEventListener('click', function(e) {
            if (e.target === this) closeModal();
        });

        // Keyboard navigation
        document.addEventListener('keydown', function(e) {
            const modal = document.getElementById('partnerImageModal');
            if (modal.style.display === 'flex') {
                if (e.key === 'Escape') closeModal();
                if (e.key === 'ArrowLeft') navigateImage(-1);
                if (e.key === 'ArrowRight') navigateImage(1);
            }
        });

        // Initialize
        updateVisibleImages();
    </script>

    <?php include 'footer.php'; ?>
</body>

</html>