      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <title>OneChef® India | Premium Food Manufacturing Company</title>

      <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

      <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

      <meta name="author" content="OneChef® India">
      <meta name="robots" content="index, follow">
      <meta name="language" content="English">
      <meta name="revisit-after" content="7 days">
      <meta name="rating" content="General">

      <!-- Open Graph for social sharing -->
      <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
      <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
      <meta property="og:type" content="website">
      <meta property="og:locale" content="en_IN">
      <meta property="og:image" content="assets/images/logo.pngfav.jpg">

      <!-- Twitter Card for social sharing -->
      <meta name="twitter:card" content="summary_large_image">
      <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
      <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
      <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

      <!-- Favicon -->
      <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
      <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
      <link rel="apple-touch-icon" href="./assets/images/logo.png">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">

      <link rel="preconnect" href="https://fonts.googleapis.com">
      <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

      <!-- Font Awesome -->
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

      <style>
          * {
              padding: 0;
              margin: 0;
          }

          a {
              text-decoration: none;
          }

          .nova-footer-wrapper {
              color: brown;
          }

          .nova-footer-main {
              background-image: url('./assets/images/footer-bg.png');
              background-position: center;
              background-size: cover;
              background-repeat: no-repeat;
              padding: 60px;
          }

          .nova-footer-grid {
              display: grid;
              grid-template-columns: repeat(auto-fit, minmax(250px, auto));
              gap: 40px;
              max-width: 1400px;
              margin: 0 auto;
          }

          .nova-footer-column h3 {
              font-size: 30px;
              font-weight: 400;
              margin-bottom: 20px;
              color: brown;
              position: relative;
              padding-bottom: 10px;
              font-family: "Concert One", sans-serif;
          }

          .nova-footer-column h3::after {
              content: '';
              position: absolute;
              left: 0;
              bottom: 0;
              width: 50px;
              height: 2px;
              background-color: brown;
          }

          .nova-footer-column p {
              font-size: 14px;
              line-height: 1.7;
              color: brown;
          }

          .nova-footer-logo {
              margin-bottom: 15px;
          }

          .nova-footer-logo p {
              text-align: justify;
              padding: 5px;
          }

          .nova-footer-logo img {
              max-height: auto;
              width: 250px;
              display: block;
              padding: 5px;
          }

          /* Links Section */
          .nova-footer-links ul {
              list-style: none;
              padding: 0;
              margin: 0;
          }

          .nova-footer-links ul li {
              margin-bottom: 12px;
          }

          .nova-footer-links ul li a {
              text-decoration: none;
              color: brown;
              font-size: 20px;
              display: flex;
              align-items: center;
              transition: color 0.3s ease, transform 0.3s ease;
              font-weight: 500;
              font-family: "Concert One", sans-serif;
          }

          .nova-footer-links ul li a i {
              color: brown;
              margin-right: 10px;
              font-size: 15px;
          }

          .nova-footer-links ul li a:hover {
              color: brown;
              transform: translateX(5px);
          }

          .nova-footer-links ul li a:hover i {
              color: brown;
              transform: translateX(5px);
          }

          .nova-footer-contact-item {
              display: flex;
              align-items: flex-start;
              margin-bottom: 15px;
              font-size: 20px;
              color: brown;
              font-weight: 500;
              font-family: "Concert One", sans-serif;
          }

          .nova-footer-contact-item i {
              color: brown;
              margin-right: 12px;
              margin-top: 3px;
          }

          /* Visitor Counter */
          .visitor-counter {
              display: flex;
              gap: 5px;
              margin-top: 10px;
              font-size: 12px;
              font-weight: 700;
              color: white;
              font-family: "Concert One", sans-serif;
              margin-left: 35px;
          }

          .visitor-counter span {
              display: inline-block;
              width: 20px;
              text-align: center;
              background-color: brown;
              padding: 5px 0;
              border-radius: 3px;
          }

          .nova-footer-social {
              margin-top: 25px;
          }

          .nova-footer-social a {
              display: inline-flex;
              align-items: center;
              justify-content: center;
              width: 36px;
              height: 36px;
              background-color: rgba(255, 255, 255, 0.1);
              color: brown;
              border-radius: 50%;
              margin-right: 10px;
              font-size: 16px;
              transition: background-color 0.3s ease, color 0.3s ease, transform 0.3s ease;
          }

          .nova-footer-social a:hover {
              background-color: #ffcc00;
              color: #203a70;
              transform: translateY(-3px);
          }

          .nova-footer-bottom {
              background-color: brown;
              text-align: center;
              padding: 10px;
              font-size: 13px;
              border-top: 1px solid rgba(255, 255, 255, 0.1);
          }

          .nova-footer-bottom p {
              margin: 0;
              display: flex;
              align-items: center;
              justify-content: center;
              flex-wrap: wrap;
              gap: 5px;
          }

          .nova-footer-bottom a {
              color: brown;
              text-decoration: none;
              font-weight: 400;
          }

          .nova-footer-bottom a:hover {
              text-decoration: underline;
          }

          .designer-logo-link {
              display: inline-block;
              vertical-align: middle;
          }

          .designer-logo-link img {
              height: 30px;
              width: auto;
              vertical-align: middle;
              transition: filter 0.3s ease;
          }

          .designer-logo-link:hover img {
              filter: none;
          }

          /* --- Navigation Buttons --- */
          .nova-footer-nav-buttons {
              display: flex;
              gap: 10px;
              margin-top: 20px;
          }

          .nova-footer-nav-button {
              background-color: #ffcc00;
              color: #203a70;
              border: none;
              padding: 8px 16px;
              border-radius: 5px;
              font-weight: 400;
              cursor: pointer;
              transition: background-color 0.3s ease, color 0.3s ease;
              font-size: 14px;
          }

          .nova-footer-nav-button:hover {
              background-color: #203a70;
              color: #ffcc00;
          }

          /* --- Responsive Design --- */
          @media (max-width: 768px) {

              /* Hide Visitor Counter in Mobile View */
              .visitor-counter {
                  display: none;
              }

              .nova-footer-main {
                  padding: 30px 15px;
                  /* Reduced padding for mobile */
              }

              .nova-footer-grid {
                  grid-template-columns: 1fr;
                  gap: 30px;
              }

              .nova-footer-column h3::after {
                  left: 0;
                  transform: none;
              }

              /* Logo Left Align */
              .nova-footer-logo img {
                  max-height: auto;
                  width: 250px;
                  /* Adjusted width for mobile */
                  margin-left: 0;
                  /* Ensures left alignment */
                  margin-right: auto;
                  /* Ensures left alignment */
              }

              /* All Text Left Align */
              .nova-footer-column,
              .nova-footer-links ul,
              .nova-footer-links ul li,
              .nova-footer-contact-item {
                  text-align: left;
              }

              .nova-footer-links ul li a,
              .nova-footer-contact-item {
                  justify-content: flex-start;
              }

              .nova-footer-nav-buttons {
                  flex-direction: column;
              }

              /* Adjust footer bottom for mobile */
              .nova-footer-bottom {
                  padding: 15px 10px;
              }
          }
      </style>
      <?php include 'icons.php' ?>
      <div class="nova-footer-wrapper">
          <footer class="nova-footer-main">
              <div class="nova-footer-grid">
                  <!-- Column 1: About -->
                  <div class="nova-footer-column">
                      <div class="nova-footer-logo">
                          <a href="./index.php"><img src="./assets/images/logo.png" alt="Company Logo"></a>
                      </div>

                      <!-- Visitor Counter -->
                      <div class="visitor-counter">
                          <?php
                            $counter_file = 'counter.txt';
                            if (!file_exists($counter_file)) {
                                file_put_contents($counter_file, '0');
                            }

                            $counter = (int)file_get_contents($counter_file);

                            // Increment only if on index page
                            if (basename($_SERVER['PHP_SELF']) == 'index.php') {
                                $counter++;
                                file_put_contents($counter_file, $counter);
                            }

                            $counter_str = str_pad($counter, 7, '0', STR_PAD_LEFT);

                            // Display each digit in separate span
                            for ($i = 0; $i < 7; $i++) {
                                echo "<span>" . $counter_str[$i] . "</span>";
                            }
                            ?>
                      </div>
                  </div>

                  <!-- Column 2: Quick Links -->
                  <div class="nova-footer-column nova-footer-links">
                      <h3>Quick Links</h3>
                      <ul>
                          <li><a href="./index.php"><i class="fas fa-angle-right"></i> Home</a></li>
                          <li><a href="./about.php"><i class="fas fa-angle-right"></i> About Us</a></li>
                          <li><a href="./mission.php"><i class="fas fa-angle-right"></i> Mission | Vision | Core Values</a></li>
                          <li><a href="./director.php"><i class="fas fa-angle-right"></i> Director Desk</a></li>
                      </ul>
                  </div>

                  <!-- Column 3: Important Links -->
                  <div class="nova-footer-column nova-footer-links">
                      <h3>Important Links</h3>
                      <ul>
                          <li><a href="#."><i class="fas fa-angle-right"></i>Gallery</a></li>
                          <li><a href="./products.php"><i class="fas fa-angle-right"></i>Products</a></li>
                          <li><a href="./foods.php"><i class="fas fa-angle-right"></i> Foods</a></li>
                          <!--<li><a href="./beverage.php"><i class="fas fa-angle-right"></i> Beverages</a></li>-->
                          <!--<li><a href="./team.php"><i class="fas fa-angle-right"></i> Team</a></li>-->
                          <li><a href="./contact.php"><i class="fas fa-angle-right"></i>Contact</a></li>
                      </ul>
                  </div>

                  <!-- Column 4: Contact Info + Visitor Counter -->
                  <div class="nova-footer-column">
                      <h3>Contact Info</h3>
                      <div class="nova-footer-contact-item">
                          <i class="fas fa-map-marker-alt"></i>
                          <span style="color:brown; font-family: Concert One, sans-serif;">Brahmsthani, Patna Sadar, Sheikhpura, Patna(Bihar)-India.</span>
                      </div>
                      <div class="nova-footer-contact-item">
                          <i class="fas fa-phone"></i>
                          <span><a href="tel:+91-9334482474" style="color:brown; font-family: Concert One, sans-serif;">+91-9334482474</a></span>
                      </div>
                      <div class="nova-footer-contact-item">
                          <i class="fas fa-envelope"></i>
                          <span><a href="mailto:nestle@wellexypharma.com" style="color:brown; font-family: Concert One, sans-serif;">maakamaindiaprivateltd@gmail.com</a></span>
                      </div>




                  </div>
              </div>
          </footer>

          <div class="nova-footer-bottom">
              <p style="color: white; font-weight:400; font-size: 15px; font-family: Concert One, sans-serif;">
                  &copy; 2026 <a href="#" style="text-decoration: none; color:white; font-weight:400; font-size: 15px; font-family: Concert One, sans-serif;">OneChef® India</a>. All Rights Reserved. | Designed by
                  <a href="https://erainfotech.in/" target="_blank" class="designer-logo-link" aria-label="Designer's Portfolio">
                      <img src="./assets/images/logo-era.png" alt="Designer Logo" style="background-color: white; padding:5px; border-radius: 15px;">
                  </a>
              </p>
          </div>
      </div>