<?php include 'header.php'; ?>
<?php include 'admin/connection.php'; ?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">
    <style>
        /* Keep all existing CSS from your static code */
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 250px;
            background: url('./assets/images/food-bn.webp') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 500;
            font-size: 3rem;
            margin: 0;
            position: relative;
            left: 80px;
            font-family: "Berkshire Swash", serif;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 2rem;
                margin: 0;
                position: relative;
                left: 10px;
            }
        }

        a {
            text-decoration: none;
        }

        /* Grid Styles from your code */
        .rr-services-sections {
            width: 100%;
            padding: 20px 20px;
            background-image: url('./assets/images/main-bg.png');
            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;
        }

        .rr-services-container {
            max-width: 1300px;
            margin: auto;
        }

        .rr-services-headings {
            text-align: center;
            color: brown;
            font-size: 3rem;
            font-family: "Berkshire Swash", serif;
            margin-bottom: 10px;
            font-weight: 500;
        }

        .rr-services-subtexts {
            text-align: center;
            color: brown;
            max-width: 800px;
            margin: 0 auto 50px;
            font-size: 14px;
        }

        .rr-services-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 25px;
        }

        .rr-recipe-card {
            background: brown;
            overflow: hidden;
            transition: transform 0.4s ease;
            display: flex;
            flex-direction: column;
            height: 100%;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 20px;
        }

        .rr-recipe-card:hover {
            transform: translateY(-5px);
        }

        .rr-card-image {
            height: auto;
            overflow: hidden;
        }

        .rr-card-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .rr-card-body {
            padding: 20px;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .rr-card-tag {
            font-size: 12px;
            color: white;
            letter-spacing: 1px;
            display: flex;
            align-items: center;
        }

        .rr-diet-indicator {
            width: 16px;
            height: 16px;
            border-radius: 3px;
            margin-right: 8px;
            position: relative;
            display: inline-block;
        }

        .rr-diet-indicator::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 8px;
            height: 8px;
            border-radius: 50%;
        }

        .rr-diet-indicator.veg {
            background-color: white;
        }

        .rr-diet-indicator.veg::after {
            background-color: #4CAF50;
        }

        .rr-diet-indicator.non-veg {
            background-color: white;
        }

        .rr-diet-indicator.non-veg::after {
            background-color: #F44336;
        }

        .rr-card-body h3 {
            font-size: 15px;
            margin: 8px 0;
            color: white;
            font-weight: 500;
        }

        .rr-card-body p {
            font-size: 13px;
            color: white;
            margin-bottom: 15px;
            flex-grow: 1;
            text-align: justify;
        }

        .rr-card-btn {
            display: inline-block;
            padding: 8px 18px;
            border: 1px solid white;
            color: white;
            border-radius: 6px;
            text-decoration: none;
            font-size: 13px;
            transition: 0.3s;
            margin-top: auto;
            width: 140px;
            text-align: center;
        }

        .rr-card-btn:hover {
            background: #fff;
            color: brown;
        }

        @media(max-width:1200px) {
            .rr-services-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        @media(max-width:992px) {
            .rr-services-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media(max-width:576px) {
            .rr-services-headings {
                font-size: 26px;
            }

            .rr-services-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Foods Recipes</h1>
        </div>
    </section>

    <section class="rr-services-sections">
        <div class="rr-services-container">
            <h2 class="rr-services-headings">Delicious Food Recipes</h2>
            <p class="rr-services-subtexts">
                OneChef® India brings you a range of delicious and high-quality food recipes crafted using premium ingredients and advanced manufacturing processes, ensuring great taste, nutrition, and consistent quality in every product.
            </p>

            <div class="rr-services-grid" id="rrGrid">
                <?php
                $sql = "SELECT * FROM recipes WHERE status = 1 ORDER BY id DESC";
                $res = $conn->query($sql);
                if ($res->num_rows > 0) {
                    while ($row = $res->fetch_assoc()) {
                        $image = !empty($row['image']) ? $row['image'] : 'assets/images/r2.png'; // Default fallback
                        echo '
                        <div class="rr-recipe-card">
                            <div class="rr-card-image">
                                <img src="./' . $image . '" alt="' . htmlspecialchars($row['title']) . '">
                            </div>
                            <div class="rr-card-body">
                                <span class="rr-card-tag">FOOD</span>
                                <h3>
                                    <span class="rr-diet-indicator ' . $row['diet_type'] . '"></span>
                                    ' . htmlspecialchars($row['title']) . ' 
                                </h3>
                                <a href="./food-recipe.php?id=' . $row['id'] . '" class="rr-card-btn">Try This Recipe</a>
                            </div>
                        </div>';
                    }
                } else {
                    echo '<p style="text-align:center; width:100%; color:brown;">No recipes found.</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <?php include 'footer.php'; ?>
</body>

</html>