<?php
include 'header.php';
include 'admin/connection.php';

// Default values
$recipe = [
    'title' => 'Recipe Not Found',
    'image' => 'assets/images/r2.png',
    'short_description' => '',
    'cuisine' => 'N/A',
    'meal_course' => 'N/A',
    'serves' => 'N/A',
    'delivery' => 'N/A',
    'ingredients' => '',
    'preparation' => ''
];

if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $res = $conn->query("SELECT * FROM recipes WHERE id=$id");
    if ($res->num_rows > 0) {
        $recipe = $res->fetch_assoc();
    }
}

// ---------------------------------------------------
// DYNAMIC PROCESSING LOGIC (PERFECT STEP ALIGNMENT)
// ---------------------------------------------------

// 1. Process Ingredients into Bullet Points
$ingredients_html = '';
$ingredients_raw = trim($recipe['ingredients']);

if (!empty($ingredients_raw)) {
    $clean_text = strip_tags($ingredients_raw);
    $items = preg_split('/\r\n|\r|\n|,/', $clean_text);

    $ingredients_html .= '<ul class="nest-custom-list">';
    foreach ($items as $item) {
        $item = trim($item);
        if (!empty($item)) {
            $ingredients_html .= '<li>' . htmlspecialchars($item) . '</li>';
        }
    }
    $ingredients_html .= '</ul>';
}

// 2. Process Preparation Steps - SMART ALIGNMENT DETECTION
$preparation_html = '';
$preparation_raw = trim($recipe['preparation']);

if (!empty($preparation_raw)) {
    $clean_text = strip_tags($preparation_raw);
    $lines = preg_split('/\r\n|\r|\n/', $clean_text);

    foreach ($lines as $line) {
        $line = trim($line);
        if (!empty($line)) {
            // Detect existing "Step X:" pattern (handles variations)
            if (preg_match('/^(step\s+(\d+)[.:]?\s*)/i', $line, $matches)) {
                $step_prefix = $matches[0];
                $step_content = trim(substr($line, strlen($step_prefix)));

                $preparation_html .= '<div class="nest-step">';
                $preparation_html .= '<strong>' . htmlspecialchars($step_prefix) . '</strong>';
                $preparation_html .= '<span class="step-content">' . htmlspecialchars($step_content) . '</span>';
                $preparation_html .= '</div>';
            } else {
                // Fallback: auto-number consecutive steps
                static $step_count = 1;
                $preparation_html .= '<div class="nest-step">';
                $preparation_html .= '<strong>Step ' . $step_count . ':</strong> ';
                $preparation_html .= '<span class="step-content">' . htmlspecialchars($line) . '</span>';
                $preparation_html .= '</div>';
                $step_count++;
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/recepie-bn.webp') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 500;
            font-size: 3rem;
            margin: 0;
            position: relative;
            left: 80px;
            font-family: "Berkshire Swash", serif;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300px;
            }

            .custom-banner-box h1 {
                font-size: 2rem;
                left: 10px;
            }
        }

        a {
            text-decoration: none;
        }

        .nest-content-divider {
            width: 1px;
            background: #e5e5e5;
        }

        .nest-ingredients-box,
        .nest-preparation-box {
            background: #ffffff;
            padding: 25px;
            flex: 1;
        }

        .nest-recipe-section {
            padding: 40px 20px;
        }

        .nest-banner-row {
            display: flex;
            background: #b3002d;
        }

        .nest-banner-image {
            width: 50%;
        }

        .nest-banner-image img {
            width: 100%;
            height: 300px;
            object-fit: contain;
            display: block;
        }

        .nest-banner-content {
            width: 50%;
            background: #b3002d;
            color: #ffffff;
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .nest-banner-content h2 {
            margin: 0 0 15px;
            font-size: 28px;
            font-family: "Berkshire Swash", serif;
            font-weight: 500;
        }

        .nest-banner-content p {
            margin: 0;
            line-height: 1.6;
            font-size: 14px;
        }

        .nest-info-strip {
            margin-top: 20px;
            background: #ffffff;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 20px;
            border: 1px solid #eee;
        }

        .nest-info-item {
            text-align: center;
            flex: 1;
        }

        .nest-info-item img {
            width: 50px;
            margin-bottom: 6px;
        }

        .nest-info-title {
            display: block;
            font-size: 13px;
            color: black;
        }

        .nest-info-value {
            font-weight: 500;
            margin-top: 4px;
        }

        .nest-info-divider {
            width: 1px;
            height: 50px;
            background: #e0e0e0;
        }

        .nest-main-content {
            margin-top: 25px;
            display: flex;
            gap: 20px;
            border: 1px solid #eee;
        }

        .nest-heading-with-icon {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }

        .nest-heading-with-icon img {
            width: 100px;
        }

        .nest-ingredients-box h3,
        .nest-preparation-box h3 {
            margin: 0;
            font-size: 20px;
            color: #b3002d;
            font-weight: 600;
        }

        /* Custom Bullet Points for Ingredients */
        .nest-custom-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .nest-custom-list li {
            position: relative;
            padding-left: 25px;
            margin-bottom: 12px;
            font-size: 14px;
            color: black;
            line-height: 1.5;
        }

        .nest-custom-list li::before {
            content: '•';
            color: #b3002d;
            font-weight: bold;
            font-size: 20px;
            position: absolute;
            left: 0;
            top: -2px;
        }

        /* PERFECTLY ALIGNED STEPS */
        .nest-step {
            margin-bottom: 18px;
            font-size: 14px;
            line-height: 1.7;
            color: black;
            padding-bottom: 10px;
            border-bottom: 1px dashed #eee;
            display: flex;
            align-items: flex-start;
            min-height: 24px;
        }

        .nest-step:last-child {
            border-bottom: none;
        }

        .nest-step strong {
            color: #b3002d;
            font-weight: 600;
            min-width: 80px;
            display: inline-block;
            margin-right: 12px;
            font-size: 14px;
            line-height: 1.4;
            padding-top: 2px;
        }

        .nest-step .step-content {
            flex: 1;
            line-height: 1.7;
            color: black;
        }

        @media (max-width:992px) {
            .nest-banner-row {
                flex-direction: column;
            }

            .nest-banner-image,
            .nest-banner-content {
                width: 100%;
            }

            .nest-main-content {
                flex-direction: column;
            }

            .nest-content-divider {
                display: none;
            }

            .nest-info-strip {
                flex-wrap: wrap;
                gap: 15px;
            }

            .nest-info-divider {
                display: none;
            }

            .nest-step strong {
                min-width: 70px;
                font-size: 13px;
            }
        }
    </style>
</head>

<body>
    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1><?= htmlspecialchars($recipe['title']) ?></h1>
        </div>
    </section>

    <section class="nest-recipe-section">
        <!-- TOP BANNER -->
        <div class="nest-banner-row">
            <div class="nest-banner-image">
                <img src="./<?= htmlspecialchars($recipe['image']) ?>" alt="<?= htmlspecialchars($recipe['title']) ?>">
            </div>
            <div class="nest-banner-content">
                <h2><?= htmlspecialchars($recipe['title']) ?></h2>
                <p><?= htmlspecialchars($recipe['short_description']) ?></p>
            </div>
        </div>

        <!-- INFO STRIP -->
        <div class="nest-info-strip">
            <div class="nest-info-item">
                <img src="./assets/images/rs1.webp" alt="">
                <span class="nest-info-title">Cuisine</span>
                <span class="nest-info-value"><?= htmlspecialchars($recipe['cuisine']) ?></span>
            </div>
            <div class="nest-info-divider"></div>
            <div class="nest-info-item">
                <img src="./assets/images/rs2.webp" alt="">
                <span class="nest-info-title">Meal Course</span>
                <span class="nest-info-value"><?= htmlspecialchars($recipe['meal_course']) ?></span>
            </div>
            <div class="nest-info-divider"></div>
            <div class="nest-info-item">
                <img src="./assets/images/rs3.webp" alt="">
                <span class="nest-info-title">Delivery</span>
                <span class="nest-info-value"><?= htmlspecialchars($recipe['delivery']) ?></span>
            </div>
            <div class="nest-info-divider"></div>
            <div class="nest-info-item">
                <img src="./assets/images/rs4.webp" alt="">
                <span class="nest-info-title">Serves</span>
                <span class="nest-info-value"><?= htmlspecialchars($recipe['serves']) ?></span>
            </div>
        </div>

        <!-- MAIN CONTENT -->
        <div class="nest-main-content">
            <!-- INGREDIENTS -->
            <div class="nest-ingredients-box">
                <div class="nest-heading-with-icon">
                    <img src="./assets/images/rs5.svg" alt="">
                    <h3>Ingredients</h3>
                </div>
                <?= $ingredients_html ?>
            </div>

            <div class="nest-content-divider"></div>

            <!-- PREPARATION -->
            <div class="nest-preparation-box">
                <div class="nest-heading-with-icon">
                    <img src="./assets/images/rs6.svg" alt="">
                    <h3>Prepare <?= htmlspecialchars($recipe['title']) ?> Recipe</h3>
                </div>
                <?= $preparation_html ?>
            </div>
        </div>
    </section>

    <?php include 'footer.php'; ?>
</body>

</html>