<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">
</head>

<body>
    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 250px;
            background: url('./assets/images/dir-bn.webp') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 500;
            font-size: 3rem;
            margin: 0;
            position: relative;
            left: 80px;
            font-family: "Berkshire Swash", serif;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 2rem;
                margin: 0;
                position: relative;
                left: 50px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <style>
        /* Main Section Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .cb-main-section {
            width: 100%;
            position: relative;
        }

        .cb-outer {
            background-color: white;
            margin-top: -32px;
            padding: 20px 0;
        }

        .cb-inner {
            max-width: 1200px;
            margin: auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            gap: 60px;
        }

        .cb-left {
            flex: 1;
        }

        .cb-heading {
            font-size: 2.9rem;
            font-weight: 500;
            color: brown;
            margin-bottom: 20px;
            font-family: "Berkshire Swash", serif;
        }

        .cb-description {
            font-size: 14px;
            line-height: 1.7;
            color: brown;
            margin-bottom: 20px;
            text-align: justify;
        }

        .cb-description .span {
            font-weight: 600;
        }

        .cb-readmore {
            display: inline-block;
            padding: 12px 28px;
            background-color: transparent;
            color: brown;
            font-size: 14px;
            text-decoration: none;
            border-radius: 4px;
            border: 2px solid brown;
        }

        .cb-readmore:hover {
            color: #f5f5f5;
            background-color: brown;
            transition: 0.4s;
        }

        /* RIGHT SLIDER (IMAGE CONTAINER) */
        .cb-right {
            flex: 1;
            position: relative;
            /* Reduced height for desktop */
            height: 450px;
            width: auto;
            overflow: hidden;
            /* Background color added so empty space looks clean if image aspect ratio differs */
            border-radius: 10px;
        }

        .cb-slider {
            width: 100%;
            height: 100%;
            position: relative;
        }

        .cb-slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 1s ease, transform 1s ease;
        }

        .cb-slide.active {
            opacity: 1;
            transform: translateY(0);
        }

        .cb-slide img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            border-radius: 10px;
        }

        @keyframes floatUpDown {
            0% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-10px);
            }

            100% {
                transform: translateY(0);
            }
        }

        /* MOBILE FIX */
        @media (max-width: 768px) {

            .cb-outer {
                margin-top: 0 !important;
                padding-top: 20px;
            }

            .cb-inner {
                flex-direction: column !important;
                gap: 20px;
            }

            /* Slider at top with smaller height */
            .cb-right {
                width: 100%;
                /* Reduced height for mobile */
                height: 220px;
                order: -1;
                display: block;
            }

            /* Force image visibility */
            .cb-right .cb-slide {
                opacity: 1 !important;
                transform: translateY(0) !important;
                position: relative;
            }

            .cb-left {
                width: 100%;
            }

            .cb-heading {
                font-size: 24px;
                text-align: center;
            }

            .cb-description {
                text-align: justify;
            }

            .cb-readmore {
                display: block;
                width: fit-content;
                margin: 15px auto 0;
            }
        }
    </style>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Director Message</h1>
        </div>
    </section>

    <section class="cb-main-section">
        <div class="cb-outer">
            <div class="cb-inner">

                <div class="cb-left">
                    <h2 class="cb-heading">Director Message</h2>

                    <p class="cb-description">
                        <span class="span">OneChef® India</span> was founded with a clear vision to deliver high-quality, hygienic, and innovative food products that meet the evolving needs of consumers and businesses. Our focus has always been on excellence in food manufacturing, ensuring superior quality, safety, and consistency in every product we produce.
                    </p>

                    <p class="cb-description">
                        At OneChef® India, we believe that quality and trust are the foundation of long-term success. By adopting advanced manufacturing technologies, maintaining strict hygiene standards, and using premium ingredients, we continuously strive to provide reliable and value-driven food solutions to our customers.
                    </p>

                    <p class="cb-description">
                        Our commitment to innovation, operational excellence, and customer satisfaction drives us to improve every day. We aim to strengthen our position in the food manufacturing industry while building lasting relationships and contributing to a healthier and better future through quality food products.
                    </p>

                    <p class="cb-description" style="font-size: 30px; font-family: Satisfy, cursive;">
                        Mr. Ravi Shankar Kumar
                    </p>

                    <p class="cb-description" style="font-size: 15px; font-family: Satisfy, cursive; position:relative; bottom: 30px; right:10px">
                        - Director Of OneChef® India -
                    </p>

                </div>

                <!-- IMAGE SLIDER -->
                <div class="cb-right">
                    <div class="cb-slider">
                        <div class="cb-slide active">
                            <img src="./assets/images/dir.png" alt="Director Image">
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>


    <?php include 'footer.php' ?>
</body>

</html>