<?php
session_start();
$captcha = rand(1000, 9999);
$_SESSION['captcha'] = $captcha;
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">
</head>

<body>
    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 300px;
            background: url('./assets/images/contact-bn.jpg') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 600;
            font-size: 1.5rem;
            margin: 0;
            position: relative;
            left: 80px;
            text-transform: uppercase;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 1.2rem;
                margin: 0;
                position: relative;
                left: 120px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <section class="custom-banner-section">

    </section>

    <section class="vv-contact-section">
        <div class="vv-contact-container">

            <!-- LEFT SIDE -->
            <div class="vv-contact-left">
                <div class="vv-contact-scroll">

                    <h4 class="vv-contact-title">OneChef<sup>®</sup>India-Patna (Bihar), India</h4>
                    <p><a>Brahmsthani, Patna Sadar, Sheikhpura, Patna(Bihar)-India.</a></p>
                    <p><a href="tel:+91-9334482474">Contact No: +91-9334482474</a></p>
                    <p>
                        <a href="https://api.whatsapp.com/send?phone=+91-9334482474" target="_blank">
                            WhatsApp No: +91-9334482474
                        </a>
                    </p>

                    <p><a href="mailto:maakamaindiaprivateltd@gmail.com	">Email: maakamaindiaprivateltd@gmail.com </a></p>
                    <p><a href="https://www.domain" target="_blank">Website: www.domain</a></p>

                    <hr>

                    <!-- MAP INSTEAD OF BANGALORE & MUMBAI -->

                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3597.9312215717664!2d85.08687727416945!3d25.60720161497428!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39ed5794ecb0cfe7%3A0x4952030c3acbfbf3!2sBrahmasthan%20Rd%2C%20Sheikhpura%2C%20Patna%2C%20Bihar%20800014!5e0!3m2!1sen!2sin!4v1771479836745!5m2!1sen!2sin"
                        width="100%"
                        height="250"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>

                </div>
            </div>

            <!-- RIGHT SIDE -->
            <div class="vv-contact-right">
                <h2 class="vv-form-heading">Get <span class="">In Touch</span> With Us</h2>

                <form class="vv-contact-form" action="send-mail.php" method="post">

                    <input type="text" name="name" placeholder="Enter Name" required>
                    <input type="email" name="email" placeholder="Enter Email Id" required>

                    <input type="text" name="phone" placeholder="Enter Phone No" required>
                    <textarea name="message" placeholder="Message" required></textarea>

                    <div class="vv-form-row">
                        <span class="vv-captcha-box"><?php echo $captcha; ?></span>
                        <input type="text" name="captcha_input" placeholder="Enter Code" required>
                        <button type="submit" name="submit">Submit</button>
                    </div>

                </form>
            </div>

        </div>
    </section>

    <style>
        .vv-contact-section {
            padding: 40px 0;
            background: #ffffff;
        }

        .vv-contact-container {
            max-width: 1200px;
            margin: auto;
            display: flex;
            gap: 30px;
            padding: 0 15px;
        }

        .vv-contact-left {
            width: 50%;
            border-right: 1px solid #ddd;
        }

        .vv-contact-scroll {
            max-height: 500px;
            overflow-y: auto;
            padding-right: 15px;
        }

        .vv-contact-title {
            font-size: 25px;
            font-weight: 500;
            margin-bottom: 8px;
            color: brown;
            font-family: "Concert One", sans-serif;
        }

        .vv-contact-left p {
            font-size: 14px;
            color: brown;
            margin-bottom: 6px;
            font-weight: 500;
        }

        .vv-contact-left p a {
            color: brown;
            font-weight: 500;
            font-size: 14px;
        }

        .vv-contact-left hr {
            margin: 20px 0;
            border: none;
            border-top: 1px solid #ddd;
        }

        .vv-contact-right {
            width: 50%;
            background-image: url('./assets/images/form-bg.png');
            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;
            border-radius: 10px;
        }

        .vv-form-heading {
            font-size: 26px;
            margin-bottom: 0px;
            font-weight: 600;
            padding: 15px;
            color: brown;
        }

        .vv-contact-form {
            padding: 15px;
        }

        .vv-contact-form input,
        .vv-contact-form select,
        .vv-contact-form textarea {
            width: 100%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1.5px solid brown;
            font-size: 14px;
            border-radius: 20px;
        }

        input::placeholder {
            color: brown;
        }

        textarea::placeholder {
            color: brown;
        }

        .vv-contact-form textarea {
            resize: none;
            height: 100px;
        }

        .vv-form-row {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .vv-captcha-box {
            padding: 12px 16px;
            background: brown;
            font-weight: 600;
            letter-spacing: 3px;
            border: 1.5px solid brown;
            color: white;
            border-radius: 20px;
        }

        .vv-form-row input {
            flex: 1;
        }

        .vv-form-row button {
            padding: 12px 25px;
            border: none;
            background: brown;
            color: #fff;
            cursor: pointer;
            font-size: 14px;
            border-radius: 20px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .vv-contact-container {
                flex-direction: column;
            }

            .vv-contact-left,
            .vv-contact-right {
                width: 100%;
                border: none;
            }

            .vv-form-row {
                flex-direction: column;
                align-items: stretch;
            }
        }
    </style>



    <?php include 'footer.php' ?>
</body>

</html>