      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">

      <title>OneChef® India | Premium Food Manufacturing Company</title>

      <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

      <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

      <meta name="author" content="OneChef® India">
      <meta name="robots" content="index, follow">
      <meta name="language" content="English">
      <meta name="revisit-after" content="7 days">
      <meta name="rating" content="General">

      <!-- Open Graph for social sharing -->
      <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
      <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
      <meta property="og:type" content="website">
      <meta property="og:locale" content="en_IN">
      <meta property="og:image" content="assets/images/logo.pngfav.jpg">

      <!-- Twitter Card for social sharing -->
      <meta name="twitter:card" content="summary_large_image">
      <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
      <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
      <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

      <!-- Favicon -->
      <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
      <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
      <link rel="apple-touch-icon" href="./assets/images/logo.png">

      <!-- Accessibility improvements -->
      <meta name="theme-color" content="brown">
      <style>
          .pspl-why-section {
              background: #f5f5f5;
              padding: 20px 20px;
          }

          .pspl-why-container {
              max-width: 1200px;
              margin: 0 auto;
          }

          .pspl-why-title {
              font-size: 3rem;
              font-weight: 500;
              color: brown;
              margin-bottom: 40px;
              font-family: "Berkshire Swash", serif;
          }

          .pspl-why-grid {
              display: grid;
              grid-template-columns: repeat(3, 1fr);
              gap: 20px;
          }

          .pspl-why-card {
              background: #ffffff;
              border: 1px solid brown;
              padding: 25px;
              display: flex;
              align-items: flex-start;
              gap: 20px;
              transition: 0.3s ease;
              border-top-left-radius: 15px;
              border-bottom-right-radius: 15px;
          }

          .pspl-why-card:hover {
              box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
          }

          .pspl-why-icon {
              width: 50px;
              height: 50px;
              min-width: 50px;
              display: flex;
              align-items: center;
              justify-content: center;
          }

          .pspl-why-icon svg {
              width: 40px;
              height: 40px;
              fill: brown;
          }

          .pspl-why-text {
              font-size: 14px;
              color: #555;
              line-height: 1.6;
          }

          /* Bottom row alignment */
          .pspl-why-card:nth-child(4),
          .pspl-why-card:nth-child(5) {
              grid-column: span 1;
          }

          /* Responsive */
          @media (max-width: 992px) {
              .pspl-why-grid {
                  grid-template-columns: repeat(2, 1fr);
              }
          }

          @media (max-width: 600px) {
              .pspl-why-grid {
                  grid-template-columns: 1fr;
              }

              .pspl-why-title {
                  font-size: 1.5rem;
              }
          }
      </style>

      <section class="pspl-why-section">
          <div class="pspl-why-container">
              <h2 class="pspl-why-title">Why Collaborate with OneChef® India?</h2>

              <div class="pspl-why-grid">

                  <div class="pspl-why-card">
                      <div class="pspl-why-icon">
                          <svg viewBox="0 0 24 24">
                              <path d="M3 17h2v4H3v-4zm4-6h2v10H7V11zm4-4h2v14h-2V7zm4 8h2v6h-2v-6zm4-12v18h2V3h-2z" />
                          </svg>
                      </div>
                      <div class="pspl-why-text">
                          Advanced food manufacturing processes delivering high-quality and consistent products.
                      </div>
                  </div>

                  <div class="pspl-why-card">
                      <div class="pspl-why-icon">
                          <svg viewBox="0 0 24 24">
                              <path d="M12 2l9 4v6c0 5-3.8 9.7-9 10-5.2-.3-9-5-9-10V6l9-4zm0 4l-5 2v4c0 3.5 2.6 6.8 5 7 2.4-.2 5-3.5 5-7V8l-5-2z" />
                          </svg>
                      </div>
                      <div class="pspl-why-text">
                          Strict quality control, hygiene standards, and food safety compliance at every stage.
                      </div>
                  </div>

                  <div class="pspl-why-card">
                      <div class="pspl-why-icon">
                          <svg viewBox="0 0 24 24">
                              <path d="M5 4h14v2H5V4zm0 4h14v12H5V8zm7 2l4 4h-3v4h-2v-4H8l4-4z" />
                          </svg>
                      </div>
                      <div class="pspl-why-text">
                          Reliable production capacity with efficient supply and timely delivery solutions.
                      </div>
                  </div>

                  <div class="pspl-why-card">
                      <div class="pspl-why-icon">
                          <svg viewBox="0 0 24 24">
                              <path d="M12 1a5 5 0 015 5v2h1a2 2 0 012 2v9a2 2 0 01-2 2H6a2 2 0 01-2-2v-9a2 2 0 012-2h1V6a5 5 0 015-5zm-3 7h6V6a3 3 0 00-6 0v2z" />
                          </svg>
                      </div>
                      <div class="pspl-why-text">
                          Premium ingredients and modern technology ensuring superior taste and nutrition.
                      </div>
                  </div>

                  <div class="pspl-why-card">
                      <div class="pspl-why-icon">
                          <svg viewBox="0 0 24 24">
                              <path d="M12 1l3 6h6l-4.5 4 2 6-6.5-4-6.5 4 2-6L3 7h6l3-6z" />
                          </svg>
                      </div>
                      <div class="pspl-why-text">
                          Customized food solutions and long-term partnerships to support business growth.
                      </div>
                  </div>

              </div>

          </div>

      </section>