<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Money Receipt</title>

    <!-- Poppins Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body {
            margin: 0;
            background: #e5e5e5;
            font-family: "Poppins", sans-serif;
        }

        /* WRAPPER */
        .rcpt-wrapper {
            width: 900px;
            background: white;
            margin: 40px auto;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        /* HEADER */
        .rcpt-header {
            position: relative;
        }

        .rcpt-top-shape {
            height: 18px;
            background: linear-gradient(90deg, #0f4c5c 60%, #f7931e 60%);
        }

        .rcpt-header-inner {
            display: flex;
            justify-content: space-between;
            padding: 20px 30px;
        }

        .rcpt-logo-area {
            text-align: left;
        }

        .rcpt-logo-box {
            width: 40px;
            height: 40px;
            background: linear-gradient(45deg, #0f4c5c, #f7931e);
        }

        .rcpt-logo-text {
            font-weight: 600;
        }

        .rcpt-tagline {
            font-size: 12px;
            color: #777;
        }

        .rcpt-title-area {
            text-align: center;
        }

        .rcpt-main-title {
            font-size: 34px;
            font-weight: 600;
            letter-spacing: 2px;
        }

        .rcpt-contact {
            font-size: 14px;
            color: #555;
        }

        .rcpt-company-area {
            text-align: right;
            font-size: 14px;
        }

        .rcpt-company-name {
            font-weight: 600;
        }

        .rcpt-no-date {
            display: flex;
            justify-content: space-between;
            padding: 10px 30px;
            border-top: 4px solid #f7931e;
        }

        /* BODY */
        .rcpt-body {
            padding: 30px;
        }

        .rcpt-field {
            margin-bottom: 20px;
        }

        .rcpt-label {
            display: inline-block;
            min-width: 220px;
        }

        .rcpt-line {
            display: inline-block;
            border-bottom: 1px dotted #000;
            width: 65%;
        }

        .rcpt-row {
            display: flex;
            gap: 20px;
        }

        .half {
            width: 50%;
        }

        .third {
            width: 33.3%;
        }

        .align-bottom {
            align-items: center;
            justify-content: space-between;
            margin-top: 40px;
        }

        .rcpt-amount-box input {
            height: 28px;
            border: 1px solid #ccc;
            margin-left: 10px;
        }

        .rcpt-sign {
            width: 200px;
            border-top: 1px dotted #000;
            text-align: center;
            padding-top: 8px;
        }

        /* FOOTER DESIGN */
        .rcpt-footer {
            display: flex;
            height: 50px;
        }

        .rcpt-footer-left {
            width: 60%;
            background: #f7931e;
        }

        .rcpt-footer-right {
            width: 40%;
            background: #0f4c5c;
        }
    </style>
</head>

<body>

    <div class="rcpt-wrapper">

        <!-- HEADER -->
        <div class="rcpt-header">

            <div class="rcpt-top-shape"></div>

            <div class="rcpt-header-inner">

                <!-- LEFT LOGO -->
                <div class="rcpt-logo-area">
                    <div class="rcpt-logo-box"></div>
                    <div class="rcpt-logo-text">LOGO HERE</div>
                    <div class="rcpt-tagline">TAGLINE</div>
                </div>

                <!-- CENTER TITLE -->
                <div class="rcpt-title-area">
                    <div class="rcpt-main-title">MONEY RECEIPT</div>
                    <div class="rcpt-contact">
                        📞 0000-000000 &nbsp;&nbsp; ✉ yourmail@mail.com
                    </div>
                </div>

                <!-- RIGHT COMPANY -->
                <div class="rcpt-company-area">
                    <div class="rcpt-company-name">Company Name Here</div>
                    <div class="rcpt-company-address">
                        Your Business Address 0000<br>
                        Main Street, Unit 000C FEL, 0000
                    </div>
                </div>

            </div>

            <div class="rcpt-no-date">
                <div>NO ..................</div>
                <div>Date ..................</div>
            </div>

        </div>

        <!-- BODY -->
        <div class="rcpt-body">

            <div class="rcpt-field">
                <span class="rcpt-label">Received with thanks from</span>
                <span class="rcpt-line"></span>
            </div>

            <div class="rcpt-field">
                <span class="rcpt-label">Amount</span>
                <span class="rcpt-line"></span>
            </div>

            <div class="rcpt-field">
                <span class="rcpt-label">In word</span>
                <span class="rcpt-line"></span>
            </div>

            <div class="rcpt-row">
                <div class="rcpt-field half">
                    <span class="rcpt-label">For</span>
                    <span class="rcpt-line"></span>
                </div>

                <div class="rcpt-field half">
                    <span class="rcpt-label">Branch</span>
                    <span class="rcpt-line"></span>
                </div>
            </div>

            <div class="rcpt-row">
                <div class="rcpt-field third">
                    <span class="rcpt-label">ACCT</span>
                    <span class="rcpt-line"></span>
                </div>

                <div class="rcpt-field third">
                    <span class="rcpt-label">PAID</span>
                    <span class="rcpt-line"></span>
                </div>

                <div class="rcpt-field third">
                    <span class="rcpt-label">DUE</span>
                    <span class="rcpt-line"></span>
                </div>
            </div>

            <div class="rcpt-row align-bottom">
                <div class="rcpt-amount-box">
                    Amount =
                    <input type="text" class="rcpt-input">
                </div>

                <div class="rcpt-sign">Received by</div>
                <div class="rcpt-sign">Authorized Signature</div>
            </div>

        </div>

        <!-- FOOTER DESIGN -->
        <div class="rcpt-footer">
            <div class="rcpt-footer-left"></div>
            <div class="rcpt-footer-right"></div>
        </div>

    </div>

    <script>
        // example reusable function
        function setReceiptNumber(no) {
            console.log("Receipt No:", no);
        }

        // you can extend later for auto fill / print
    </script>
</body>

</html>