<?php
ob_start();
include 'includes.php';
include 'connection.php';
session_start();

if (!isset($_SESSION['admin'])) {
    header('Location: index.php');
    exit;
}

// Pagination setup
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;
$offset = ($page - 1) * $per_page;

// Delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $res = $conn->query("SELECT image FROM team_members WHERE id=$id");
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        if (file_exists("../" . $row['image'])) unlink("../" . $row['image']);
    }
    $conn->query("DELETE FROM team_members WHERE id=$id");
    header("Location: manage_team.php?page=" . ($page));
    exit;
}

// Toggle Status
if (isset($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $conn->query("UPDATE team_members SET status = 1-status WHERE id=$id");
    header("Location: manage_team.php?page=" . ($page));
    exit;
}

// Add/Edit Logic
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $conn->real_escape_string($_POST['name']);
    $designation = $conn->real_escape_string($_POST['designation']);

    $targetDir = "../assets/team/";
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

    // Edit
    if (isset($_POST['edit_id']) && !empty($_POST['edit_id'])) {
        $id = (int)$_POST['edit_id'];

        $image_sql = '';
        if (!empty($_FILES['image']['name'])) {
            $fileName = time() . "_" . basename($_FILES['image']['name']);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
                $dbPath = "assets/team/" . $fileName;
                $image_sql = ", image='$dbPath'";

                $old = $conn->query("SELECT image FROM team_members WHERE id=$id")->fetch_assoc();
                if ($old && !empty($old['image']) && file_exists("../" . $old['image'])) {
                    unlink("../" . $old['image']);
                }
            }
        }

        $sql = "UPDATE team_members SET name='$name', designation='$designation' $image_sql WHERE id=$id";
        $result = $conn->query($sql);
    } else {
        // Add
        $imagePath = "";
        if (!empty($_FILES['image']['name'])) {
            $fileName = time() . "_" . basename($_FILES['image']['name']);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
                $imagePath = "assets/team/" . $fileName;
            }
        }
        $sql = "INSERT INTO team_members (name, designation, image) VALUES ('$name', '$designation', '$imagePath')";
        $result = $conn->query($sql);
    }

    header("Location: manage_team.php?page=" . ($page));
    exit;
}

// Get paginated results
$total_query = $conn->query("SELECT COUNT(*) as total FROM team_members");
$total = $total_query->fetch_assoc()['total'];
$total_pages = ceil($total / $per_page);

$result = $conn->query("SELECT * FROM team_members ORDER BY id DESC LIMIT $per_page OFFSET $offset");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manage Team</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            margin: 0;
            padding: 0;
            font-family: sans-serif;
        }

        .spac-content {
            padding: 15px;
            min-height: 100vh;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .spac-management-container {
            max-width: 1200px;
            margin: auto;
        }

        .spac-management-title {
            font-size: 1.3rem;
            margin-bottom: 15px;
            color: white;
        }

        .spac-upload-form {
            display: flex;
            gap: 8px;
            margin-bottom: 15px;
            flex-wrap: wrap;
            align-items: flex-end;
            padding: 15px;
            border-radius: 4px;
        }

        .spac-field {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }

        .spac-input {
            padding: 6px 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 0.85rem;
            width: 100%;
            box-sizing: border-box;
        }

        .spac-upload-btn {
            padding: 6px 12px;
            background: brown;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            height: 32px;
            border: 1px solid brown;
        }

        .spac-table-container {
            overflow-x: auto;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 8px;
        }

        .spac-management-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.85rem;
        }

        .spac-management-table th {
            background: brown;
            color: white;
            padding: 10px 8px;
            text-align: left;
        }

        .spac-management-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #eee;
            color: #333;
            vertical-align: middle;
        }

        .spac-btn {
            width: 28px;
            height: 28px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            margin-right: 5px;
        }

        .spac-toggle-btn {
            background-color: #17a2b8;
        }

        .spac-delete-btn {
            background-color: #dc3545;
        }

        .spac-edit-btn {
            background-color: #ffc107;
            color: #212529;
        }

        .status-badge {
            padding: 3px 10px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 500;
        }

        .status-active {
            background: #d4edda;
            color: #155724;
        }

        .status-inactive {
            background: #fff3cd;
            color: #856404;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
        }

        .pagination a,
        .pagination span {
            padding: 8px 12px;
            background: rgba(255, 255, 255, 0.9);
            color: brown;
            text-decoration: none;
            border-radius: 4px;
            border: 1px solid #ddd;
        }

        .pagination a:hover {
            background: brown;
            color: white;
        }

        .pagination .current {
            background: brown;
            color: white;
            font-weight: bold;
        }

        /* Modal */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.6);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 95%;
            max-width: 500px;
            border-radius: 8px;
        }

        .close {
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            color: #aaa;
        }

        .close:hover {
            color: #000;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            font-size: 0.9rem;
        }
    </style>
</head>

<body>
    <div class="spac-content">
        <div class="spac-management-container">
            <h1 class="spac-management-title">Manage Team Members</h1>

            <!-- Add Button -->
            <div class="spac-upload-form" style="justify-content: space-between;">
                <button class="spac-upload-btn" onclick="openAddModal()" style="padding: 8px 15px; height: auto;">
                    <i class="fas fa-plus"></i> Add Team Member
                </button>
            </div>

            <!-- Table -->
            <div class="spac-table-container">
                <table class="spac-management-table">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Designation</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $serial = $offset + 1;
                        while ($row = $result->fetch_assoc()):
                        ?>
                            <tr>
                                <td><?= $serial++ ?></td>
                                <td>
                                    <?php if (!empty($row['image'])): ?>
                                        <img src="../<?= htmlspecialchars($row['image']) ?>" width="50" height="50" style="object-fit:cover; border-radius:50%;" onerror="this.src='https://via.placeholder.com/50'">
                                    <?php else: ?>
                                        <img src="https://via.placeholder.com/50" width="50" height="50" style="object-fit:cover; border-radius:50%;">
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($row['name']) ?></td>
                                <td><?= htmlspecialchars($row['designation']) ?></td>
                                <td>
                                    <span class="status-badge <?= $row['status'] ? 'status-active' : 'status-inactive' ?>">
                                        <?= $row['status'] ? 'Active' : 'Inactive' ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="spac-btn spac-edit-btn" onclick='openEditModal(<?= json_encode($row) ?>)'>
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="?page=<?= $page ?>&toggle=<?= $row['id'] ?>" class="spac-btn spac-toggle-btn">
                                        <i class="fas fa-<?= $row['status'] ? 'ban' : 'check' ?>"></i>
                                    </a>
                                    <a href="?page=<?= $page ?>&delete=<?= $row['id'] ?>" onclick="return confirm('Delete this team member?')" class="spac-btn spac-delete-btn">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <div class="pagination">
                    <?php if ($page > 1): ?>
                        <a href="?page=1">First</a>
                        <a href="?page=<?= $page - 1 ?>">Prev</a>
                    <?php endif; ?>

                    <?php for ($i = max(1, $page - 2); $i <= min($total_pages, $page + 2); $i++): ?>
                        <?php if ($i == $page): ?>
                            <span class="current"><?= $i ?></span>
                        <?php else: ?>
                            <a href="?page=<?= $i ?>"><?= $i ?></a>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($page < $total_pages): ?>
                        <a href="?page=<?= $page + 1 ?>">Next</a>
                        <a href="?page=<?= $total_pages ?>">Last</a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div><br><br><br><br>

    <!-- Add/Edit Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2 id="modal-title" style="margin-top:0; color:brown;">Add Team Member</h2>
            <form method="POST" enctype="multipart/form-data" id="teamForm">
                <input type="hidden" name="edit_id" id="edit_id">

                <div class="form-group">
                    <label>Name *</label>
                    <input type="text" name="name" id="edit_name" class="spac-input" required>
                </div>

                <div class="form-group">
                    <label>Designation</label>
                    <input type="text" name="designation" id="edit_designation" class="spac-input" placeholder="e.g. CEO, Manager">
                </div>

                <div class="form-group">
                    <label>Image</label>
                    <input type="file" name="image" class="spac-input" accept="image/*">
                    <small style="color:#666;">JPG, PNG recommended (Square image preferred)</small>
                </div>

                <button type="submit" class="spac-upload-btn" style="width:100%; padding:10px;">
                    Save Member
                </button>
            </form>
        </div>
    </div>

    <script>
        function openAddModal() {
            document.getElementById('modal-title').innerText = "Add Team Member";
            document.getElementById('teamForm').reset();
            document.getElementById('edit_id').value = '';
            document.getElementById('editModal').style.display = 'block';
        }

        function openEditModal(data) {
            document.getElementById('modal-title').innerText = "Edit Team Member";
            document.getElementById('edit_id').value = data.id || '';
            document.getElementById('edit_name').value = data.name || '';
            document.getElementById('edit_designation').value = data.designation || '';
            document.getElementById('editModal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('editModal').style.display = 'none';
        }

        window.onclick = function(event) {
            const modal = document.getElementById('editModal');
            if (event.target == modal) closeModal();
        }

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeModal();
        });
    </script>
</body>

</html>
<?php ob_end_flush(); ?>