<?php
ob_start();
include 'includes.php';
include 'connection.php';
session_start();

if (!isset($_SESSION['admin'])) {
    header('Location: index.php');
    exit;
}

// Pagination setup
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;
$offset = ($page - 1) * $per_page;

// Delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $res = $conn->query("SELECT image FROM recipes WHERE id=$id");
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        if (file_exists("../" . $row['image'])) unlink("../" . $row['image']);
    }
    $conn->query("DELETE FROM recipes WHERE id=$id");
    header("Location: manage_recipes.php?page=" . ($page));
    exit;
}

// Toggle Status
if (isset($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $conn->query("UPDATE recipes SET status = 1-status WHERE id=$id");
    header("Location: manage_recipes.php?page=" . ($page));
    exit;
}

// Add/Edit Logic
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $conn->real_escape_string($_POST['title']);
    $short_description = $conn->real_escape_string($_POST['short_description']);
    $cuisine = $conn->real_escape_string($_POST['cuisine']);
    $meal_course = $conn->real_escape_string($_POST['meal_course']);
    $serves = (int)$_POST['serves'];
    $delivery = $conn->real_escape_string($_POST['delivery']);
    $diet_type = $conn->real_escape_string($_POST['diet_type']);

    // Fix: Get CKEditor content properly using POST data
    $ingredients = isset($_POST['ingredients']) ? $conn->real_escape_string($_POST['ingredients']) : '';
    $preparation = isset($_POST['preparation']) ? $conn->real_escape_string($_POST['preparation']) : '';

    $targetDir = "../assets/recipes/";
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

    // Edit
    if (isset($_POST['edit_id']) && !empty($_POST['edit_id'])) {
        $id = (int)$_POST['edit_id'];

        // Check if new image uploaded
        $image_sql = '';
        if (!empty($_FILES['image']['name'])) {
            $fileName = time() . "_" . basename($_FILES['image']['name']);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
                $dbPath = "assets/recipes/" . $fileName;
                $image_sql = ", image='$dbPath'";

                // Delete old image
                $old = $conn->query("SELECT image FROM recipes WHERE id=$id")->fetch_assoc();
                if ($old && !empty($old['image']) && file_exists("../" . $old['image'])) {
                    unlink("../" . $old['image']);
                }
            }
        }

        $sql = "UPDATE recipes SET 
                title='$title', 
                short_description='$short_description', 
                cuisine='$cuisine', 
                meal_course='$meal_course', 
                serves=$serves, 
                delivery='$delivery', 
                diet_type='$diet_type', 
                ingredients='$ingredients', 
                preparation='$preparation' 
                $image_sql 
                WHERE id=$id";

        $result = $conn->query($sql);
    } else {
        // Add
        $imagePath = "";
        if (!empty($_FILES['image']['name'])) {
            $fileName = time() . "_" . basename($_FILES['image']['name']);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
                $imagePath = "assets/recipes/" . $fileName;
            }
        }
        $sql = "INSERT INTO recipes (title, short_description, image, diet_type, cuisine, meal_course, serves, delivery, ingredients, preparation) 
                VALUES ('$title', '$short_description', '$imagePath', '$diet_type', '$cuisine', '$meal_course', $serves, '$delivery', '$ingredients', '$preparation')";
        $result = $conn->query($sql);
    }

    header("Location: manage_recipes.php?page=" . ($page));
    exit;
}

// Get paginated results
$total_query = $conn->query("SELECT COUNT(*) as total FROM recipes");
$total = $total_query->fetch_assoc()['total'];
$total_pages = ceil($total / $per_page);

$result = $conn->query("SELECT * FROM recipes ORDER BY id DESC LIMIT $per_page OFFSET $offset");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manage Recipes</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- CKEditor -->
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <style>
        /* Same styling as your original code */
        body {
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            margin: 0;
            padding: 0;
            font-family: sans-serif;
        }

        .spac-content {
            padding: 15px;
            min-height: 100vh;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .spac-management-container {
            max-width: 1200px;
            margin: auto;
        }

        .spac-management-title {
            font-size: 1.3rem;
            margin-bottom: 15px;
            color: white;
        }

        .spac-upload-form {
            display: flex;
            gap: 8px;
            margin-bottom: 15px;
            flex-wrap: wrap;
            align-items: flex-end;

            padding: 15px;
            border-radius: 4px;
        }

        .spac-field {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }

        .spac-input {
            padding: 6px 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 0.85rem;
            width: 100%;
            box-sizing: border-box;
        }

        .spac-upload-btn {
            padding: 6px 12px;
            background: brown;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            height: 32px;
            border: 1px solid white;
        }

        .spac-table-container {
            overflow-x: auto;
        }

        .spac-management-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.85rem;
        }

        .spac-management-table th {
            background: brown;
            color: white;
            padding: 8px 6px;
            text-align: left;
        }

        .spac-management-table td {
            padding: 8px 6px;
            border-bottom: 1px solid #eee;
            color: brown;
            vertical-align: top;
            font-weight: 500;
        }

        .spac-btn {
            width: 28px;
            height: 28px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            margin-right: 5px;
        }

        .spac-toggle-btn {
            background-color: #17a2b8;
        }

        .spac-delete-btn {
            background-color: #dc3545;
        }

        .spac-edit-btn {
            background-color: #ffc107;
            color: #212529;
        }

        /* Pagination Styles */
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
        }

        .pagination a,
        .pagination span {
            padding: 8px 12px;
            background: rgba(255, 255, 255, 0.9);
            color: brown;
            text-decoration: none;
            border-radius: 4px;
            border: 1px solid #ddd;
        }

        .pagination a:hover {
            background: brown;
            color: white;
        }

        .pagination .current {
            background: brown;
            color: white;
            font-weight: bold;
        }

        .pagination .disabled {
            color: #999;
            cursor: not-allowed;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.6);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 2% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 95%;
            max-width: 800px;
            border-radius: 8px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .close {
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .form-group {
            margin-bottom: 10px;
        }

        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            font-size: 0.9rem;
        }

        .ckeditor-container {
            border: 1px solid #ccc;
            border-radius: 4px;
        }
    </style>
</head>

<body>
    <div class="spac-content">
        <div class="spac-management-container">
            <h1 class="spac-management-title">Manage Recipes</h1>

            <!-- Add Button (Opens Modal) -->
            <div class="spac-upload-form" style="justify-content: space-between;">
                <button class="spac-upload-btn" onclick="openAddModal()" style="padding: 8px 15px; height: auto;"><i class="fas fa-plus"></i> Add New Recipe</button>
            </div>

            <!-- Table -->
            <div class="spac-table-container">
                <table class="spac-management-table">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Cuisine</th>
                            <th>Diet</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $serial = $offset + 1;
                        while ($row = $result->fetch_assoc()):
                        ?>
                            <tr>
                                <td><?= $serial++ ?></td>
                                <td>
                                    <img src="../<?= htmlspecialchars($row['image']) ?>" width="50" onerror="this.src='https://via.placeholder.com/50'">
                                </td>
                                <td><?= htmlspecialchars($row['title']) ?></td>
                                <td><?= htmlspecialchars($row['cuisine']) ?></td>
                                <td>
                                    <span style="padding:3px 8px; border-radius:12px; font-size:0.75rem; background:<?= $row['diet_type'] == 'veg' ? '#d4edda;color:#155724' : '#f8d7da;color:#721c24' ?>">
                                        <?= ucfirst($row['diet_type']) ?>
                                    </span>
                                </td>
                                <td>
                                    <span style="padding:3px 8px; border-radius:12px; font-size:0.75rem; background:<?= $row['status'] ? '#d4edda;color:#155724' : '#fff3cd;color:#856404' ?>">
                                        <?= $row['status'] ? 'Active' : 'Inactive' ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="spac-btn spac-edit-btn" onclick="openEditModal(<?= htmlspecialchars(json_encode($row)) ?>)"><i class="fas fa-edit"></i></button>
                                    <a href="?page=<?= $page ?>&toggle=<?= $row['id'] ?>" class="spac-btn spac-toggle-btn"><i class="fas fa-<?= $row['status'] ? 'ban' : 'check' ?>"></i></a>
                                    <a href="?page=<?= $page ?>&delete=<?= $row['id'] ?>" onclick="return confirm('Delete?')" class="spac-btn spac-delete-btn"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <div class="pagination">
                    <?php if ($page > 1): ?>
                        <a href="?page=1">First</a>
                        <a href="?page=<?= $page - 1 ?>">Prev</a>
                    <?php else: ?>
                        <span class="disabled">First</span>
                        <span class="disabled">Prev</span>
                    <?php endif; ?>

                    <?php
                    $start_page = max(1, $page - 2);
                    $end_page = min($total_pages, $page + 2);
                    for ($i = $start_page; $i <= $end_page; $i++):
                    ?>
                        <?php if ($i == $page): ?>
                            <span class="current"><?= $i ?></span>
                        <?php else: ?>
                            <a href="?page=<?= $i ?>"><?= $i ?></a>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($page < $total_pages): ?>
                        <a href="?page=<?= $page + 1 ?>">Next</a>
                        <a href="?page=<?= $total_pages ?>">Last</a>
                    <?php else: ?>
                        <span class="disabled">Next</span>
                        <span class="disabled">Last</span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Add/Edit Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2 id="modal-title">Add New Recipe</h2>
            <form method="POST" enctype="multipart/form-data" id="recipeForm" onsubmit="return submitForm()">
                <input type="hidden" name="edit_id" id="edit_id">

                <div style="display:flex; gap:15px; flex-wrap:wrap;">
                    <div class="form-group" style="flex:1; min-width:250px;">
                        <label>Title *</label>
                        <input type="text" name="title" id="edit_title" class="spac-input" required>
                    </div>
                    <div class="form-group" style="flex:1; min-width:250px;">
                        <label>Cuisine</label>
                        <input type="text" name="cuisine" id="edit_cuisine" class="spac-input" placeholder="e.g. Indian">
                    </div>
                </div>

                <div class="form-group">
                    <label>Short Description</label>
                    <textarea name="short_description" id="edit_short_description" class="spac-input" rows="2"></textarea>
                </div>

                <div style="display:flex; gap:15px; flex-wrap:wrap;">
                    <div class="form-group" style="flex:1; min-width:120px;">
                        <label>Diet Type</label>
                        <select name="diet_type" id="edit_diet_type" class="spac-input">
                            <option value="veg">Veg</option>
                            <option value="non-veg">Non-Veg</option>
                        </select>
                    </div>
                    <div class="form-group" style="flex:1; min-width:120px;">
                        <label>Meal Course</label>
                        <input type="text" name="meal_course" id="edit_meal_course" class="spac-input" placeholder="e.g. Dessert">
                    </div>
                    <div class="form-group" style="flex:1; min-width:120px;">
                        <label>Serves</label>
                        <input type="number" name="serves" id="edit_serves" class="spac-input" value="1" min="1">
                    </div>
                    <div class="form-group" style="flex:1; min-width:120px;">
                        <label>Delivery</label>
                        <select name="delivery" id="edit_delivery" class="spac-input">
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label>Image</label>
                    <input type="file" name="image" id="image_input" class="spac-input" accept="image/*">
                    <small style="color:#666;">JPG, PNG up to 5MB</small>
                </div>

                <div class="form-group">
                    <label>Ingredients</label>
                    <textarea name="ingredients" id="ingredients" class="spac-input ckeditor-container" rows="4"></textarea>
                </div>

                <div class="form-group">
                    <label>Preparation Steps</label>
                    <textarea name="preparation" id="preparation" class="spac-input ckeditor-container" rows="4"></textarea>
                </div>

                <button type="submit" class="spac-upload-btn" style="width:100%; padding:10px;" id="submitBtn">
                    <span id="submitText">Save Recipe</span>
                    <span id="submitSpinner" style="display:none;">Saving...</span>
                </button>
            </form>
        </div>
    </div>

    <script>
        let editor1, editor2;

        // Initialize CKEditor after DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            editor1 = CKEDITOR.replace('ingredients', {
                height: 150,
                toolbar: [
                    ['Bold', 'Italic', 'Underline', 'Strike'],
                    ['NumberedList', 'BulletedList'],
                    ['Link', 'Unlink']
                ]
            });

            editor2 = CKEDITOR.replace('preparation', {
                height: 150,
                toolbar: [
                    ['Bold', 'Italic', 'Underline', 'Strike'],
                    ['NumberedList', 'BulletedList'],
                    ['Link', 'Unlink']
                ]
            });
        });

        function openAddModal() {
            document.getElementById('modal-title').innerText = "Add New Recipe";
            document.getElementById('recipeForm').reset();
            document.getElementById('edit_id').value = '';
            document.getElementById('edit_serves').value = '1';
            document.getElementById('edit_diet_type').value = 'veg';
            document.getElementById('edit_delivery').value = 'No';

            if (editor1) editor1.setData('');
            if (editor2) editor2.setData('');

            document.getElementById('editModal').style.display = 'block';
        }

        function openEditModal(data) {
            document.getElementById('modal-title').innerText = "Edit Recipe";
            document.getElementById('edit_id').value = data.id || '';
            document.getElementById('edit_title').value = data.title || '';
            document.getElementById('edit_cuisine').value = data.cuisine || '';
            document.getElementById('edit_short_description').value = data.short_description || '';
            document.getElementById('edit_diet_type').value = data.diet_type || 'veg';
            document.getElementById('edit_meal_course').value = data.meal_course || '';
            document.getElementById('edit_serves').value = data.serves || 1;
            document.getElementById('edit_delivery').value = data.delivery || 'No';

            // Set CKEditor Data with timeout to ensure editors are ready
            setTimeout(function() {
                if (editor1) editor1.setData(data.ingredients || '');
                if (editor2) editor2.setData(data.preparation || '');
            }, 200);

            document.getElementById('editModal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('editModal').style.display = 'none';
        }

        function submitForm() {
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            const submitSpinner = document.getElementById('submitSpinner');

            // Update CKEditor content to textarea before submit
            if (editor1) editor1.updateElement();
            if (editor2) editor2.updateElement();

            // Show loading state
            submitText.style.display = 'none';
            submitSpinner.style.display = 'inline';
            submitBtn.disabled = true;

            // Validate required fields
            const title = document.getElementById('edit_title').value.trim();
            if (!title) {
                alert('Title is required');
                submitBtn.disabled = false;
                submitText.style.display = 'inline';
                submitSpinner.style.display = 'none';
                return false;
            }

            return true;
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            const modal = document.getElementById('editModal');
            if (event.target == modal) {
                closeModal();
            }
        }

        // ESC key to close modal
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeModal();
            }
        });
    </script>
</body>

</html>
<?php ob_end_flush(); ?>