<?php
ob_start();
include 'includes.php';
include 'connection.php';
session_start();

if (!isset($_SESSION['admin'])) {
    header('Location: index.php');
    exit;
}

// Pagination setup
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;
$offset = ($page - 1) * $per_page;

// Delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $res = $conn->query("SELECT image FROM products WHERE id=$id");
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        if (file_exists("../" . $row['image'])) unlink("../" . $row['image']);
    }
    $conn->query("DELETE FROM products WHERE id=$id");
    header("Location: manage_products.php?page=" . ($page));
    exit;
}

// Toggle Status
if (isset($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $conn->query("UPDATE products SET status = 1-status WHERE id=$id");
    header("Location: manage_products.php?page=" . ($page));
    exit;
}

// Add/Edit Logic
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $conn->real_escape_string($_POST['name']);
    $category = $conn->real_escape_string($_POST['category']);
    $price = (float)$_POST['price'];
    $original_price = !empty($_POST['original_price']) ? (float)$_POST['original_price'] : 0;
    $weight = $conn->real_escape_string($_POST['weight']);
    $diet_type = $conn->real_escape_string($_POST['diet_type']);
    $description = $conn->real_escape_string($_POST['description']);
    $quantity = isset($_POST['quantity']) ? (int)$_POST['quantity'] : 1;

    $targetDir = "../assets/products/";
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

    // Edit
    if (isset($_POST['edit_id'])) {
        $id = (int)$_POST['edit_id'];
        $sql = "UPDATE products SET name='$name', category='$category', price=$price, original_price=$original_price, weight='$weight', diet_type='$diet_type', description='$description', quantity=$quantity WHERE id=$id";

        // Check if new image uploaded
        if (!empty($_FILES['image']['name'])) {
            $fileName = time() . "_" . basename($_FILES['image']['name']);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
                $dbPath = "assets/products/" . $fileName;
                $sql = "UPDATE products SET name='$name', category='$category', price=$price, original_price=$original_price, weight='$weight', diet_type='$diet_type', description='$description', quantity=$quantity, image='$dbPath' WHERE id=$id";

                // Delete old image
                $old = $conn->query("SELECT image FROM products WHERE id=$id")->fetch_assoc();
                if (file_exists("../" . $old['image'])) unlink("../" . $old['image']);
            }
        }
        $conn->query($sql);
    } else {
        // Add - quantity defaults to 1
        $imagePath = "";
        if (!empty($_FILES['image']['name'])) {
            $fileName = time() . "_" . basename($_FILES['image']['name']);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
                $imagePath = "assets/products/" . $fileName;
            }
        }
        $conn->query("INSERT INTO products (name, category, price, original_price, weight, diet_type, description, image, quantity) VALUES ('$name', '$category', $price, $original_price, '$weight', '$diet_type', '$description', '$imagePath', $quantity)");
    }
    header("Location: manage_products.php?page=" . ($page));
    exit;
}

// Get paginated results and total count
$total_query = $conn->query("SELECT COUNT(*) as total FROM products");
$total = $total_query->fetch_assoc()['total'];
$total_pages = ceil($total / $per_page);

$result = $conn->query("SELECT * FROM products ORDER BY id DESC LIMIT $per_page OFFSET $offset");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manage Products</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            margin: 0;
            padding: 0;
            font-family: sans-serif;
        }

        .spac-content {
            padding: 15px;
            min-height: 100vh;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .spac-management-container {
            max-width: 1200px;
            margin: auto;
        }

        .spac-management-title {
            font-size: 1.3rem;
            margin-bottom: 15px;
            color: white;
        }

        .spac-upload-form {
            display: flex;
            gap: 8px;
            margin-bottom: 15px;
            flex-wrap: wrap;
            align-items: flex-end;
            background: rgba(255, 255, 255, 0.95);
            padding: 15px;
            border-radius: 4px;
        }

        .spac-field {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }

        .spac-input {
            padding: 6px 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 0.85rem;
            width: 100%;
            box-sizing: border-box;
        }

        .spac-upload-btn {
            padding: 6px 12px;
            background: #494948;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            height: 32px;
        }

        .spac-table-container {
            overflow-x: auto;
        }

        .spac-management-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.85rem;
        }

        .spac-management-table th {
            background: brown;
            color: white;
            padding: 8px 6px;
            text-align: left;
        }

        .spac-management-table td {
            padding: 8px 6px;
            border-bottom: 1px solid #eee;
            color: brown;
            vertical-align: top;
            font-weight: 500;
        }

        .spac-btn {
            width: 28px;
            height: 28px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            margin-right: 5px;
        }

        .spac-toggle-btn {
            background-color: #17a2b8;
        }

        .spac-delete-btn {
            background-color: #dc3545;
        }

        .spac-edit-btn {
            background-color: #ffc107;
            color: #212529;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
        }

        .pagination a,
        .pagination span {
            padding: 8px 12px;
            background: rgba(255, 255, 255, 0.9);
            color: brown;
            text-decoration: none;
            border-radius: 4px;
            border: 1px solid #ddd;
        }

        .pagination a:hover {
            background: brown;
            color: white;
        }

        .pagination .current {
            background: brown;
            color: white;
            font-weight: bold;
        }

        .pagination .disabled {
            color: #999;
            cursor: not-allowed;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.6);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 600px;
            border-radius: 8px;
        }

        .close {
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .form-group {
            margin-bottom: 10px;
        }

        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            font-size: 0.9rem;
        }
    </style>
</head>

<body>
    <div class="spac-content">
        <div class="spac-management-container">
            <h1 class="spac-management-title">Manage Products (Page <?= $page ?> of <?= $total_pages ?>)</h1>

            <form method="POST" enctype="multipart/form-data" class="spac-upload-form">
                <div class="spac-field" style="flex:1; min-width:150px;">
                    <label>Product Name *</label>
                    <input type="text" name="name" class="spac-input" required>
                </div>
                <div class="spac-field" style="flex:1; min-width:100px;">
                    <label>Category</label>
                    <input type="text" name="category" class="spac-input" placeholder="e.g. Sauce">
                </div>
                <div class="spac-field" style="flex:0.4; min-width:70px;">
                    <label>Price (Rs) *</label>
                    <input type="number" name="price" class="spac-input" step="0.01" required>
                </div>
                <div class="spac-field" style="flex:0.4; min-width:70px;">
                    <label>Orig. Price</label>
                    <input type="number" name="original_price" class="spac-input" step="0.01">
                </div>
                <div class="spac-field" style="flex:0.3; min-width:60px;">
                    <label>Qty *</label>
                    <input type="number" name="quantity" class="spac-input" value="0" min="0" required>
                </div>
                <div class="spac-field" style="flex:0.5; min-width:80px;">
                    <label>Weight</label>
                    <input type="text" name="weight" class="spac-input" placeholder="e.g. 500g">
                </div>
                <div class="spac-field" style="flex:0.5; min-width:100px;">
                    <label>Diet Type</label>
                    <select name="diet_type" class="spac-input">
                        <option value="veg">Veg</option>
                        <option value="non-veg">Non-Veg</option>
                    </select>
                </div>
                <div class="spac-field" style="flex:1; min-width:150px;">
                    <label>Image</label>
                    <input type="file" name="image" class="spac-input">
                </div>
                <button type="submit" class="spac-upload-btn">Add Product</button>
            </form>

            <div class="spac-table-container">
                <table class="spac-management-table">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Price</th>
                            <th>Qty</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $serial = $offset + 1;
                        while ($row = $result->fetch_assoc()):
                        ?>
                            <tr>
                                <td><?= $serial++ ?></td>
                                <td>
                                    <img src="../<?= htmlspecialchars($row['image']) ?>" width="50" onerror="this.src='https://via.placeholder.com/50'">
                                </td>
                                <td><?= htmlspecialchars($row['name']) ?></td>
                                <td><?= htmlspecialchars($row['category']) ?></td>
                                <td>Rs <?= number_format($row['price']) ?></td>
                                <td><strong><?= $row['quantity'] ?></strong></td>
                                <td>
                                    <span style="padding:3px 8px; border-radius:12px; font-size:0.75rem; background:<?= $row['status'] ? '#d4edda;color:#155724' : '#fff3cd;color:#856404' ?>">
                                        <?= $row['status'] ? 'Active' : 'Inactive' ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="spac-btn spac-edit-btn" onclick="openEditModal(<?= htmlspecialchars(json_encode($row)) ?>)"><i class="fas fa-edit"></i></button>
                                    <a href="?page=<?= $page ?>&toggle=<?= $row['id'] ?>" class="spac-btn spac-toggle-btn"><i class="fas fa-<?= $row['status'] ? 'ban' : 'check' ?>"></i></a>
                                    <a href="?page=<?= $page ?>&delete=<?= $row['id'] ?>" onclick="return confirm('Delete?')" class="spac-btn spac-delete-btn"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

            <?php if ($total_pages > 1): ?>
                <div class="pagination">
                    <?php if ($page > 1): ?>
                        <a href="?page=1">First</a>
                        <a href="?page=<?= $page - 1 ?>">Prev</a>
                    <?php else: ?>
                        <span class="disabled">First</span>
                        <span class="disabled">Prev</span>
                    <?php endif; ?>

                    <?php
                    $start_page = max(1, $page - 2);
                    $end_page = min($total_pages, $page + 2);
                    for ($i = $start_page; $i <= $end_page; $i++):
                    ?>
                        <?php if ($i == $page): ?>
                            <span class="current"><?= $i ?></span>
                        <?php else: ?>
                            <a href="?page=<?= $i ?>"><?= $i ?></a>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($page < $total_pages): ?>
                        <a href="?page=<?= $page + 1 ?>">Next</a>
                        <a href="?page=<?= $total_pages ?>">Last</a>
                    <?php else: ?>
                        <span class="disabled">Next</span>
                        <span class="disabled">Last</span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div><br><br><br>

    <div id="editModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('editModal').style.display='none'">&times;</span>
            <h2>Edit Product</h2>
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="edit_id" id="edit_id">

                <div class="form-group">
                    <label>Name *</label>
                    <input type="text" name="name" id="edit_name" class="spac-input" required>
                </div>
                <div style="display:flex; gap:10px;">
                    <div class="form-group" style="flex:1;">
                        <label>Category</label>
                        <input type="text" name="category" id="edit_category" class="spac-input">
                    </div>
                    <div class="form-group" style="flex:1;">
                        <label>Weight</label>
                        <input type="text" name="weight" id="edit_weight" class="spac-input">
                    </div>
                </div>
                <div style="display:flex; gap:10px;">
                    <div class="form-group" style="flex:1;">
                        <label>Price *</label>
                        <input type="number" name="price" id="edit_price" class="spac-input" step="0.01" required>
                    </div>
                    <div class="form-group" style="flex:1;">
                        <label>Quantity *</label>
                        <input type="number" name="quantity" id="edit_quantity" class="spac-input" min="0" required>
                    </div>
                </div>
                <div style="display:flex; gap:10px;">
                    <div class="form-group" style="flex:1;">
                        <label>Original Price</label>
                        <input type="number" name="original_price" id="edit_original_price" class="spac-input" step="0.01">
                    </div>
                    <div class="form-group" style="flex:1;">
                        <label>Diet Type</label>
                        <select name="diet_type" id="edit_diet_type" class="spac-input">
                            <option value="veg">Veg</option>
                            <option value="non-veg">Non-Veg</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label>New Image (Leave blank to keep old)</label>
                    <input type="file" name="image" class="spac-input">
                </div>
                <button type="submit" class="spac-upload-btn" style="width:100%; padding:10px;">Save Changes</button>
            </form>
        </div>
    </div>

    <script>
        function openEditModal(data) {
            document.getElementById('edit_id').value = data.id;
            document.getElementById('edit_name').value = data.name;
            document.getElementById('edit_category').value = data.category || '';
            document.getElementById('edit_price').value = data.price;
            document.getElementById('edit_quantity').value = data.quantity || 1;
            document.getElementById('edit_original_price').value = data.original_price || '';
            document.getElementById('edit_weight').value = data.weight || '';
            document.getElementById('edit_diet_type').value = data.diet_type;
            document.getElementById('editModal').style.display = 'block';
        }
    </script>
</body>

</html>
<?php ob_end_flush(); ?>
