<?php
ob_start();
include 'includes.php'; // Your admin header/sidebar include
include 'connection.php';
session_start();

// Check if admin is logged in
if (!isset($_SESSION['admin'])) {
    header('Location: index.php');
    exit;
}

// Bulk Delete Orders
if (isset($_POST['bulk_delete']) && isset($_POST['selected_items']) && !empty($_POST['selected_items'])) {
    $selectedIds = $_POST['selected_items'];

    foreach ($selectedIds as $id) {
        $id = (int)$id;
        // Get payment receipt path before deleting record
        $res = $conn->query("SELECT payment_receipt FROM product_orders WHERE id=$id");
        if ($res && $res->num_rows > 0) {
            $row = $res->fetch_assoc();
            $receipt = $row['payment_receipt'];

            // Delete the record from database first
            $conn->query("DELETE FROM product_orders WHERE id=$id");

            // Then delete receipt file if it exists
            if (!empty($receipt) && file_exists("../" . $receipt)) {
                unlink("../" . $receipt);
            }
        }
    }

    header("Location: manage_product_orders.php");
    exit;
}

// Delete Single Order
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];

    // Get payment receipt path before deleting record
    $res = $conn->query("SELECT payment_receipt FROM product_orders WHERE id=$id");
    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        $receipt = $row['payment_receipt'];

        // Delete the record from database
        $conn->query("DELETE FROM product_orders WHERE id=$id");

        // Delete file
        if (!empty($receipt) && file_exists("../" . $receipt)) {
            unlink("../" . $receipt);
        }
    }

    header("Location: manage_product_orders.php");
    exit;
}

// Pagination settings
$itemsPerPage = 20; // Items per page
$totalItems = $conn->query("SELECT COUNT(*) as cnt FROM product_orders")->fetch_assoc()['cnt'];
$totalPages = ceil($totalItems / $itemsPerPage);
$currentPage = isset($_GET['page']) ? max(1, min((int)$_GET['page'], $totalPages)) : 1;
$offset = ($currentPage - 1) * $itemsPerPage;

// Fetch Orders with Product Names
$sql = "SELECT o.*, p.name as product_name 
        FROM product_orders o 
        LEFT JOIN products p ON o.product_id = p.id 
        ORDER BY o.id DESC 
        LIMIT $offset, $itemsPerPage";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Product Orders</title>

    <!-- FontAwesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <!-- Export Libraries -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <style>
        /* Background & Container Styles */
        body {
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            margin: 0;
            padding: 0;
            font-family: sans-serif;
        }

        .spac-content {
            padding: 15px;
            min-height: 100vh;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .spac-management-container {
            max-width: 1400px;
            margin: auto;
        }

        .spac-management-title {
            font-size: 1.3rem;
            margin-bottom: 15px;
            color: white;
        }

        /* Action Buttons Container */
        .spac-actions-bar {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-bottom: 15px;
        }

        /* Table Styles */
        .spac-table-container {
            overflow-x: auto;
            border-radius: 8px;
            padding: 5px;
        }

        .spac-management-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.85rem;
        }

        .spac-management-table th {
            background: brown;
            color: white;
            padding: 12px 8px;
            text-align: left;
            font-weight: 600;
            white-space: nowrap;
        }

        .spac-management-table td {
            padding: 10px 8px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            vertical-align: middle;
            color: brown;
            font-weight: 500;
        }

        /* Buttons */
        .spac-btn {
            width: auto;
            height: 28px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            padding: 0 10px;
            font-size: 0.8rem;
            border: none;
            cursor: pointer;
            transition: opacity 0.2s;
        }

        .spac-btn:hover {
            opacity: 0.9;
        }

        .spac-delete-btn {
            background-color: #dc3545;
        }

        .spac-view-btn {
            background-color: #17a2b8;
        }

        #exportExcel {
            background-color: #28a745;
            border: 2px solid #28a745;
        }

        #bulkDeleteBtn {
            background-color: #dc3545;
        }

        /* Checkbox */
        .checkbox {
            width: 16px;
            height: 16px;
            cursor: pointer;
        }

        /* Pagination */
        .spac-pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
        }

        .spac-page-btn {
            min-width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 4px;
            text-decoration: none;
            color: white;
            background: rgba(0, 0, 0, 0.2);
            font-size: 0.85rem;
        }

        .spac-page-btn.active {
            background: #494948;
            color: white;
            font-weight: bold;
        }

        .spac-page-btn:hover {
            background: #a7c440;
        }

        /* Modal for Receipt */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.7);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 90%;
            max-width: 600px;
            border-radius: 8px;
            text-align: center;
        }

        .modal-content img {
            max-width: 100%;
            max-height: 70vh;
            border-radius: 4px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .close:hover {
            color: black;
        }
    </style>
</head>

<body>
    <div class="spac-content">
        <div class="spac-management-container">
            <h1 class="spac-management-title">Product Orders</h1>

            <!-- Action Buttons -->
            <div class="spac-actions-bar">
                <button id="exportExcel" class="spac-btn">
                    <i class="fas fa-file-excel"></i> &nbsp; Export Excel
                </button>
                <button id="bulkDeleteBtn" class="spac-btn" onclick="performBulkDelete()">
                    <i class="fas fa-trash"></i> &nbsp; Delete Selected
                </button>
            </div>

            <div class="spac-table-container">
                <form id="ordersForm" method="POST">
                    <input type="hidden" name="bulk_delete" value="1">

                    <table id="ordersTable" class="spac-management-table">
                        <thead>
                            <tr>
                                <th style="width: 30px;">
                                    <input type="checkbox" id="selectAll" class="checkbox">
                                </th>
                                <th>SR No</th> <!-- Changed from ID to SR No -->
                                <th>Customer</th>
                                <th>Contact</th>
                                <th>Product</th>
                                <th>Address</th>
                                <th>UPI ID</th>
                                <th>Receipt</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if ($result->num_rows > 0) {
                                // Calculate starting serial number based on current page
                                $srNo = $offset + 1;

                                while ($row = $result->fetch_assoc()) {
                            ?>
                                    <tr>
                                        <td>
                                            <input type="checkbox" name="selected_items[]" value="<?= $row['id'] ?>" class="checkbox item-checkbox">
                                        </td>
                                        <td><?= $srNo ?></td> <!-- Displaying SR No -->
                                        <td>
                                            <strong><?= htmlspecialchars($row['name']) ?></strong><br>
                                            <span style="font-size:0.75rem; opacity:0.8;"><?= htmlspecialchars($row['email']) ?></span>
                                        </td>
                                        <td><?= htmlspecialchars($row['phone']) ?></td>
                                        <td><?= htmlspecialchars($row['product_name'] ?? 'Unknown Product') ?></td>
                                        <td style="max-width: 200px; font-size: 0.8rem;">
                                            <?= htmlspecialchars(substr($row['address'], 0, 50)) ?>...
                                        </td>
                                        <td style="font-size: 0.75rem;"><?= htmlspecialchars($row['upi_transaction_id']) ?></td>
                                        <td>
                                            <?php if (!empty($row['payment_receipt'])): ?>
                                                <button type="button" class="spac-btn spac-view-btn" onclick="viewReceipt('<?= htmlspecialchars($row['payment_receipt']) ?>')">
                                                    <i class="fas fa-eye"></i> View
                                                </button>
                                            <?php else: ?>
                                                <span style="color: #ccc; font-style: italic;">N/A</span>
                                            <?php endif; ?>
                                        </td>
                                        <td style="white-space: nowrap;"><?= date('d M Y', strtotime($row['order_date'])) ?></td>
                                        <td>
                                            <a href="?delete=<?= $row['id'] ?>" onclick="return confirm('Are you sure you want to delete this order?')" class="spac-btn spac-delete-btn" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                            <?php
                                    $srNo++; // Increment SR No
                                }
                            } else {
                                echo "<tr><td colspan='10' style='text-align:center; padding:20px; color:white;'>No Orders Found</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </form>

                <!-- Pagination -->
                <?php if ($totalPages > 1): ?>
                    <div class="spac-pagination">
                        <?php if ($currentPage > 1): ?>
                            <a href="?page=<?= $currentPage - 1 ?>" class="spac-page-btn"><i class="fas fa-chevron-left"></i></a>
                        <?php endif; ?>

                        <?php
                        // Enhanced pagination logic for many pages
                        $startPage = max(1, $currentPage - 2);
                        $endPage = min($totalPages, $currentPage + 2);

                        if ($startPage > 1) {
                            echo '<a href="?page=1" class="spac-page-btn">1</a>';
                            if ($startPage > 2) echo '<span class="spac-page-btn" style="background:transparent;">...</span>';
                        }

                        for ($i = $startPage; $i <= $endPage; $i++):
                        ?>
                            <?php if ($i == $currentPage): ?>
                                <a href="?page=<?= $i ?>" class="spac-page-btn active"><?= $i ?></a>
                            <?php else: ?>
                                <a href="?page=<?= $i ?>" class="spac-page-btn"><?= $i ?></a>
                            <?php endif; ?>
                        <?php endfor; ?>

                        <?php
                        if ($endPage < $totalPages) {
                            if ($endPage < $totalPages - 1) echo '<span class="spac-page-btn" style="background:transparent;">...</span>';
                            echo '<a href="?page=' . $totalPages . '" class="spac-page-btn">' . $totalPages . '</a>';
                        }
                        ?>

                        <?php if ($currentPage < $totalPages): ?>
                            <a href="?page=<?= $currentPage + 1 ?>" class="spac-page-btn"><i class="fas fa-chevron-right"></i></a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Receipt View Modal -->
    <div id="receiptModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('receiptModal').style.display='none'">&times;</span>
            <h3 style="margin-bottom: 15px; color: #494948;">Payment Receipt</h3>
            <img id="receiptImage" src="" alt="Receipt">
        </div>
    </div>

    <script>
        // Select All Checkbox Logic
        document.getElementById('selectAll').addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('.item-checkbox');
            checkboxes.forEach(cb => cb.checked = this.checked);
        });

        // Bulk Delete Logic
        function performBulkDelete() {
            const selectedItems = document.querySelectorAll('.item-checkbox:checked');
            if (selectedItems.length === 0) {
                alert('Please select at least one order to delete.');
                return;
            }
            if (confirm('Are you sure you want to delete ' + selectedItems.length + ' selected orders? This cannot be undone.')) {
                document.getElementById('ordersForm').submit();
            }
        }

        // View Receipt Logic
        function viewReceipt(imagePath) {
            const fullPath = '../' + imagePath;
            document.getElementById('receiptImage').src = fullPath;
            document.getElementById('receiptModal').style.display = 'block';
        }

        // Export to Excel
        document.getElementById('exportExcel').addEventListener('click', function() {
            let table = document.getElementById('ordersTable');
            let tableCopy = table.cloneNode(true);

            // Remove checkbox and Actions columns for clean export
            let rows = tableCopy.querySelectorAll('tr');
            rows.forEach(row => {
                if (row.cells.length > 0) {
                    row.deleteCell(0); // Delete Checkbox column
                    // Note: We keep SR No, but remove Action column
                    // Since we deleted cell 0, the indices shift.
                    // Action is now the last cell.
                    if (row.cells.length > 0) {
                        row.deleteCell(-1); // Delete Actions
                    }
                }
            });

            let wb = XLSX.utils.table_to_book(tableCopy, {
                sheet: "Orders"
            });
            XLSX.writeFile(wb, 'Product_Orders.xlsx');
        });
    </script>
</body>

</html>