<?php
ob_start();
include 'includes.php';
include 'connection.php';
session_start();

if (!isset($_SESSION['admin'])) {
    header('Location: index.php');
    exit;
}

// Pagination setup
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 12;
$offset = ($page - 1) * $per_page;

// Delete Image
if (isset($_GET['delete_image'])) {
    $id = (int)$_GET['delete_image'];
    $res = $conn->query("SELECT image FROM gallery_images WHERE id=$id");
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        if (file_exists("../" . $row['image'])) unlink("../" . $row['image']);
    }
    $conn->query("DELETE FROM gallery_images WHERE id=$id");
    header("Location: manage_gallery.php?page=" . ($page));
    exit;
}

// Delete Category
if (isset($_GET['delete_category'])) {
    $id = (int)$_GET['delete_category'];

    // Delete all images in this category
    $images = $conn->query("SELECT image FROM gallery_images WHERE category_id=$id");
    while ($img = $images->fetch_assoc()) {
        if (file_exists("../" . $img['image'])) unlink("../" . $img['image']);
    }
    $conn->query("DELETE FROM gallery_images WHERE category_id=$id");
    $conn->query("DELETE FROM gallery_categories WHERE id=$id");
    header("Location: manage_gallery.php");
    exit;
}

// Toggle Image Status
if (isset($_GET['toggle_image'])) {
    $id = (int)$_GET['toggle_image'];
    $conn->query("UPDATE gallery_images SET status = 1-status WHERE id=$id");
    header("Location: manage_gallery.php?page=" . ($page));
    exit;
}

// Toggle Category Status
if (isset($_GET['toggle_category'])) {
    $id = (int)$_GET['toggle_category'];
    $conn->query("UPDATE gallery_categories SET status = 1-status WHERE id=$id");
    header("Location: manage_gallery.php");
    exit;
}

// Add/Edit Category
if (isset($_POST['save_category'])) {
    $name = $conn->real_escape_string($_POST['category_name']);
    $slug = strtolower(preg_replace('/[^a-zA-Z0-9]/', '-', $name));

    if (isset($_POST['edit_category_id']) && !empty($_POST['edit_category_id'])) {
        $id = (int)$_POST['edit_category_id'];
        $conn->query("UPDATE gallery_categories SET name='$name', slug='$slug' WHERE id=$id");
    } else {
        $conn->query("INSERT INTO gallery_categories (name, slug) VALUES ('$name', '$slug')");
    }
    header("Location: manage_gallery.php");
    exit;
}

// Add Images
if (isset($_POST['upload_images'])) {
    $category_id = (int)$_POST['category_id'];
    $targetDir = "../assets/gallery/";
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

    $uploaded = 0;
    foreach ($_FILES['images']['name'] as $key => $name) {
        if (!empty($name)) {
            $fileName = time() . "_" . basename($name);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES['images']['tmp_name'][$key], $targetFile)) {
                $dbPath = "assets/gallery/" . $fileName;
                $conn->query("INSERT INTO gallery_images (category_id, image) VALUES ($category_id, '$dbPath')");
                $uploaded++;
            }
        }
    }
    header("Location: manage_gallery.php?page=" . ($page));
    exit;
}

// Get categories
$categories = $conn->query("SELECT * FROM gallery_categories ORDER BY id ASC");

// Get total images
$total_query = $conn->query("SELECT COUNT(*) as total FROM gallery_images");
$total = $total_query->fetch_assoc()['total'];
$total_pages = ceil($total / $per_page);

// Get images with category names
$result = $conn->query("SELECT gi.*, gc.name as category_name 
                        FROM gallery_images gi 
                        JOIN gallery_categories gc ON gi.category_id = gc.id 
                        ORDER BY gi.id DESC LIMIT $per_page OFFSET $offset");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manage Gallery</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            margin: 0;
            padding: 0;
            font-family: sans-serif;
        }

        .spac-content {
            padding: 15px;
            min-height: 100vh;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .spac-management-container {
            max-width: 1200px;
            margin: auto;
        }

        .spac-management-title {
            font-size: 1.3rem;
            margin-bottom: 15px;
            color: white;
        }

        /* Tabs */
        .tab-container {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }

        .tab-btn {
            padding: 10px 25px;
            background: brown;
            border: 1px solid brown;
            color: white;
            cursor: pointer;
            border-radius: 4px;
            font-size: 14px;
        }

        .tab-btn.active,
        .tab-btn:hover {
            background: brown;
            border-color: brown;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Form Styles */
        .form-row {
            display: flex;
            gap: 10px;
            margin-bottom: 15px;
            flex-wrap: wrap;
            align-items: flex-end;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }

        .spac-input {
            padding: 8px 12px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 0.85rem;
            min-width: 200px;
        }

        .spac-btn {
            padding: 8px 16px;
            background: brown;
            color: #fff;
            border: 1px solid white;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }

        .spac-btn:hover {
            background: #8B0000;
        }

        /* Table Styles */
        .spac-table-container {
            overflow-x: auto;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 8px;
            margin-top: 15px;
        }

        .spac-management-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.85rem;
        }

        .spac-management-table th {
            background: brown;
            color: white;
            padding: 10px 8px;
            text-align: left;
        }

        .spac-management-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #eee;
            color: brown;
            vertical-align: middle;
            font-weight: 500;
        }

        .action-btn {
            width: 28px;
            height: 28px;
            border-radius: 4px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            margin-right: 5px;
            border: none;
            cursor: pointer;
            font-size: 12px;
        }

        .btn-toggle {
            background-color: #17a2b8;
        }

        .btn-delete {
            background-color: #dc3545;
        }

        .btn-edit {
            background-color: #ffc107;
            color: #212529;
        }

        .status-badge {
            padding: 3px 10px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 500;
        }

        .status-active {
            background: #d4edda;
            color: #155724;
        }

        .status-inactive {
            background: #fff3cd;
            color: #856404;
        }

        /* Gallery Grid */
        .gallery-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 15px;
            margin-top: 15px;
        }

        .gallery-item {
            background: white;
            border-radius: 8px;
            overflow: hidden;
            position: relative;
        }

        .gallery-item img {
            width: 100%;
            height: 150px;
            object-fit: cover;
        }

        .gallery-item-info {
            padding: 10px;
        }

        .gallery-item-info small {
            color: #666;
        }

        .gallery-item-actions {
            position: absolute;
            top: 5px;
            right: 5px;
            display: flex;
            gap: 5px;
        }

        /* File Input */
        .file-input-wrapper {
            position: relative;
            overflow: hidden;
            display: inline-block;
        }

        .file-input-wrapper input[type=file] {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            cursor: pointer;
            width: 100%;
            height: 100%;
        }

        /* Pagination */
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 5px;
        }

        .pagination a,
        .pagination span {
            padding: 8px 12px;
            background: rgba(255, 255, 255, 0.9);
            color: brown;
            text-decoration: none;
            border-radius: 4px;
            border: 1px solid #ddd;
        }

        .pagination a:hover {
            background: brown;
            color: white;
        }

        .pagination .current {
            background: brown;
            color: white;
            font-weight: bold;
        }

        @media (max-width: 768px) {
            .gallery-grid {
                grid-template-columns: repeat(2, 1fr);
            }

            .spac-input {
                min-width: 100%;
            }
        }
    </style>
</head>

<body>
    <div class="spac-content">
        <div class="spac-management-container">
            <h1 class="spac-management-title">Manage Gallery</h1>

            <!-- Tabs -->
            <div class="tab-container">
                <button class="tab-btn active" onclick="switchTab('images')">
                    <i class="fas fa-images"></i> Images
                </button>
                <button class="tab-btn" onclick="switchTab('categories')">
                    <i class="fas fa-folder"></i> Categories
                </button>
            </div>

            <!-- Images Tab -->
            <div id="images-tab" class="tab-content active">
                <!-- Upload Form -->
                <div class="form-row">
                    <div class="form-group">
                        <label style="color:white; font-size:13px; font-weight:500">Category</label>
                        <select id="category_id" class="spac-input">
                            <?php
                            $cats = $conn->query("SELECT * FROM gallery_categories WHERE status=1");
                            while ($cat = $cats->fetch_assoc()) {
                                echo '<option value="' . $cat['id'] . '">' . htmlspecialchars($cat['name']) . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label style="color:black; font-size:13px; font-weight:500">Select Images</label>
                        <div class="file-input-wrapper">
                            <button class="spac-btn"><i class="fas fa-upload"></i> Choose Files</button>
                            <input type="file" id="images" multiple accept="image/*" onchange="updateFileLabel(this)">
                        </div>
                        <small id="fileLabel" style="color:#ccc; margin-left:10px;"></small>
                    </div>
                    <button class="spac-btn" onclick="uploadImages()">
                        <i class="fas fa-plus"></i> Upload Images
                    </button>
                </div>

                <!-- Gallery Grid -->
                <div class="gallery-grid">
                    <?php
                    $img_result = $conn->query("SELECT gi.*, gc.name as category_name 
                                                 FROM gallery_images gi 
                                                 JOIN gallery_categories gc ON gi.category_id = gc.id 
                                                 ORDER BY gi.id DESC LIMIT $per_page OFFSET $offset");
                    while ($row = $img_result->fetch_assoc()):
                    ?>
                        <div class="gallery-item">
                            <img src="../<?= htmlspecialchars($row['image']) ?>" alt="">
                            <div class="gallery-item-actions">
                                <a href="?page=<?= $page ?>&toggle_image=<?= $row['id'] ?>" class="action-btn btn-toggle">
                                    <i class="fas fa-<?= $row['status'] ? 'ban' : 'check' ?>"></i>
                                </a>
                                <a href="?page=<?= $page ?>&delete_image=<?= $row['id'] ?>"
                                    onclick="return confirm('Delete this image?')" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                            <div class="gallery-item-info">
                                <small><?= htmlspecialchars($row['category_name']) ?></small>
                                <span class="status-badge <?= $row['status'] ? 'status-active' : 'status-inactive' ?>">
                                    <?= $row['status'] ? 'Active' : 'Inactive' ?>
                                </span>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <!-- Pagination -->
                <?php if ($total_pages > 1): ?>
                    <div class="pagination">
                        <?php if ($page > 1): ?>
                            <a href="?page=1">First</a>
                            <a href="?page=<?= $page - 1 ?>">Prev</a>
                        <?php endif; ?>

                        <?php for ($i = max(1, $page - 2); $i <= min($total_pages, $page + 2); $i++): ?>
                            <?php if ($i == $page): ?>
                                <span class="current"><?= $i ?></span>
                            <?php else: ?>
                                <a href="?page=<?= $i ?>"><?= $i ?></a>
                            <?php endif; ?>
                        <?php endfor; ?>

                        <?php if ($page < $total_pages): ?>
                            <a href="?page=<?= $page + 1 ?>">Next</a>
                            <a href="?page=<?= $total_pages ?>">Last</a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Categories Tab -->
            <div id="categories-tab" class="tab-content">
                <!-- Add Category Form -->
                <div class="form-row">
                    <div class="form-group">
                        <label style="color:white; font-size:13px;">Category Name</label>
                        <input type="text" id="category_name" class="spac-input" placeholder="Enter category name">
                    </div>
                    <input type="hidden" id="edit_category_id" value="">
                    <button class="spac-btn" onclick="saveCategory()">
                        <i class="fas fa-plus"></i> <span id="catBtnText">Add Category</span>
                    </button>
                    <button class="spac-btn" id="cancelEditBtn" style="display:none; background:#6c757d;" onclick="cancelEdit()">
                        Cancel
                    </button>
                </div>

                <!-- Categories Table -->
                <div class="spac-table-container">
                    <table class="spac-management-table">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Category Name</th>
                                <th>Slug</th>
                                <th>Images</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $cat_result = $conn->query("SELECT gc.*, 
                                                        (SELECT COUNT(*) FROM gallery_images WHERE category_id = gc.id) as image_count 
                                                        FROM gallery_categories gc ORDER BY id ASC");
                            $sno = 1;
                            while ($row = $cat_result->fetch_assoc()):
                            ?>
                                <tr>
                                    <td><?= $sno++ ?></td>
                                    <td><?= htmlspecialchars($row['name']) ?></td>
                                    <td><?= htmlspecialchars($row['slug']) ?></td>
                                    <td><?= $row['image_count'] ?></td>
                                    <td>
                                        <span class="status-badge <?= $row['status'] ? 'status-active' : 'status-inactive' ?>">
                                            <?= $row['status'] ? 'Active' : 'Inactive' ?>
                                        </span>
                                    </td>
                                    <td>
                                        <button class="action-btn btn-edit" onclick="editCategory(<?= $row['id'] ?>, '<?= htmlspecialchars($row['name'], ENT_QUOTES) ?>')">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <a href="?toggle_category=<?= $row['id'] ?>" class="action-btn btn-toggle">
                                            <i class="fas fa-<?= $row['status'] ? 'ban' : 'check' ?>"></i>
                                        </a>
                                        <a href="?delete_category=<?= $row['id'] ?>"
                                            onclick="return confirm('Delete this category and all its images?')"
                                            class="action-btn btn-delete">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div><br><br><br><br><br><br>  

    <!-- Hidden Form for Upload -->
    <form id="uploadForm" method="POST" enctype="multipart/form-data" style="display:none;">
        <input type="hidden" name="category_id" id="form_category_id">
        <input type="hidden" name="upload_images" value="1">
        <input type="file" name="images[]" id="form_images" multiple>
    </form>

    <!-- Hidden Form for Category -->
    <form id="categoryForm" method="POST" style="display:none;">
        <input type="hidden" name="save_category" value="1">
        <input type="hidden" name="edit_category_id" id="form_edit_category_id">
        <input type="text" name="category_name" id="form_category_name">
    </form>

    <script>
        function switchTab(tab) {
            document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));

            event.target.classList.add('active');
            document.getElementById(tab + '-tab').classList.add('active');
        }

        function updateFileLabel(input) {
            const label = document.getElementById('fileLabel');
            if (input.files.length > 0) {
                label.textContent = input.files.length + ' file(s) selected';
            } else {
                label.textContent = '';
            }
        }

        function uploadImages() {
            const categoryId = document.getElementById('category_id').value;
            const fileInput = document.getElementById('images');

            if (!fileInput.files.length) {
                alert('Please select at least one image');
                return;
            }

            document.getElementById('form_category_id').value = categoryId;

            const formFiles = document.getElementById('form_images');
            const dataTransfer = new DataTransfer();
            for (let i = 0; i < fileInput.files.length; i++) {
                dataTransfer.items.add(fileInput.files[i]);
            }
            formFiles.files = dataTransfer.files;

            document.getElementById('uploadForm').submit();
        }

        function saveCategory() {
            const name = document.getElementById('category_name').value.trim();
            const editId = document.getElementById('edit_category_id').value;

            if (!name) {
                alert('Please enter category name');
                return;
            }

            document.getElementById('form_category_name').value = name;
            document.getElementById('form_edit_category_id').value = editId;
            document.getElementById('categoryForm').submit();
        }

        function editCategory(id, name) {
            document.getElementById('category_name').value = name;
            document.getElementById('edit_category_id').value = id;
            document.getElementById('catBtnText').textContent = 'Update Category';
            document.getElementById('cancelEditBtn').style.display = 'inline-block';
        }

        function cancelEdit() {
            document.getElementById('category_name').value = '';
            document.getElementById('edit_category_id').value = '';
            document.getElementById('catBtnText').textContent = 'Add Category';
            document.getElementById('cancelEditBtn').style.display = 'none';
        }
    </script>
</body>

</html>
<?php ob_end_flush(); ?>