<?php
ob_start();
session_start();
include 'includes.php';
require_once "connection.php";

// Check if admin is logged in
if (!isset($_SESSION['admin'])) {
    header('Location: index.php');
    exit;
}

$message = "";
$sql = "SELECT * FROM admin LIMIT 1";
$res = $conn->query($sql);
$admin = $res->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_user = trim($_POST['username']);
    $new_email = trim($_POST['email']); // ✅ new email field
    $new_pass = trim($_POST['password']);
    $enteredCaptcha = trim($_POST['captcha']);
    $generatedCaptcha = $_POST['generatedCaptcha'];

    if ($enteredCaptcha !== $generatedCaptcha) {
        $message = "Invalid Captcha!";
    } else {
        // Handle image upload
        $new_img = $admin['image']; // default
        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $targetDir = "../assets/uploads/";
            if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);
            $fileName = time() . "_" . basename($_FILES["image"]["name"]);
            $targetFile = $targetDir . $fileName;
            if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile)) {
                $new_img = $targetFile;
            }
        }

        // ✅ Updated query to include email
        $update = $conn->prepare("UPDATE admin SET username=?, email=?, password=?, image=? WHERE id=?");
        $update->bind_param("ssssi", $new_user, $new_email, $new_pass, $new_img, $admin['id']);
        $update->execute();
        $update->close();

        $message = "Updated successfully!";
        $res = $conn->query("SELECT * FROM admin LIMIT 1");
        $admin = $res->fetch_assoc();
    }
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Management</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
             background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        a {
            text-decoration: none;
        }

        .admin-manage-container {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .admin-manage-box {
            display: flex;
            flex-direction: row;
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            max-width: 600px;
            width: 100%;
            animation: fadeIn 0.8s ease-in-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .admin-manage-left {
            flex: 0.8;
              background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            padding: 30px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            text-align: center;
        }

        .admin-manage-left h1 {
            font-size: 19px;
            margin-bottom: 10px;
            font-weight: 700;
            color: brown;
        }

        .admin-manage-left p {
            font-size: 14px;
            margin-bottom: 20px;
            opacity: 0.9;
            font-weight: 600;
            color: brown;
        }

        .admin-manage-left .admin-image-container {
            width: auto;
            height: auto;
            overflow: hidden;
            margin-bottom: 15px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .admin-manage-left .admin-image-container:hover {
            transform: scale(1.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .admin-manage-left img {
            width: 100%;
            height: auto;
            object-fit: cover;
            border-radius: 10px;
        }

        .social-icons {
            display: flex;
            gap: 10px;
            margin-top: 15px;
        }

        .social-icons a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            color: white;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .social-icons a:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-3px);
        }

        .admin-manage-right {
            flex: 1.2;
            padding: 30px;
            background: brown;
        }

        .admin-manage-form h2 {
            margin-bottom: 20px;
            font-size: 20px;
            color: white;
            text-align: center;
            position: relative;
            padding-bottom: 10px;
        }

        .admin-manage-form h2:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 50px;
            height: 3px;
            background: white;
            border-radius: 3px;
        }

        .form-group {
            margin-bottom: 15px;
            position: relative;
        }

        .form-group i {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: brown;
            transition: color 0.3s ease;
        }

        .admin-manage-form input {
            width: 100%;
            padding: 10px 12px 10px 35px;
            font-size: 14px;
            border: 1px solid #ddd;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .admin-manage-form input:focus {
            border-color: brown;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
            outline: none;
        }

        .admin-manage-form input:focus+i {
            color: brown;
        }

        .file-input-wrapper {
            position: relative;
            margin-bottom: 15px;
        }

        .file-input-wrapper input[type="file"] {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
            color: brown;
        }

        .file-input-label {
            display: block;
            padding: 10px 12px 10px 35px;
            font-size: 14px;
            border: 1px solid #ddd;
            border-radius: 8px;
            background: #fff;
            color: brown;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .file-input-label:hover {
            border-color: #494948;
            background: #f8f9fa;
        }

        .file-input-label i {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: brown;
        }

        .captcha-row {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-top: 10px;
        }

        .captcha-box {
            background: #f8f9fa;
            padding: 8px 10px;
            border-radius: 8px;
            font-weight: bold;
            font-size: 14px;
            color: brown;
            letter-spacing: 2px;
            flex: 1;
            text-align: center;
            border: 1px solid #e9ecef;
        }

        .captcha-row input {
            flex: 1.5;
            padding: 10px;
            font-size: 14px;
            border: 1px solid #494948;
            border-radius: 8px;
            transition: all 0.3s ease;
            color: brown;
        }

        .captcha-row input:focus {
            border-color: brown;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
            outline: none;
        }

        .captcha-row button {
            padding: 10px 15px;
            background: brown;
            color: #fff;
            border: 2px solid white;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .captcha-row button:hover {
             
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .admin-manage-success {
            color: #27ae60;
            margin-bottom: 15px;
            font-size: 13px;
            padding: 8px;
            background: #f0fff4;
            border-radius: 6px;
            border-left: 4px solid #27ae60;
            animation: shake 0.5s ease-in-out;
        }

        .admin-manage-error {
            color: #e74c3c;
            margin-bottom: 15px;
            font-size: 13px;
            padding: 8px;
            background: #fdf2f2;
            border-radius: 6px;
            border-left: 4px solid #e74c3c;
            animation: shake 0.5s ease-in-out;
        }

        @keyframes shake {

            0%,
            100% {
                transform: translateX(0);
            }

            10%,
            30%,
            50%,
            70%,
            90% {
                transform: translateX(-5px);
            }

            20%,
            40%,
            60%,
            80% {
                transform: translateX(5px);
            }
        }

        @media(max-width:768px) {
            .admin-manage-box {
                flex-direction: column;
            }

            .admin-manage-left {
                padding: 20px 15px;
            }

            .admin-manage-right {
                padding: 20px 15px;
            }
        }
    </style>
</head>

<body>
    <div class="admin-manage-container">
        <div class="admin-manage-box">
            <div class="admin-manage-left">
                <div class="admin-image-container">
                    <img src="<?php echo $admin['image']; ?>" alt="Admin Image">
                </div>
                <h1>Admin Management</h1>
                <p>Update Admin Profile</p>
                <div class="social-icons">
                    <a href="https://www.facebook.com/profile.php?id=61581146425144" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="https://x.com/sapnex" title="Twitter" target="_blank"><i class="fab fa-twitter"></i></a>
                    <a href="https://www.linkedin.com/company/sapnex/?viewAsMember=true" title="LinkedIn" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                    <a href="https://www.instagram.com/sapne_x/" title="Instagram" target="_blank"><i class="fab fa-instagram"></i></a>
                </div>
            </div>
            <div class="admin-manage-right">
                <div class="admin-manage-form">
                    <h2>Update Admin</h2>
                    <?php if ($message): ?>
                        <div class="<?php echo strpos($message, 'successfully') !== false ? 'admin-manage-success' : 'admin-manage-error'; ?>">
                            <?php echo $message; ?>
                        </div>
                    <?php endif; ?>
                    <form method="POST" enctype="multipart/form-data" onsubmit="return checkCaptcha();">
                        <div class="form-group">
                            <input type="text" name="username" value="<?php echo $admin['username']; ?>" required>
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="form-group">
                            <input type="email" name="email" value="<?php echo $admin['email']; ?>" placeholder="Enter Admin Email" required>
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="form-group">
                            <input type="text" name="password" value="<?php echo $admin['password']; ?>" required>
                            <i class="fas fa-lock"></i>
                        </div>
                        <div class="file-input-wrapper">
                            <input type="file" name="image" id="image" accept="image/*">
                            <label for="image" class="file-input-label">
                                <i class="fas fa-image"></i>
                                <span id="file-name">Choose Profile Image</span>
                            </label>
                        </div>
                        <div class="captcha-row">
                            <div class="captcha-box" id="captchaText"></div>
                            <input type="hidden" name="generatedCaptcha" id="generatedCaptcha">
                            <input type="text" name="captcha" placeholder="Enter Captcha" required>
                            <button type="submit"><i class="fas fa-sync-alt"></i> Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div><br>
    <script>
        function generateCaptcha() {
            let code = Math.floor(100 + Math.random() * 900);
            document.getElementById("captchaText").innerText = code;
            document.getElementById("generatedCaptcha").value = code;
        }

        function checkCaptcha() {
            let entered = document.querySelector('input[name="captcha"]').value;
            let generated = document.getElementById("generatedCaptcha").value;
            if (entered !== generated) {
                alert("Invalid Captcha!");
                return false;
            }
            return true;
        }
        document.getElementById('image').addEventListener('change', function() {
            let fileName = this.files[0] ? this.files[0].name : 'Choose Profile Image';
            document.getElementById('file-name').textContent = fileName;
        });
        generateCaptcha();
    </script>
</body>

</html>