<?php
ob_start();
session_start();
require_once "connection.php";
$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $enteredCaptcha = trim($_POST['captcha']);
    $generatedCaptcha = $_POST['generatedCaptcha'];
    if ($enteredCaptcha !== $generatedCaptcha) {
        $message = "Invalid Captcha!";
    } else {
        $sql = "SELECT * FROM admin WHERE username=? AND password=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $username, $password);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 1) {
            $_SESSION['admin'] = $username;
            header("Location: dashboard.php");
            exit;
        } else {
            $message = "Invalid credentials!";
        }
        $stmt->close();
    }
}

// Handle password reset
$reset_message = "";
$show_success_notification = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reset_password'])) {
    $uname = trim($_POST['reset_username']);
    $email = trim($_POST['reset_email']);
    $new_pass = trim($_POST['new_password']);
    $sql = "SELECT * FROM admin WHERE username=? AND email=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $uname, $email);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows === 1) {
        $update = $conn->prepare("UPDATE admin SET password=? WHERE username=? AND email=?");
        $update->bind_param("sss", $new_pass, $uname, $email);
        $update->execute();
        $reset_message = "Password successfully reset!";
        $show_success_notification = true;
    } else {
        $reset_message = "Invalid username or email!";
    }
}

$sql = "SELECT * FROM admin LIMIT 1";
$res = $conn->query($sql);
$admin = $res->fetch_assoc();
$imagePath = (!empty($admin['image'])) ? $admin['image'] : "uploads/default.png";
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="../assets/images/logo.pnglogo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="../assets/images/logo.pnglogo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="../assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="../assets/images/logo.png">
    <link rel="apple-touch-icon" href="../assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Carter+One&family=Concert+One&family=Laila:wght@300;400;500;600;700&family=Lobster&family=Permanent+Marker&family=Rowdies:wght@300;400;700&family=Rubik+Wet+Paint&family=Satisfy&display=swap');
    </style>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: "Laila", serif;
            margin: 0;
            padding: 0;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        a {
            text-decoration: none;
        }

        .admin-login-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .admin-login-box {
            display: flex;
            flex-direction: row;
            font-family: "Laila", serif;
            margin: 0;
            padding: 0;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            max-width: 800px;
            width: 100%;
            animation: fadeIn 0.8s ease-in-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Left Side with Video Background */
        .admin-login-left {
            position: relative;
            flex: 1;
            overflow: hidden;
            color: brown;
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            padding: 40px;
        }

        .admin-login-left video {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: 0;
        }

        .admin-login-left .content {
            position: relative;
            z-index: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .admin-login-left .admin-image-container {
            width: auto;
            height: auto;
            overflow: hidden;
            margin: 0 auto 25px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }



        .admin-login-left img {
            width: 200px;
            height: auto;
            object-fit: cover;
            border-radius: 10px;
        }

        .admin-login-left h1 {
            font-size: 20px;
            margin-bottom: 5px;
            font-weight: 700;
        }

        .admin-login-left p {
            font-size: 30px;
            margin-bottom: 10px;
            opacity: 0.9;
            font-weight: 700;
        }

        .social-icons {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 20px;
        }

        .social-icons a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.15);
            color: white;
            background-color: brown;
            font-size: 18px;
            transition: all 0.3s ease;
        }

        .social-icons a:hover {
            transform: translateY(-3px);
        }

        .admin-login-right {
            flex: 1;
            padding: 40px;
            background: brown;
        }

        .admin-login-form h2 {
            margin-bottom: 25px;
            font-size: 24px;
            color: white;
            text-align: center;
            position: relative;
            padding-bottom: 10px;
        }

        .admin-login-form h2:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 50px;
            height: 3px;
            background: white;
            border-radius: 3px;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-group i {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: brown;
        }

        .admin-login-form input {
            width: 100%;
            padding: 12px 12px 12px 40px;
            font-size: 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .admin-login-form input:focus {
            border-color: brown;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
            outline: none;
        }

        .captcha-row {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 10px;
        }

        .captcha-box {
            background: #f8f9fa;
            padding: 10px 15px;
            border-radius: 8px;
            font-weight: bold;
            font-size: 16px;
            color: brown;
            letter-spacing: 2px;
            flex: 1;
            text-align: center;
            border: 1px solid #e9ecef;
        }

        .captcha-row input {
            flex: 2;
            padding: 12px;
            font-size: 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
        }

        .captcha-row button {
            padding: 12px 20px;
            background: white;
            color: brown;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 15px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .captcha-row button:hover {
            background: white;
            transform: translateY(-2px);
        }

        .admin-login-error {
            color: #e74c3c;
            margin-bottom: 15px;
            font-size: 14px;
            padding: 10px;
            background: #fdf2f2;
            border-radius: 6px;
            border-left: 4px solid #e74c3c;
        }

        .login-instructions {
            margin-top: 20px;
            padding: 15px;
            background: white;
            border-radius: 8px;
            border-left: 4px solid black;
            font-size: 14px;
            color: brown;
            text-align: left;
            font-weight: 500;
        }

        .login-instructions i {
            color: #494948;
            margin-right: 8px;
        }

        @media(max-width:768px) {
            .admin-login-box {
                flex-direction: column;
            }

            .admin-login-left video {
                display: none;
            }
        }

        .forgot-password-link {
            text-align: right;
            margin-top: 10px;
            font-size: 14px;
        }

        .forgot-password-link a {
            color: white;
            text-decoration: none;
            font-weight: 600;
        }

        .forgot-password-link a:hover {
            text-decoration: underline;
        }

        /* Popup overlay */
        .popup-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        /* Popup box */
        .popup-box {
            background: brown;
            border-radius: 15px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
            width: 350px;
            max-width: 90%;
            padding: 25px;
            animation: popIn 0.4s ease-in-out;
            text-align: center;
            position: relative;
        }

        @keyframes popIn {
            from {
                opacity: 0;
                transform: scale(0.8);
            }

            to {
                opacity: 1;
                transform: scale(1);
            }
        }

        .popup-box h3 {
            margin-bottom: 15px;
            color: white;
        }

        .popup-box input {
            width: 100%;
            padding: 10px;
            margin-bottom: 12px;
            border-radius: 8px;
            border: 1px solid #ccc;
        }

        .popup-box button {
            width: 100%;
            padding: 10px;
            background: brown;
            border: 2px solid white;
            color: white;
            font-weight: 600;
            border-radius: 8px;
            cursor: pointer;
            transition: 0.3s;
        }



        .popup-close {
            position: absolute;
            top: 15px;
            right: 20px;
            font-size: 18px;
            color: white;
            cursor: pointer;
        }

        .reset-message {
            font-size: 14px;
            margin-top: 10px;
            color: green;
        }

        .error-message {
            font-size: 14px;
            margin-top: 10px;
            color: red;
        }

        /* Success notification */
        .success-notification {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #2ecc71;
            color: brown;
            padding: 15px 20px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            z-index: 10000;
            display: flex;
            align-items: center;
            gap: 10px;
            animation: slideIn 0.5s ease-out;
        }

        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }

            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        .success-notification i {
            font-size: 20px;
        }

        .success-notification .close-btn {
            margin-left: 15px;
            cursor: pointer;
            font-size: 18px;
        }
    </style>
</head>

<body>
    <div class="admin-login-container">
        <div class="admin-login-box">
            <div class="admin-login-left">
                <video autoplay muted loop playsinline>
                    <source src="../assets/images/admin-video.mp4" type="video/mp4">
                </video>
                <div class="content">
                    <div class="admin-image-container">
                        <img src="<?php echo htmlspecialchars($imagePath); ?>" alt="Admin Image">
                    </div>
                    <h1>Welcome To Admin Portal...!!</h1>
                    <p>OneChef® India</p>
                    <div class="social-icons">
                        <a href="#" target="_blank"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" target="_blank"><i class="fab fa-twitter"></i></a>
                        <a href="#" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#" target="_blank"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>

            <div class="admin-login-right">
                <div class="admin-login-form">
                    <h2>Admin Login</h2>
                    <?php if ($message): ?>
                        <div class="admin-login-error"><?php echo $message; ?></div>
                    <?php endif; ?>
                    <form method="POST" onsubmit="return checkCaptcha();">
                        <input type="hidden" name="login" value="1">
                        <div class="form-group">
                            <input type="text" name="username" placeholder="Username" required>
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="form-group">
                            <input type="password" name="password" placeholder="Password" required>
                            <i class="fas fa-lock"></i>
                        </div>
                        <div class="captcha-row">
                            <div class="captcha-box" id="captchaText"></div>
                            <input type="hidden" name="generatedCaptcha" id="generatedCaptcha">
                            <input type="text" name="captcha" placeholder="Enter Captcha" required>
                            <button type="submit"><i class="fas fa-sign-in-alt"></i> Login</button>
                        </div>
                    </form>

                    <div class="login-instructions">
                        <i class="fas fa-info-circle"></i>
                        Security Notice: This login page is protected with captcha verification.
                    </div>
                    <div class="forgot-password-link">
                        <a href="#" onclick="openPopup()" style="text-decoration: none;">Forgot / Reset Password?</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- POPUP STRUCTURE -->
    <div class="popup-overlay" id="popup">
        <div class="popup-box">
            <span class="popup-close" onclick="closePopup()">&times;</span>
            <h3>Reset Password</h3>
            <form method="POST">
                <input type="text" name="reset_username" placeholder="Enter Username" required>
                <input type="email" name="reset_email" placeholder="Enter Admin Email" required>
                <input type="password" name="new_password" placeholder="Enter New Password" required>
                <button type="submit" name="reset_password">Reset Password</button>
            </form>
            <?php if (!empty($reset_message)): ?>
                <div class="<?php echo (strpos($reset_message, 'success') !== false) ? 'reset-message' : 'error-message'; ?>">
                    <?php echo $reset_message; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Success Notification -->
    <?php if ($show_success_notification): ?>
        <div class="success-notification" id="successNotification">
            <i class="fas fa-check-circle"></i>
            <span>Password reset successfully! You can now login with your new password.</span>
            <span class="close-btn" onclick="closeSuccessNotification()">&times;</span>
        </div>
    <?php endif; ?>

    <script>
        function generateCaptcha() {
            let code = Math.floor(100 + Math.random() * 900);
            document.getElementById("captchaText").innerText = code;
            document.getElementById("generatedCaptcha").value = code;
        }

        function checkCaptcha() {
            let entered = document.querySelector('input[name="captcha"]').value;
            let generated = document.getElementById("generatedCaptcha").value;
            if (entered !== generated) {
                alert("Invalid Captcha!");
                return false;
            }
            return true;
        }

        function openPopup() {
            document.getElementById("popup").style.display = "flex";
        }

        function closePopup() {
            document.getElementById("popup").style.display = "none";
        }

        function closeSuccessNotification() {
            document.getElementById("successNotification").style.display = "none";
        }

        // Auto hide success notification after 5 seconds
        window.onload = function() {
            const notification = document.getElementById("successNotification");
            if (notification) {
                setTimeout(function() {
                    notification.style.display = "none";
                }, 5000);
            }
        };

        generateCaptcha();
    </script>
</body>

</html>